/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.IRunOnceQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.ViatraQueryModelUpdateListener;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.emf.EMFScope;

public class RunOnceQueryEngine
implements IRunOnceQueryEngine {
    private Notifier notifier;
    private RunOnceBaseIndexOptions baseIndexOptions;
    private AdvancedViatraQueryEngine engine;
    private boolean reSamplingNeeded = false;
    protected boolean samplingMode = false;
    private RunOnceSamplingModelUpdateListener modelUpdateListener;

    public RunOnceQueryEngine(Notifier notifier) {
        this.notifier = notifier;
        this.baseIndexOptions = new RunOnceBaseIndexOptions();
    }

    @Override
    public <Match extends IPatternMatch> Collection<Match> getAllMatches(IQuerySpecification<? extends ViatraQueryMatcher<Match>> querySpecification) {
        if (this.samplingMode && this.reSamplingNeeded && this.engine != null) {
            this.engine.getBaseIndex().resampleDerivedFeatures();
        } else {
            this.engine = AdvancedViatraQueryEngine.createUnmanagedEngine(new EMFScope(this.notifier, (BaseIndexOptions)this.baseIndexOptions));
        }
        ViatraQueryMatcher<Match> matcher = this.engine.getMatcher(querySpecification);
        Collection<Match> allMatches = matcher.getAllMatches();
        if (this.samplingMode) {
            this.engine.addModelUpdateListener(this.modelUpdateListener);
        } else {
            this.engine.dispose();
            this.engine = null;
        }
        return allMatches;
    }

    @Override
    public BaseIndexOptions getBaseIndexOptions() {
        return this.baseIndexOptions;
    }

    @Override
    public Notifier getScope() {
        return this.notifier;
    }

    @Override
    public void setAutomaticResampling(boolean automaticResampling) {
        this.samplingMode = automaticResampling;
        if (automaticResampling) {
            if (this.modelUpdateListener == null) {
                this.modelUpdateListener = new RunOnceSamplingModelUpdateListener();
            }
        } else if (this.engine != null) {
            this.engine.dispose();
            this.engine = null;
        }
    }

    @Override
    public void resampleOnNextCall() {
        this.reSamplingNeeded = true;
    }

    private static final class RunOnceBaseIndexOptions
    extends BaseIndexOptions {
        public RunOnceBaseIndexOptions() {
            this.traverseOnlyWellBehavingDerivedFeatures = false;
        }
    }

    private final class RunOnceSamplingModelUpdateListener
    implements ViatraQueryModelUpdateListener {
        private RunOnceSamplingModelUpdateListener() {
        }

        @Override
        public void notifyChanged(ViatraQueryModelUpdateListener.ChangeLevel changeLevel) {
            RunOnceQueryEngine.this.reSamplingNeeded = true;
        }

        @Override
        public ViatraQueryModelUpdateListener.ChangeLevel getLevel() {
            return ViatraQueryModelUpdateListener.ChangeLevel.MODEL;
        }
    }
}

