/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.statecoding;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.viatra.dse.statecoding.StatecodingDependency;
import org.eclipse.viatra.dse.statecoding.StatecodingDependencyGraph;
import org.eclipse.viatra.dse.statecoding.StatecodingDependencyType;
import org.eclipse.viatra.dse.statecoding.StatecodingNodeType;

public class StatecodingNode {
    private StatecodingDependencyGraph graph;
    private final EClass clazz;
    private Set<EAttribute> attributes = new TreeSet<EAttribute>(Comparator.comparing(ENamedElement::getName));
    private List<StatecodingDependency> dependencies = new ArrayList<StatecodingDependency>();
    private boolean stateCodeIsId = false;
    private StatecodingNodeType statecodingNodeType = StatecodingNodeType.CREATE_AND_DELETE;

    public StatecodingNode(EClass clazz) {
        this.clazz = clazz;
    }

    public StatecodingNode withAttribute(EAttribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public StatecodingNode withType(StatecodingNodeType type) {
        this.statecodingNodeType = type;
        return this;
    }

    public StatecodingNode withUniqueness() {
        this.stateCodeIsId = true;
        return this;
    }

    public StatecodingNode withDependency(EReference reference, StatecodingNode node) {
        this.dependencies.add(new StatecodingDependency(reference, node));
        return this;
    }

    public StatecodingNode withInverseDependency(EReference reference, StatecodingNode node) {
        this.dependencies.add(new StatecodingDependency(reference, node, false, StatecodingDependencyType.INVERSE));
        return this;
    }

    public void addDependency(StatecodingDependency statecodingDependency) {
        this.dependencies.add(statecodingDependency);
    }

    public EClass getClazz() {
        return this.clazz;
    }

    public boolean isStateCodeIsId() {
        return this.stateCodeIsId;
    }

    public void setStateCodeIsId(boolean stateCodeIsId) {
        this.stateCodeIsId = stateCodeIsId;
    }

    public StatecodingNodeType getStatecodingNodeType() {
        return this.statecodingNodeType;
    }

    public void setStatecodingNodeType(StatecodingNodeType statecodingNodeType) {
        this.statecodingNodeType = statecodingNodeType;
    }

    public Set<EAttribute> getAttributes() {
        return this.attributes;
    }

    public List<StatecodingDependency> getStatecodingDependencies() {
        return this.dependencies;
    }

    public StatecodingDependencyGraph getGraph() {
        return this.graph;
    }

    public void setGraph(StatecodingDependencyGraph graph) {
        this.graph = graph;
    }
}

