/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.api;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.viatra.dse.api.Solution;
import org.eclipse.viatra.dse.base.DseIdPoolHelper;
import org.eclipse.viatra.dse.objectives.Fitness;
import org.eclipse.viatra.dse.statecode.IStateCoder;
import org.eclipse.viatra.dse.statecode.IStateCoderFactory;
import org.eclipse.viatra.dse.util.EMFHelper;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public class SolutionTrajectory {
    private final List<Object> activationCodes;
    private final List<BatchTransformationRule<?, ?>> transformationRules;
    private final IStateCoderFactory stateCoderFactory;
    private Fitness fitness;
    private Solution solution;
    private ViatraQueryEngine engine;
    private Notifier model;
    private EditingDomain editingDomain;
    private IStateCoder stateCoder;
    private int currentIndex;

    public SolutionTrajectory(List<Object> activationCodes, List<BatchTransformationRule<?, ?>> transformationRules, IStateCoderFactory stateCoderFactory) {
        Objects.requireNonNull(transformationRules, "Parameter transformationRules cannot be null!");
        Objects.requireNonNull(stateCoderFactory, "Parameter stateCoderFactory cannot be null!");
        Objects.requireNonNull(activationCodes, "Parameter activations cannot be null!");
        Preconditions.checkState((transformationRules.size() == activationCodes.size() ? 1 : 0) != 0, (String)"The two List parameters must be the same in size.");
        this.activationCodes = activationCodes;
        this.transformationRules = transformationRules;
        this.stateCoderFactory = stateCoderFactory;
        this.currentIndex = 0;
    }

    public void setModel(Notifier model) {
        this.editingDomain = null;
        EMFScope scope = new EMFScope(model);
        this.engine = ViatraQueryEngine.on((QueryScope)scope);
        this.model = model;
        this.stateCoder = this.stateCoderFactory.createStateCoder();
        this.stateCoder.init(model);
        this.currentIndex = 0;
        DseIdPoolHelper.INSTANCE.disposeByThread();
        DseIdPoolHelper.INSTANCE.registerRules(rule -> {
            int id = 0;
            for (BatchTransformationRule<?, ?> r : this.transformationRules.subList(0, this.currentIndex)) {
                if (!r.equals((Object)rule)) continue;
                ++id;
            }
            return id;
        }, new HashSet(this.transformationRules));
    }

    public void setModelWithEditingDomain(Notifier modelRoot) {
        this.setModel(modelRoot);
        this.editingDomain = EMFHelper.createEditingDomain(this.model);
    }

    public void doTransformation(Notifier modelRoot) {
        this.setModel(modelRoot);
        this.doTransformation();
    }

    public void doTransformationUndoable(Notifier modelRoot) {
        this.setModelWithEditingDomain(modelRoot);
        this.doTransformation();
    }

    public void doTransformation() {
        while (this.doNextTransformation()) {
        }
    }

    public boolean doNextTransformation() {
        if (this.currentIndex >= this.activationCodes.size()) {
            return false;
        }
        this.doNextTransformation(this.currentIndex);
        ++this.currentIndex;
        return true;
    }

    private void doNextTransformation(int index) {
        Objects.requireNonNull(this.model, "The model cannot be null! Use the setModel method.");
        BatchTransformationRule<?, ?> tr = this.transformationRules.get(index);
        Object activationCode = this.activationCodes.get(index);
        ViatraQueryMatcher matcher = tr.getPrecondition().getMatcher(this.engine);
        boolean isActivationFound = false;
        for (final IPatternMatch match : matcher.getAllMatches()) {
            Object matchHash = this.stateCoder.createActivationCode(match);
            if (!matchHash.equals(activationCode)) continue;
            final Consumer action = tr.getAction();
            if (this.editingDomain == null) {
                action.accept(match);
            } else {
                ChangeCommand cc = new ChangeCommand(this.model){

                    protected void doExecute() {
                        action.accept(match);
                    }
                };
                this.editingDomain.getCommandStack().execute((Command)cc);
            }
            isActivationFound = true;
            break;
        }
        if (!isActivationFound) {
            throw new UncheckedExecutionException("Activation was not found for transformation! Possible cause: wrong model, bad state coder. index: " + index + " Activation code: " + String.valueOf(activationCode), null);
        }
    }

    public boolean undoLastTransformation() {
        Objects.requireNonNull(this.editingDomain, "To be able to undo the transformation initialize with editing domain.");
        if (this.currentIndex > 0) {
            this.editingDomain.getCommandStack().undo();
            --this.currentIndex;
            return true;
        }
        return false;
    }

    public void undoTransformation() {
        while (this.undoLastTransformation()) {
        }
    }

    public List<Object> getActivationCodes() {
        return this.activationCodes;
    }

    public List<BatchTransformationRule<?, ?>> getTransformationRules() {
        return this.transformationRules;
    }

    public IStateCoderFactory getStateCoderFactory() {
        return this.stateCoderFactory;
    }

    public ViatraQueryEngine getEngine() {
        return this.engine;
    }

    public Notifier getModel() {
        return this.model;
    }

    public IStateCoder getStateCoder() {
        return this.stateCoder;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getTrajectoryLength() {
        return this.activationCodes.size();
    }

    public Fitness getFitness() {
        return this.fitness;
    }

    public void setFitness(Fitness fitness) {
        this.fitness = fitness;
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fitness: ");
        sb.append(this.fitness.toString());
        sb.append(" | Trajectory (");
        sb.append(this.activationCodes.size());
        sb.append("): ");
        for (Object object : this.activationCodes) {
            sb.append(object.toString());
            sb.append(" | ");
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.activationCodes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SolutionTrajectory) {
            SolutionTrajectory that = (SolutionTrajectory)obj;
            return this.activationCodes.equals(that.activationCodes);
        }
        return false;
    }

    public Solution getSolution() {
        return this.solution;
    }

    public void setSolution(Solution solution) {
        this.solution = solution;
    }
}

