/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.changemonitor;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.transformation.runtime.emf.changemonitor.QueryResultChangeDelta;

public class ChangeDelta {
    private Map<IQuerySpecification<?>, QueryResultChangeDelta> map;

    public ChangeDelta(Map<IQuerySpecification<?>, QueryResultChangeDelta> delta) {
        this.map = delta;
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeDelta other = (ChangeDelta)obj;
        return Objects.equals(this.map, other.map);
    }

    public String toString() {
        return this.map.entrySet().stream().map(entry -> String.format("CHANGE: query: %s; changes %s", entry.getKey(), ((QueryResultChangeDelta)entry.getValue()).toString())).collect(Collectors.joining(", "));
    }

    public Set<IQuerySpecification<?>> getChangedQuerySpecifications() {
        return this.map.keySet().stream().filter(spec -> this.map.containsKey(spec) && this.map.get(spec).hasChanges()).collect(Collectors.toSet());
    }

    public Set<? extends IPatternMatch> getAppeared(IQuerySpecification<?> specification) {
        return this.map.get(specification).getAppeared();
    }

    public Set<? extends IPatternMatch> getAllAppeared() {
        return this.map.values().stream().flatMap(delta -> delta.getAppeared().stream()).collect(Collectors.toSet());
    }

    public Set<? extends IPatternMatch> getUpdated(IQuerySpecification<?> specification) {
        return this.map.get(specification).getUpdated();
    }

    public Set<? extends IPatternMatch> getAllUpdated() {
        return this.map.values().stream().flatMap(delta -> delta.getUpdated().stream()).collect(Collectors.toSet());
    }

    public Set<? extends IPatternMatch> getDisappeared(IQuerySpecification<?> specification) {
        return this.map.get(specification).getDisappeared();
    }

    public Set<? extends IPatternMatch> getAllDisappeared() {
        return this.map.values().stream().flatMap(delta -> delta.getDisappeared().stream()).collect(Collectors.toSet());
    }
}

