/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.graphimpl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphObserver;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;

public class Graph<V>
implements IGraphDataSource<V>,
IBiDirectionalGraphDataSource<V> {
    private IMultiLookup<V, V> outgoingEdges = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.MULTISETS, Object.class);
    private IMultiLookup<V, V> incomingEdges = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.MULTISETS, Object.class);
    private Set<V> nodes = CollectionsFactory.createSet();
    private List<IGraphObserver<V>> observers = CollectionsFactory.createObserverList();

    public void insertEdge(V source, V target) {
        this.outgoingEdges.addPair(source, target);
        this.incomingEdges.addPair(target, source);
        for (IGraphObserver<V> go : this.observers) {
            go.edgeInserted(source, target);
        }
    }

    public void deleteEdgeIfExists(V source, V target) {
        boolean containedEdge = this.outgoingEdges.lookupOrEmpty(source).containsNonZero(target);
        if (containedEdge) {
            this.deleteEdgeThatExists(source, target);
        }
    }

    public void deleteEdgeThatExists(V source, V target) {
        this.outgoingEdges.removePair(source, target);
        this.incomingEdges.removePair(target, source);
        for (IGraphObserver<V> go : this.observers) {
            go.edgeDeleted(source, target);
        }
    }

    @Deprecated
    public void deleteEdge(V source, V target) {
        this.deleteEdgeIfExists(source, target);
    }

    public void insertNode(V node) {
        if (this.nodes.add(node)) {
            for (IGraphObserver<V> go : this.observers) {
                go.nodeInserted(node);
            }
        }
    }

    public void deleteNode(V node) {
        if (this.nodes.remove(node)) {
            IMemoryView outgoingView;
            IMemoryView incomingView = this.incomingEdges.lookup(node);
            if (incomingView != null) {
                Map incoming = CollectionsFactory.createMap((Map)incomingView.asMap());
                for (Map.Entry entry : incoming.entrySet()) {
                    int i = 0;
                    while (i < (Integer)entry.getValue()) {
                        this.deleteEdgeThatExists(entry.getKey(), node);
                        ++i;
                    }
                }
            }
            if ((outgoingView = this.outgoingEdges.lookup(node)) != null) {
                Map map = CollectionsFactory.createMap((Map)outgoingView.asMap());
                for (Map.Entry entry : map.entrySet()) {
                    int i = 0;
                    while (i < (Integer)entry.getValue()) {
                        this.deleteEdgeThatExists(node, entry.getKey());
                        ++i;
                    }
                }
            }
            for (IGraphObserver iGraphObserver : this.observers) {
                iGraphObserver.nodeDeleted(node);
            }
        }
    }

    @Override
    public void attachObserver(IGraphObserver<V> go) {
        this.observers.add(go);
    }

    @Override
    public void attachAsFirstObserver(IGraphObserver<V> observer) {
        this.observers.add(0, observer);
    }

    @Override
    public void detachObserver(IGraphObserver<V> go) {
        this.observers.remove(go);
    }

    @Override
    public Set<V> getAllNodes() {
        return this.nodes;
    }

    @Override
    public IMemoryView<V> getTargetNodes(V source) {
        return this.outgoingEdges.lookupOrEmpty(source);
    }

    @Override
    public IMemoryView<V> getSourceNodes(V target) {
        return this.incomingEdges.lookupOrEmpty(target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes = ");
        for (V n : this.getAllNodes()) {
            sb.append(n.toString());
            sb.append(" ");
        }
        sb.append(" edges = ");
        for (Object source : this.outgoingEdges.distinctKeys()) {
            IMemoryView targets = this.outgoingEdges.lookup(source);
            for (Object target : targets.distinctValues()) {
                int count = targets.getCount(target);
                int i = 0;
                while (i < count) {
                    sb.append("(" + String.valueOf(source) + "," + String.valueOf(target) + ") ");
                    ++i;
                }
            }
        }
        return sb.toString();
    }
}

