/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.sirius.util;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.viatra.query.patternlanguage.emf.parser.antlr.internal.InternalEMFPatternLanguageLexer;
import org.eclipse.viatra.query.patternlanguage.emf.sirius.SiriusVQLGraphicalEditorPlugin;
import org.eclipse.viatra.query.patternlanguage.emf.sirius.util.VGQLEditorUtil;
import org.eclipse.viatra.query.patternlanguage.emf.ui.util.JavaProjectClassLoaderProvider;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.CheckConstraint;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.FunctionEvaluationValue;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.InterpretableExpression;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.JavaClassReference;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.Reference;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.Variable;
import org.eclipse.viatra.query.patternlanguage.metamodel.vgql.VgqlPackage;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.util.LazyStringInputStream;

public class XtextEmbeddedEditor {
    private static final int MIN_EDITOR_WIDTH = 100;
    private static final int MIN_EDITOR_HEIGHT = 20;
    private final Injector xtextInjector;
    private Point cursorLocation;
    private IGraphicalEditPart hostEditPart;
    private Decorations xtextEditorComposite;
    private EmbeddedEditor xtextEmbeddedEditor;
    private EmbeddedEditorModelAccess xtextPartialEditor;
    private InterpretableExpression semanticElement;
    private DDiagramElement originalSemanticElementView;
    private XtextResource virtualXtextResource;
    private final IEditorPart editor;
    private ISelectionProvider oldSelectionProvider;

    public XtextEmbeddedEditor(IGraphicalEditPart editPart, InterpretableExpression targetSemanticElement, DDiagramElement targetView, Injector xtextInjector, IEditorPart editor) {
        this.editor = editor;
        this.hostEditPart = Objects.requireNonNull(editPart);
        this.semanticElement = Objects.requireNonNull(targetSemanticElement);
        this.originalSemanticElementView = Objects.requireNonNull(targetView);
        this.xtextInjector = xtextInjector;
    }

    public void showEditor() {
        try {
            try {
                this.cursorLocation = ((GraphicalViewer)VGQLEditorUtil.getViewer(this.originalSemanticElementView)).getControl().toControl(Display.getDefault().getCursorLocation());
                this.virtualXtextResource = this.createVirtualXtextResource(this.semanticElement);
                this.createXtextEditor();
                this.oldSelectionProvider = this.editor.getSite().getSelectionProvider();
                this.editor.getSite().setSelectionProvider((ISelectionProvider)this.xtextEmbeddedEditor.getViewer());
            }
            catch (Exception e) {
                SiriusVQLGraphicalEditorPlugin.logError(e);
                if (this.hostEditPart != null) {
                    this.hostEditPart.refresh();
                }
            }
        }
        finally {
            if (this.hostEditPart != null) {
                this.hostEditPart.refresh();
            }
        }
    }

    public void closeEditor(boolean updateModel) {
        try {
            if (this.xtextPartialEditor != null) {
                TransactionalEditingDomain ed;
                Command command;
                if (updateModel && (command = SetCommand.create((EditingDomain)(ed = SessionManager.INSTANCE.getSession((EObject)this.semanticElement).getTransactionalEditingDomain()), (Object)this.semanticElement, (Object)VgqlPackage.Literals.INTERPRETABLE_EXPRESSION__EXPRESSION, (Object)this.xtextPartialEditor.getEditablePart())).canExecute()) {
                    ed.getCommandStack().execute(command);
                }
                if (this.xtextEditorComposite != null) {
                    this.hostEditPart.getViewer().getControl().forceFocus();
                    this.xtextEditorComposite.dispose();
                    this.xtextEditorComposite = null;
                }
                this.xtextPartialEditor = null;
                this.virtualXtextResource = null;
            }
        }
        finally {
            this.editor.getSite().setSelectionProvider(this.oldSelectionProvider);
            this.oldSelectionProvider = null;
        }
    }

    private XtextResource createVirtualXtextResource(InterpretableExpression container) throws IOException {
        URI uri = container.eResource().getURI().trimFileExtension().appendFileExtension("vql");
        return this.createVirtualXtextResource(uri, this.getFullText(container));
    }

    private XtextResource createVirtualXtextResource(URI uri, String text) throws IOException {
        JavaProjectClassLoaderProvider provider = (JavaProjectClassLoaderProvider)this.xtextInjector.getInstance(JavaProjectClassLoaderProvider.class);
        XtextResourceSet rs = (XtextResourceSet)((IResourceSetProvider)this.xtextInjector.getInstance(IResourceSetProvider.class)).get(provider.getIFile((EObject)this.semanticElement).getProject());
        IResourceFactory resourceFactory = (IResourceFactory)this.xtextInjector.getInstance(IResourceFactory.class);
        XtextResource resource = (XtextResource)resourceFactory.createResource(URI.createURI((String)uri.toString()));
        resource.load((InputStream)new LazyStringInputStream(text == null ? "" : text), null);
        rs.getResources().add((Object)resource);
        return resource;
    }

    private String buildParameterDeclaration(Variable v) {
        if (!v.getTypes().isEmpty() && v.getTypes().get(0) instanceof JavaClassReference) {
            return v.getName() + " : java " + this.escapeTypeName(((JavaClassReference)v.getTypes().get(0)).getClassName());
        }
        return "";
    }

    private String escapeTypeName(String name) {
        return Arrays.stream(name.split("\\.")).map(n -> {
            InternalEMFPatternLanguageLexer lexer = new InternalEMFPatternLanguageLexer((CharStream)new ANTLRStringStream(n));
            return lexer.nextToken().getType() == 19 ? "^" + n : n;
        }).collect(Collectors.joining("."));
    }

    private String getPrefixText(InterpretableExpression ex) {
        StringBuilder sb = new StringBuilder();
        sb.append("pattern temporary(");
        sb.append(ex.getVariables().stream().map(Reference::getExpression).filter(Variable.class::isInstance).map(Variable.class::cast).map(this::buildParameterDeclaration).collect(Collectors.joining(", ")));
        sb.append(") {\n");
        if (ex instanceof FunctionEvaluationValue) {
            sb.append(" _ == eval(");
        } else if (ex instanceof CheckConstraint) {
            sb.append("  check(");
        }
        return sb.toString();
    }

    private String getPostfixText(InterpretableExpression ex) {
        return ");\n }";
    }

    private String getEditableText(InterpretableExpression ex) {
        return ex.getExpression();
    }

    private String getFullText(InterpretableExpression ex) {
        return this.getPrefixText(ex) + "\n" + this.getEditableText(ex) + "\n" + this.getPostfixText(ex);
    }

    protected void createXtextEditor() {
        GraphicalViewer viewer = (GraphicalViewer)VGQLEditorUtil.getViewer(this.originalSemanticElementView);
        Composite parentComposite = (Composite)viewer.getControl();
        this.xtextEditorComposite = new Decorations(parentComposite, 18512);
        this.xtextEditorComposite.setLayout((Layout)new FillLayout());
        EmbeddedEditorFactory factory = new EmbeddedEditorFactory();
        this.xtextInjector.injectMembers((Object)factory);
        this.xtextEmbeddedEditor = factory.newEditor(() -> this.virtualXtextResource).showErrorAndWarningAnnotations().withParent((Composite)this.xtextEditorComposite);
        this.xtextPartialEditor = this.xtextEmbeddedEditor.createPartialEditor(this.getPrefixText(this.semanticElement) + "\n", this.getEditableText(this.semanticElement), "\n" + this.getPostfixText(this.semanticElement), false);
        this.addKeyVerifyListener();
        this.setEditorBounds();
        this.xtextEmbeddedEditor.getDocument().getValidationJob().schedule();
        this.xtextEditorComposite.setVisible(true);
        this.xtextEditorComposite.forceFocus();
    }

    private void addKeyVerifyListener() {
        StyledText xtextTextWidget = this.xtextEmbeddedEditor.getViewer().getTextWidget();
        CloseEditorHandler listener = new CloseEditorHandler();
        xtextTextWidget.addVerifyKeyListener((VerifyKeyListener)listener);
        this.xtextEmbeddedEditor.getViewer().getContentAssistantFacade().addCompletionListener((ICompletionListener)listener);
    }

    private void setEditorBounds() {
        String editString = this.xtextPartialEditor.getEditablePart();
        int numLines = this.getNumLines(editString);
        int numColumns = this.getMaxColumns(editString);
        Font font = this.hostEditPart.getFigure().getFont();
        FontData fontData = font.getFontData()[0];
        int fontHeightInPixel = fontData.getHeight();
        int width = Math.max(fontHeightInPixel * (numColumns + 3), 100);
        int height = Math.max(fontHeightInPixel * (numLines + 4), 20);
        this.xtextEditorComposite.setBounds(this.cursorLocation.x, this.cursorLocation.y, width + 250, height + 50);
    }

    private int getNumLines(String s) {
        int numLines = 1;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n') {
                ++numLines;
            }
            ++n2;
        }
        return numLines;
    }

    private int getMaxColumns(String s) {
        int maxColumns = 0;
        int currentColumns = 0;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n') {
                maxColumns = Math.max(maxColumns, currentColumns);
                currentColumns = 0;
            } else {
                ++currentColumns;
            }
            ++n2;
        }
        return Math.max(currentColumns, maxColumns);
    }

    private final class CloseEditorHandler
    extends KeyAdapter
    implements VerifyKeyListener,
    ICompletionListener {
        boolean contentAssistStopping = false;

        private CloseEditorHandler() {
        }

        public void verifyKey(VerifyEvent e) {
            int keyCode = e.keyCode;
            if ((e.stateMask & 0x40000) != 0 && (keyCode == 0x1000050 || keyCode == 13)) {
                e.doit = false;
                XtextEmbeddedEditor.this.closeEditor(true);
            }
            if (keyCode == 27 && !this.contentAssistStopping) {
                e.doit = false;
                XtextEmbeddedEditor.this.closeEditor(false);
            }
            this.contentAssistStopping = false;
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            this.contentAssistStopping = false;
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            this.contentAssistStopping = true;
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }
    }
}

