/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.ui.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.viatra.transformation.debug.model.TransformationDebugTarget;
import org.eclipse.viatra.transformation.debug.model.TransformationStackFrame;
import org.eclipse.viatra.transformation.debug.model.TransformationThread;
import org.eclipse.viatra.transformation.debug.model.breakpoint.ActivationBreakpoint;
import org.eclipse.viatra.transformation.debug.model.breakpoint.ActivationBreakpointHandler;
import org.eclipse.viatra.transformation.debug.transformationtrace.model.RuleParameterTrace;
import org.eclipse.viatra.transformation.debug.ui.activator.TransformationDebugUIActivator;

public class DebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public void setAttribute(String attribute, Object value) {
    }

    public String getText(Object element) {
        try {
            if (element instanceof ActivationBreakpoint) {
                ActivationBreakpoint breakpoint = (ActivationBreakpoint)element;
                String parameters = "";
                for (RuleParameterTrace parameterTrace : ((ActivationBreakpointHandler)breakpoint.getHandler()).getTrace().getRuleParameterTraces()) {
                    parameters = parameters.concat(String.valueOf(parameterTrace.getParameterName()) + " : " + parameterTrace.getObjectId() + " ");
                }
                return "Transformation Activation Breakpoint - Rule: " + ((ActivationBreakpointHandler)breakpoint.getHandler()).getTrace().getRuleName() + "(" + parameters + ")";
            }
            if (element instanceof TransformationStackFrame) {
                return ((TransformationStackFrame)element).getName();
            }
            if (element instanceof TransformationThread) {
                return ((TransformationThread)element).getName();
            }
            if (element instanceof TransformationDebugTarget) {
                return ((TransformationDebugTarget)element).getName();
            }
        }
        catch (DebugException e) {
            TransformationDebugUIActivator.getDefault().logException(e.getMessage(), e);
            return super.getText(element);
        }
        return super.getText(element);
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    public IEditorInput getEditorInput(Object element) {
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        return null;
    }
}

