/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IClasspathContributor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.ds.internal.annotations.Activator;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationVersion;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DSAnnotationClasspathContributor
implements IClasspathContributor {
    private static final IAccessRule[] ANNOTATION_ACCESS_RULES = new IAccessRule[0];
    private static final IClasspathAttribute[] DS_ATTRS = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"org.eclipse.pde.ds.annotations.cp", (String)Boolean.toString(true))};

    public List<IClasspathEntry> getInitialEntries(BundleDescription project) {
        boolean autoClasspath;
        IScopeContext[] scope;
        IPreferencesService prefs;
        boolean enabled;
        IResource resource;
        IPluginModelBase model;
        Bundle bundle = FrameworkUtil.getBundle(Activator.class);
        if (bundle != null && (model = PluginRegistry.findModel((BundleDescription)project)) != null && (resource = model.getUnderlyingResource()) != null && !WorkspaceModelManager.isBinaryProject((IProject)resource.getProject()) && (enabled = (prefs = Platform.getPreferencesService()).getBoolean("org.eclipse.pde.ds.annotations", "enabled", false, scope = new IScopeContext[]{new ProjectScope(resource.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE})) && (autoClasspath = prefs.getBoolean("org.eclipse.pde.ds.annotations", "classpath", true, scope))) {
            DSAnnotationVersion specVersion;
            try {
                specVersion = DSAnnotationVersion.valueOf(prefs.getString("org.eclipse.pde.ds.annotations", "dsVersion", DSAnnotationVersion.V1_3.name(), scope));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                specVersion = DSAnnotationVersion.V1_3;
            }
            String jarDir = specVersion == DSAnnotationVersion.V1_3 ? "lib" : "lib1_2";
            try {
                URL fileURL = FileLocator.toFileURL((URL)bundle.getEntry(String.valueOf(jarDir) + "/annotations.jar"));
                if ("file".equals(fileURL.getProtocol())) {
                    URL srcFileURL = FileLocator.toFileURL((URL)bundle.getEntry(String.valueOf(jarDir) + "/annotationssrc.zip"));
                    Path srcPath = "file".equals(srcFileURL.getProtocol()) ? new Path(srcFileURL.getPath()) : null;
                    IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)new Path(fileURL.getPath()), (IPath)srcPath, (IPath)Path.ROOT, (IAccessRule[])ANNOTATION_ACCESS_RULES, (IClasspathAttribute[])DS_ATTRS, (boolean)false);
                    return Collections.singletonList(entry);
                }
            }
            catch (IOException e) {
                Activator.log((IStatus)new Status(4, "org.eclipse.pde.ds.annotations", "Error creating classpath entry.", (Throwable)e));
            }
        }
        return Collections.emptyList();
    }

    public List<IClasspathEntry> getEntriesForDependency(BundleDescription project, BundleDescription addedDependency) {
        return Collections.emptyList();
    }
}

