/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.SerializationContext;
import org.eclipse.xtext.serializer.impl.FeatureFinderUtil;
import org.eclipse.xtext.serializer.sequencer.IAssignmentFinder;
import org.eclipse.xtext.serializer.sequencer.IContextFinder;
import org.eclipse.xtext.serializer.tokens.ICrossReferenceSerializer;
import org.eclipse.xtext.serializer.tokens.IEnumLiteralSerializer;
import org.eclipse.xtext.serializer.tokens.IKeywordSerializer;
import org.eclipse.xtext.serializer.tokens.IValueSerializer;

public class AssignmentFinder
implements IAssignmentFinder {
    @Inject
    protected IContextFinder contextFinder;
    @Inject
    protected ICrossReferenceSerializer crossRefSerializer;
    @Inject
    protected IEnumLiteralSerializer enumLiteralSerializer;
    @Inject
    protected IKeywordSerializer keywordSerializer;
    @Inject
    protected IValueSerializer valueSerializer;

    @Override
    public Set<AbstractElement> findAssignmentsByValue(EObject semanticObj, Multimap<AbstractElement, ISerializationContext> assignments, Object value, INode node) {
        ArrayList assignedElements = Lists.newArrayList((Iterable)assignments.keySet());
        EStructuralFeature feature = FeatureFinderUtil.getFeature((AbstractElement)assignedElements.iterator().next(), semanticObj.eClass());
        if (feature instanceof EAttribute) {
            Class clazz = feature.getEType().getInstanceClass();
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return this.findValidBooleanAssignments(semanticObj, assignedElements, value);
            }
            return this.findValidValueAssignments(semanticObj, assignedElements, value);
        }
        if (feature instanceof EReference) {
            EReference ref = (EReference)feature;
            if (ref.isContainment()) {
                return this.findValidAssignmentsForContainmentRef(semanticObj, assignments, (EObject)value);
            }
            return this.findValidAssignmentsForCrossRef(semanticObj, assignedElements, (EObject)value, node);
        }
        throw new RuntimeException("unknown feature type");
    }

    protected Set<AbstractElement> findValidAssignmentsForContainmentRef(EObject semanticObj, Multimap<AbstractElement, ISerializationContext> assignments, EObject value) {
        ArrayListMultimap children = ArrayListMultimap.create();
        for (Map.Entry e : assignments.asMap().entrySet()) {
            EClassifier classifier;
            AbstractElement ele = (AbstractElement)e.getKey();
            if (ele instanceof RuleCall && !(classifier = ((RuleCall)ele).getRule().getType().getClassifier()).isInstance((Object)value)) continue;
            for (ISerializationContext container : (Collection)e.getValue()) {
                ISerializationContext child = SerializationContext.forChild(container, ele, value);
                children.put((Object)child, (Object)ele);
            }
        }
        if (children.size() < 2) {
            return Sets.newHashSet((Iterable)children.values());
        }
        Set<ISerializationContext> found = this.contextFinder.findByContents(value, children.keySet());
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (ISerializationContext ctx : children.keySet()) {
            if (!found.contains(ctx)) continue;
            result.addAll(children.get((Object)ctx));
        }
        return result;
    }

    protected Set<AbstractElement> findValidAssignmentsForCrossRef(EObject semanticObj, Iterable<AbstractElement> assignedElements, EObject value, INode node) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (AbstractElement ass : assignedElements) {
            CrossReference crossref = GrammarUtil.containingCrossReference(ass);
            EReference eref = GrammarUtil.getReference(crossref, semanticObj.eClass());
            if (!EcoreUtil2.isAssignableFrom(eref.getEReferenceType(), value.eClass()) || !this.crossRefSerializer.isValid(semanticObj, crossref, value, node, null)) continue;
            result.add(ass);
        }
        return result;
    }

    protected Set<AbstractElement> findValidBooleanAssignments(EObject semanticObj, Iterable<AbstractElement> assignedElements, Object value) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (AbstractElement ele : assignedElements) {
            if (GrammarUtil.isBooleanAssignment(GrammarUtil.containingAssignment(ele))) {
                if (!Boolean.TRUE.equals(value)) continue;
                result.add(ele);
                continue;
            }
            if (!(ele instanceof RuleCall) || !this.valueSerializer.isValid(semanticObj, (RuleCall)ele, value, null)) continue;
            result.add(ele);
        }
        return result;
    }

    protected Set<AbstractElement> findValidValueAssignments(EObject semanticObj, Iterable<AbstractElement> assignedElements, Object value) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (AbstractElement ass : assignedElements) {
            if (ass instanceof Keyword && this.keywordSerializer.isValid(semanticObj, (Keyword)ass, value, null)) {
                result.add(ass);
                continue;
            }
            if (!(ass instanceof RuleCall)) continue;
            RuleCall rc = (RuleCall)ass;
            if (rc.getRule() instanceof EnumRule) {
                if (!this.enumLiteralSerializer.isValid(semanticObj, rc, value, null)) continue;
                result.add(ass);
                continue;
            }
            if (!this.valueSerializer.isValid(semanticObj, rc, value, null)) continue;
            result.add(ass);
        }
        return result;
    }
}

