/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.recipes.helper;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.runtime.rete.recipes.ExpressionDefinition;
import org.eclipse.viatra.query.runtime.rete.recipes.InputFilterRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.InputRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.Mask;
import org.eclipse.viatra.query.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.RecipesFactory;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class RecipesHelper {
    private static final RecipesFactory FACTORY = RecipesFactory.eINSTANCE;

    public static Mask mask(final int sourceArity, final Iterable<Integer> sourceIndices) {
        Mask _createMask = FACTORY.createMask();
        Procedures.Procedure1<Mask> _function = new Procedures.Procedure1<Mask>(){

            public void apply(Mask it) {
                it.setSourceArity(sourceArity);
                EList<Integer> _sourceIndices = it.getSourceIndices();
                Iterables.addAll(_sourceIndices, (Iterable)sourceIndices);
            }
        };
        return (Mask)ObjectExtensions.operator_doubleArrow((Object)_createMask, (Procedures.Procedure1)_function);
    }

    public static Mask mask(final int sourceArity, final int ... sourceIndices) {
        Mask _createMask = FACTORY.createMask();
        Procedures.Procedure1<Mask> _function = new Procedures.Procedure1<Mask>(){

            public void apply(Mask it) {
                it.setSourceArity(sourceArity);
                EList<Integer> _sourceIndices = it.getSourceIndices();
                Iterables.addAll(_sourceIndices, (Iterable)((Iterable)Conversions.doWrapArray((Object)sourceIndices)));
            }
        };
        return (Mask)ObjectExtensions.operator_doubleArrow((Object)_createMask, (Procedures.Procedure1)_function);
    }

    public static ProjectionIndexerRecipe projectionIndexerRecipe(final ReteNodeRecipe parent, final Mask mask) {
        ProjectionIndexerRecipe _createProjectionIndexerRecipe = FACTORY.createProjectionIndexerRecipe();
        Procedures.Procedure1<ProjectionIndexerRecipe> _function = new Procedures.Procedure1<ProjectionIndexerRecipe>(){

            public void apply(ProjectionIndexerRecipe it) {
                it.setParent(parent);
                it.setMask(mask);
            }
        };
        return (ProjectionIndexerRecipe)ObjectExtensions.operator_doubleArrow((Object)_createProjectionIndexerRecipe, (Procedures.Procedure1)_function);
    }

    public static ExpressionDefinition expressionDefinition(final Object evaluator) {
        ExpressionDefinition _createExpressionDefinition = FACTORY.createExpressionDefinition();
        Procedures.Procedure1<ExpressionDefinition> _function = new Procedures.Procedure1<ExpressionDefinition>(){

            public void apply(ExpressionDefinition it) {
                it.setEvaluator(evaluator);
            }
        };
        return (ExpressionDefinition)ObjectExtensions.operator_doubleArrow((Object)_createExpressionDefinition, (Procedures.Procedure1)_function);
    }

    public static InputRecipe inputRecipe(final Object inputKey, final String inputKeyID, final int arity) {
        InputRecipe _createInputRecipe = FACTORY.createInputRecipe();
        Procedures.Procedure1<InputRecipe> _function = new Procedures.Procedure1<InputRecipe>(){

            public void apply(InputRecipe it) {
                it.setInputKey(inputKey);
                it.setKeyArity(arity);
                it.setKeyID(inputKeyID);
                it.setTraceInfo(inputKeyID);
            }
        };
        return (InputRecipe)ObjectExtensions.operator_doubleArrow((Object)_createInputRecipe, (Procedures.Procedure1)_function);
    }

    public static InputFilterRecipe inputFilterRecipe(final ReteNodeRecipe parent, final Object inputKey, final String inputKeyID, final Mask mask) {
        InputFilterRecipe _createInputFilterRecipe = FACTORY.createInputFilterRecipe();
        Procedures.Procedure1<InputFilterRecipe> _function = new Procedures.Procedure1<InputFilterRecipe>(){

            public void apply(InputFilterRecipe it) {
                it.setParent(parent);
                it.setInputKey(inputKey);
                it.setKeyID(inputKeyID);
                it.setTraceInfo(inputKeyID);
                it.setMask(mask);
            }
        };
        return (InputFilterRecipe)ObjectExtensions.operator_doubleArrow((Object)_createInputFilterRecipe, (Procedures.Procedure1)_function);
    }
}

