/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.ActiveAnnotationContext;
import org.eclipse.xtend.core.macro.ActiveAnnotationContexts;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.core.macro.XAnnotationExtensions;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ActiveAnnotationContextProvider {
    private static final Logger logger = Logger.getLogger(ActiveAnnotationContextProvider.class);
    @Inject
    @Extension
    private XAnnotationExtensions _xAnnotationExtensions;
    @Inject
    @Extension
    private ProcessorInstanceForJvmTypeProvider _processorInstanceForJvmTypeProvider;
    @Inject
    private Provider<CompilationUnitImpl> compilationUnitProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public ActiveAnnotationContexts computeContext(final XtendFile file) {
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"[macros] findActiveAnnotations (ActiveAnnotationContextProvider.computeContext)");
        task.start();
        try {
            Resource _eResource = file.eResource();
            final ActiveAnnotationContexts result = ActiveAnnotationContexts.installNew(_eResource);
            final CompilationUnitImpl compilationUnit = (CompilationUnitImpl)this.compilationUnitProvider.get();
            compilationUnit.setXtendFile(file);
            result.compilationUnit = compilationUnit;
            IAcceptor<Pair<JvmAnnotationType, XAnnotation>> _function = new IAcceptor<Pair<JvmAnnotationType, XAnnotation>>(){

                public void accept(Pair<JvmAnnotationType, XAnnotation> it) {
                    boolean _not;
                    JvmAnnotationType _key;
                    Map<JvmAnnotationType, ActiveAnnotationContext> _contexts = result.getContexts();
                    boolean _containsKey = _contexts.containsKey(_key = (JvmAnnotationType)it.getKey());
                    boolean bl = _not = !_containsKey;
                    if (_not) {
                        ActiveAnnotationContext fa = new ActiveAnnotationContext();
                        fa.setCompilationUnit(compilationUnit);
                        JvmAnnotationType _key_1 = (JvmAnnotationType)it.getKey();
                        JvmType processorType = ActiveAnnotationContextProvider.this._xAnnotationExtensions.getProcessorType(_key_1);
                        try {
                            Object processorInstance = ActiveAnnotationContextProvider.this._processorInstanceForJvmTypeProvider.getProcessorInstance(processorType);
                            boolean _equals = Objects.equal((Object)processorInstance, null);
                            if (_equals) {
                                String _identifier = processorType.getIdentifier();
                                String _plus = "Couldn't instantiate the annotation processor of type '" + _identifier;
                                String _plus_1 = String.valueOf(_plus) + "'. This is usually the case when the processor resides in the same project as the annotated element.";
                                throw new IllegalStateException(_plus_1);
                            }
                            fa.setProcessorInstance(processorInstance);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof VirtualMachineError) {
                                VirtualMachineError e = (VirtualMachineError)_t;
                                throw e;
                            }
                            if (_t instanceof Throwable) {
                                Throwable e_1 = _t;
                                ActiveAnnotationContextProvider.this.operationCanceledManager.propagateAsErrorIfCancelException(e_1);
                                String _switchResult = null;
                                boolean _matched = false;
                                if (e_1 instanceof ExceptionInInitializerError) {
                                    _matched = true;
                                    Throwable _exception = ((ExceptionInInitializerError)e_1).getException();
                                    _switchResult = _exception.getMessage();
                                }
                                if (!_matched) {
                                    _switchResult = e_1.getMessage();
                                }
                                String msg = _switchResult;
                                Resource _eResource = file.eResource();
                                EList _errors = _eResource.getErrors();
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"Problem while loading annotation processor: ");
                                _builder.append((Object)msg, "");
                                XAnnotation _value = (XAnnotation)it.getValue();
                                EObjectDiagnosticImpl _eObjectDiagnosticImpl = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtend.core.validation.IssueCodes.processing_error", _builder.toString(), (EObject)_value, (EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, -1, null);
                                _errors.add((Object)_eObjectDiagnosticImpl);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        Map<JvmAnnotationType, ActiveAnnotationContext> _contexts_1 = result.getContexts();
                        JvmAnnotationType _key_2 = (JvmAnnotationType)it.getKey();
                        _contexts_1.put(_key_2, fa);
                    }
                    Map<JvmAnnotationType, ActiveAnnotationContext> _contexts_2 = result.getContexts();
                    JvmAnnotationType _key_3 = (JvmAnnotationType)it.getKey();
                    ActiveAnnotationContext _get = _contexts_2.get(_key_3);
                    List<XtendAnnotationTarget> _annotatedSourceElements = _get.getAnnotatedSourceElements();
                    XAnnotation _value_1 = (XAnnotation)it.getValue();
                    XtendAnnotationTarget _annotatedTarget = ActiveAnnotationContextProvider.this._xAnnotationExtensions.getAnnotatedTarget(_value_1);
                    _annotatedSourceElements.add(_annotatedTarget);
                }
            };
            this.searchAnnotatedElements(file, _function);
            ActiveAnnotationContexts activeAnnotationContexts = result;
            return activeAnnotationContexts;
        }
        catch (Throwable _t) {
            if (_t instanceof Throwable) {
                Throwable e = _t;
                this.operationCanceledManager.propagateAsErrorIfCancelException(e);
                boolean _matched = false;
                if (e instanceof VirtualMachineError) {
                    _matched = true;
                    throw (VirtualMachineError)e;
                }
                if (!_matched && e instanceof LinkageError) {
                    _matched = true;
                    throw (LinkageError)e;
                }
                logger.warn((Object)"Error finding the elements to be processed by active annotations", e);
                Resource _eResource_1 = file.eResource();
                ActiveAnnotationContexts activeAnnotationContexts = ActiveAnnotationContexts.installNew(_eResource_1);
                return activeAnnotationContexts;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        finally {
            task.stop();
        }
    }

    private void searchAnnotatedElements(EObject element, final IAcceptor<Pair<JvmAnnotationType, XAnnotation>> acceptor) {
        EList<XtendParameter> _parameters;
        EList<XtendMember> _members;
        Object _function;
        boolean _matched = false;
        if (element instanceof XtendFile) {
            _matched = true;
            EList<XtendTypeDeclaration> _xtendTypes = ((XtendFile)element).getXtendTypes();
            _function = new Procedures.Procedure1<XtendTypeDeclaration>(){

                public void apply(XtendTypeDeclaration it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_xtendTypes, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendClass) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
            _members = ((XtendClass)element).getMembers();
            _function = new Procedures.Procedure1<XtendMember>(){

                public void apply(XtendMember it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_members, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendInterface) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
            _members = ((XtendInterface)element).getMembers();
            _function = new Procedures.Procedure1<XtendMember>(){

                public void apply(XtendMember it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_members, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendEnum) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
            _members = ((XtendEnum)element).getMembers();
            _function = new Procedures.Procedure1<XtendMember>(){

                public void apply(XtendMember it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_members, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendAnnotationType) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
            _members = ((XtendAnnotationType)element).getMembers();
            _function = new Procedures.Procedure1<XtendMember>(){

                public void apply(XtendMember it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_members, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendFunction) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
            _parameters = ((XtendFunction)element).getParameters();
            _function = new Procedures.Procedure1<XtendParameter>(){

                public void apply(XtendParameter it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_parameters, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendConstructor) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
            _parameters = ((XtendConstructor)element).getParameters();
            _function = new Procedures.Procedure1<XtendParameter>(){

                public void apply(XtendParameter it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_parameters, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendAnnotationTarget) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
        }
    }

    private void registerMacroAnnotations(XtendAnnotationTarget candidate, IAcceptor<Pair<JvmAnnotationType, XAnnotation>> acceptor) {
        EList<XAnnotation> _annotations = candidate.getAnnotations();
        Functions.Function1<XAnnotation, Boolean> _function = new Functions.Function1<XAnnotation, Boolean>(){

            public Boolean apply(XAnnotation it) {
                return ActiveAnnotationContextProvider.this._xAnnotationExtensions.isProcessed(it);
            }
        };
        Iterable _filter = IterableExtensions.filter(_annotations, (Functions.Function1)_function);
        for (XAnnotation annotation : _filter) {
            boolean _isValid;
            boolean _notEquals;
            JvmAnnotationType activeAnnotationDeclaration = this._xAnnotationExtensions.tryFindAnnotationType(annotation);
            boolean bl = _notEquals = !Objects.equal((Object)activeAnnotationDeclaration, null);
            if (!_notEquals || !(_isValid = this.isValid(annotation, activeAnnotationDeclaration))) continue;
            Pair _mappedTo = Pair.of((Object)activeAnnotationDeclaration, (Object)annotation);
            acceptor.accept((Object)_mappedTo);
        }
    }

    private boolean isValid(XAnnotation annotation, JvmAnnotationType activeAnnotationDeclaration) {
        return !Objects.equal((Object)annotation, null);
    }
}

