/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner.compiler;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.emf.EMFQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.AggregatorCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.BinaryTransitiveClosureCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckConstant;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckPositivePatternCall;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CountCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.ExpressionCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.ExpressionEvalCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.InequalityCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.NACOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.AggregatorExtend;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.CountOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExpressionEval;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendBinaryTransitiveClosure;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendConstant;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendPositivePatternCall;
import org.eclipse.viatra.query.runtime.localsearch.planner.compiler.IOperationCompiler;
import org.eclipse.viatra.query.runtime.localsearch.planner.util.CompilerHelper;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PApply;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.POperation;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PProject;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PStart;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.AggregatorConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.PatternCallBasedDeferred;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;

public abstract class AbstractOperationCompiler
implements IOperationCompiler {
    protected static final String UNSUPPORTED_TYPE_MESSAGE = "Unsupported type: ";
    protected List<ISearchOperation> operations;
    protected Set<MatcherReference> dependencies = Sets.newHashSet();
    protected Map<PConstraint, Set<Integer>> variableBindings;
    private Map<PVariable, Integer> variableMappings;
    protected final EMFQueryRuntimeContext runtimeContext;

    protected abstract void createExtend(TypeConstraint var1, Map<PVariable, Integer> var2);

    protected abstract void createCheck(TypeConstraint var1, Map<PVariable, Integer> var2) throws QueryProcessingException;

    protected abstract void createCheck(TypeFilterConstraint var1, Map<PVariable, Integer> var2) throws QueryProcessingException;

    public AbstractOperationCompiler(IQueryRuntimeContext runtimeContext) {
        this.runtimeContext = (EMFQueryRuntimeContext)runtimeContext;
    }

    @Override
    public List<ISearchOperation> compile(SubPlan plan, Set<PParameter> boundParameters) throws QueryProcessingException {
        this.variableMappings = CompilerHelper.createVariableMapping(plan);
        this.variableBindings = CompilerHelper.cacheVariableBindings(plan, this.variableMappings, boundParameters);
        this.operations = Lists.newArrayList();
        List<POperation> operationList = CompilerHelper.createOperationsList(plan);
        for (POperation pOperation : operationList) {
            this.compile(pOperation, this.variableMappings);
        }
        return this.operations;
    }

    private void compile(POperation pOperation, Map<PVariable, Integer> variableMapping) throws QueryProcessingException {
        if (pOperation instanceof PApply) {
            PApply pApply = (PApply)pOperation;
            PConstraint pConstraint = pApply.getPConstraint();
            if (this.isCheck(pConstraint, variableMapping)) {
                this.createCheckDispatcher(pConstraint, variableMapping);
            } else {
                this.createExtendDispatcher(pConstraint, variableMapping);
            }
        } else if (!(pOperation instanceof PStart) && !(pOperation instanceof PProject)) {
            throw new QueryProcessingException("PStart, PApply or PProject was expected, received: " + pOperation.getClass(), null, "Unexpected POperation type", null);
        }
    }

    private void createCheckDispatcher(PConstraint pConstraint, Map<PVariable, Integer> variableMapping) throws QueryProcessingException {
        if (pConstraint instanceof Inequality) {
            this.createCheck((Inequality)pConstraint, variableMapping);
        } else if (pConstraint instanceof PositivePatternCall) {
            this.createCheck((PositivePatternCall)pConstraint, variableMapping);
        } else if (pConstraint instanceof NegativePatternCall) {
            this.createCheck((NegativePatternCall)pConstraint, variableMapping);
        } else if (pConstraint instanceof AggregatorConstraint) {
            this.createCheck((AggregatorConstraint)pConstraint, variableMapping);
        } else if (pConstraint instanceof PatternMatchCounter) {
            this.createCheck((PatternMatchCounter)pConstraint, variableMapping);
        } else if (pConstraint instanceof ExpressionEvaluation) {
            this.createCheck((ExpressionEvaluation)pConstraint, variableMapping);
        } else if (pConstraint instanceof TypeFilterConstraint) {
            this.createCheck((TypeFilterConstraint)pConstraint, variableMapping);
        } else if (!(pConstraint instanceof ExportedParameter)) {
            if (pConstraint instanceof BinaryTransitiveClosure) {
                this.createCheck((BinaryTransitiveClosure)pConstraint, variableMapping);
            } else if (pConstraint instanceof ConstantValue) {
                this.createCheck((ConstantValue)pConstraint, variableMapping);
            } else if (pConstraint instanceof TypeConstraint) {
                this.createCheck((TypeConstraint)pConstraint, variableMapping);
            } else {
                String msg = "Unsupported Check constraint: " + pConstraint.toString();
                throw new QueryProcessingException(msg, null, msg, null);
            }
        }
    }

    protected void createExtendDispatcher(PConstraint pConstraint, Map<PVariable, Integer> variableMapping) throws QueryProcessingException {
        if (pConstraint instanceof PositivePatternCall) {
            this.createExtend((PositivePatternCall)pConstraint, variableMapping);
        } else if (pConstraint instanceof AggregatorConstraint) {
            this.createExtend((AggregatorConstraint)pConstraint, variableMapping);
        } else if (pConstraint instanceof PatternMatchCounter) {
            this.createExtend((PatternMatchCounter)pConstraint, variableMapping);
        } else if (pConstraint instanceof ExpressionEvaluation) {
            this.createExtend((ExpressionEvaluation)pConstraint, variableMapping);
        } else if (!(pConstraint instanceof ExportedParameter)) {
            if (pConstraint instanceof ConstantValue) {
                this.createExtend((ConstantValue)pConstraint, variableMapping);
            } else if (pConstraint instanceof TypeConstraint) {
                this.createExtend((TypeConstraint)pConstraint, variableMapping);
            } else if (pConstraint instanceof BinaryTransitiveClosure) {
                this.createExtend((BinaryTransitiveClosure)pConstraint, variableMapping);
            } else {
                String msg = "Unsupported Extend constraint: " + pConstraint.toString();
                throw new QueryProcessingException(msg, null, msg, null);
            }
        }
    }

    private boolean isCheck(PConstraint pConstraint, final Map<PVariable, Integer> variableMapping) {
        if (pConstraint instanceof NegativePatternCall) {
            return true;
        }
        if (pConstraint instanceof PositivePatternCall) {
            return this.variableBindings.get(pConstraint).containsAll(Collections2.transform((Collection)Sets.filter((Set)pConstraint.getAffectedVariables(), (Predicate)new Predicate<PVariable>(){

                public boolean apply(PVariable input) {
                    return input.getReferringConstraints().size() > 1;
                }
            }), (Function)new Function<PVariable, Integer>(){

                public Integer apply(PVariable input) {
                    return (Integer)variableMapping.get(input);
                }
            }));
        }
        if (pConstraint instanceof AggregatorConstraint) {
            PVariable outputvar = ((AggregatorConstraint)pConstraint).getResultVariable();
            return this.variableBindings.get(pConstraint).contains(variableMapping.get(outputvar));
        }
        if (pConstraint instanceof PatternMatchCounter) {
            PVariable outputvar = ((PatternMatchCounter)pConstraint).getResultVariable();
            return this.variableBindings.get(pConstraint).contains(variableMapping.get(outputvar));
        }
        if (pConstraint instanceof ExpressionEvaluation) {
            PVariable outputvar = ((ExpressionEvaluation)pConstraint).getOutputVariable();
            return outputvar == null || this.variableBindings.get(pConstraint).contains(variableMapping.get(outputvar));
        }
        Set affectedVariables = pConstraint.getAffectedVariables();
        HashSet varIndices = Sets.newHashSet();
        for (PVariable variable : affectedVariables) {
            varIndices.add(variableMapping.get(variable));
        }
        return this.variableBindings.get(pConstraint).containsAll(varIndices);
    }

    @Override
    public Set<MatcherReference> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Map<PVariable, Integer> getVariableMappings() {
        return this.variableMappings;
    }

    protected void createCheck(PatternMatchCounter counter, Map<PVariable, Integer> variableMapping) {
        FrameMapping mapping = new FrameMapping((PatternCallBasedDeferred)counter, variableMapping);
        PQuery referredQuery = counter.getReferredQuery();
        MatcherReference matcherReference = new MatcherReference(referredQuery, mapping.adornment);
        this.operations.add(new CountCheck(matcherReference, mapping.mapping, variableMapping.get(counter.getResultVariable())));
        this.dependencies.add(matcherReference);
    }

    protected void createCheck(PositivePatternCall pCall, Map<PVariable, Integer> variableMapping) {
        FrameMapping mapping = new FrameMapping(pCall, variableMapping);
        MatcherReference matcherReference = new MatcherReference(pCall.getReferredQuery(), mapping.adornment);
        this.operations.add(new CheckPositivePatternCall(matcherReference, mapping.mapping));
        this.dependencies.add(matcherReference);
    }

    protected void createCheck(ConstantValue constant, Map<PVariable, Integer> variableMapping) {
        int position = variableMapping.get(constant.getVariablesTuple().get(0));
        this.operations.add(new CheckConstant(position, constant.getSupplierKey()));
    }

    protected void createCheck(BinaryTransitiveClosure binaryTransitiveColsure, Map<PVariable, Integer> variableMapping) {
        int sourcePosition = variableMapping.get(binaryTransitiveColsure.getVariablesTuple().get(0));
        int targetPosition = variableMapping.get(binaryTransitiveColsure.getVariablesTuple().get(1));
        PQuery referredQuery = binaryTransitiveColsure.getReferredQuery();
        this.operations.add(new BinaryTransitiveClosureCheck(new MatcherReference(referredQuery, (Set<PParameter>)ImmutableSet.of((Object)((PParameter)referredQuery.getParameters().get(0)), (Object)((PParameter)referredQuery.getParameters().get(1)))), sourcePosition, targetPosition));
        ImmutableSet adornment = ImmutableSet.of((Object)((PParameter)referredQuery.getParameters().get(0)));
        this.dependencies.add(new MatcherReference(referredQuery, (Set<PParameter>)adornment));
    }

    protected void createCheck(ExpressionEvaluation expressionEvaluation, Map<PVariable, Integer> variableMapping) {
        Iterable inputParameterNames = expressionEvaluation.getEvaluator().getInputParameterNames();
        HashMap nameMap = Maps.newHashMap();
        for (String pVariableName : inputParameterNames) {
            PVariable pVariable = expressionEvaluation.getPSystem().getVariableByNameChecked((Object)pVariableName);
            nameMap.put(pVariableName, variableMapping.get(pVariable));
        }
        if (expressionEvaluation.getOutputVariable() == null) {
            this.operations.add(new ExpressionCheck(expressionEvaluation.getEvaluator(), nameMap));
        } else {
            this.operations.add(new ExpressionEvalCheck(expressionEvaluation.getEvaluator(), nameMap, variableMapping.get(expressionEvaluation.getOutputVariable())));
        }
    }

    protected void createCheck(AggregatorConstraint aggregator, Map<PVariable, Integer> variableMapping) {
        FrameMapping mapping = new FrameMapping((PatternCallBasedDeferred)aggregator, variableMapping);
        PQuery referredQuery = aggregator.getReferredQuery();
        MatcherReference matcherReference = new MatcherReference(referredQuery, mapping.adornment);
        this.operations.add(new AggregatorCheck(matcherReference, aggregator, mapping.mapping, variableMapping.get(aggregator.getResultVariable())));
        this.dependencies.add(matcherReference);
    }

    protected void createCheck(NegativePatternCall negativePatternCall, Map<PVariable, Integer> variableMapping) {
        FrameMapping mapping = new FrameMapping((PatternCallBasedDeferred)negativePatternCall, variableMapping);
        PQuery referredQuery = negativePatternCall.getReferredQuery();
        MatcherReference matcherReference = new MatcherReference(referredQuery, mapping.adornment);
        this.operations.add(new NACOperation(matcherReference, mapping.mapping));
        this.dependencies.add(matcherReference);
    }

    protected void createCheck(Inequality inequality, Map<PVariable, Integer> variableMapping) {
        this.operations.add(new InequalityCheck(variableMapping.get(inequality.getWho()), variableMapping.get(inequality.getWithWhom())));
    }

    protected void createExtend(PositivePatternCall pCall, Map<PVariable, Integer> variableMapping) {
        FrameMapping mapping = new FrameMapping(pCall, variableMapping);
        MatcherReference matcherReference = new MatcherReference(pCall.getReferredQuery(), mapping.adornment);
        this.operations.add(new ExtendPositivePatternCall(matcherReference, mapping.mapping));
        this.dependencies.add(matcherReference);
    }

    protected void createExtend(BinaryTransitiveClosure binaryTransitiveClosure, Map<PVariable, Integer> variableMapping) throws QueryProcessingException {
        int sourcePosition = variableMapping.get(binaryTransitiveClosure.getVariablesTuple().get(0));
        int targetPosition = variableMapping.get(binaryTransitiveClosure.getVariablesTuple().get(1));
        PQuery referredQuery = binaryTransitiveClosure.getReferredQuery();
        boolean sourceBound = this.variableBindings.get(binaryTransitiveClosure).contains(sourcePosition);
        boolean targetBound = this.variableBindings.get(binaryTransitiveClosure).contains(targetPosition);
        if (sourceBound && !targetBound) {
            ImmutableSet adornment = ImmutableSet.of((Object)((PParameter)referredQuery.getParameters().get(0)));
            this.operations.add(new ExtendBinaryTransitiveClosure.Forward(new MatcherReference(referredQuery, (Set<PParameter>)adornment), sourcePosition, targetPosition));
            this.dependencies.add(new MatcherReference(referredQuery, (Set<PParameter>)adornment));
        } else if (!sourceBound && targetBound) {
            ImmutableSet adornment = ImmutableSet.of((Object)((PParameter)referredQuery.getParameters().get(1)));
            this.operations.add(new ExtendBinaryTransitiveClosure.Backward(new MatcherReference(referredQuery, (Set<PParameter>)adornment), sourcePosition, targetPosition));
            this.dependencies.add(new MatcherReference(referredQuery, (Set<PParameter>)adornment));
        } else {
            String msg = "Binary transitive closure not supported with two unbound parameters";
            throw new QueryProcessingException(msg, null, msg, (Object)binaryTransitiveClosure.getPSystem().getPattern());
        }
    }

    protected void createExtend(ConstantValue constant, Map<PVariable, Integer> variableMapping) {
        int position = variableMapping.get(constant.getVariablesTuple().get(0));
        this.operations.add(new ExtendConstant(position, constant.getSupplierKey()));
    }

    protected void createExtend(ExpressionEvaluation expressionEvaluation, Map<PVariable, Integer> variableMapping) {
        Iterable inputParameterNames = expressionEvaluation.getEvaluator().getInputParameterNames();
        HashMap nameMap = Maps.newHashMap();
        for (String pVariableName : inputParameterNames) {
            PVariable pVariable = expressionEvaluation.getPSystem().getVariableByNameChecked((Object)pVariableName);
            nameMap.put(pVariableName, variableMapping.get(pVariable));
        }
        if (expressionEvaluation.getOutputVariable() == null) {
            this.operations.add(new ExpressionCheck(expressionEvaluation.getEvaluator(), nameMap));
        } else {
            this.operations.add(new ExpressionEval(expressionEvaluation.getEvaluator(), nameMap, variableMapping.get(expressionEvaluation.getOutputVariable())));
        }
    }

    protected void createExtend(AggregatorConstraint aggregator, Map<PVariable, Integer> variableMapping) {
        FrameMapping mapping = new FrameMapping((PatternCallBasedDeferred)aggregator, variableMapping);
        PQuery referredQuery = aggregator.getReferredQuery();
        MatcherReference matcherReference = new MatcherReference(referredQuery, mapping.adornment);
        this.operations.add(new AggregatorExtend(matcherReference, aggregator, mapping.mapping, variableMapping.get(aggregator.getResultVariable())));
        this.dependencies.add(matcherReference);
    }

    protected void createExtend(PatternMatchCounter patternMatchCounter, Map<PVariable, Integer> variableMapping) {
        FrameMapping mapping = new FrameMapping((PatternCallBasedDeferred)patternMatchCounter, variableMapping);
        PQuery referredQuery = patternMatchCounter.getReferredQuery();
        MatcherReference matcherReference = new MatcherReference(referredQuery, mapping.adornment);
        this.operations.add(new CountOperation(matcherReference, mapping.mapping, variableMapping.get(patternMatchCounter.getResultVariable())));
        this.dependencies.add(matcherReference);
    }

    public class FrameMapping {
        public final Map<PParameter, Integer> mapping = Maps.newHashMap();
        public final Set<PParameter> adornment = Sets.newHashSet();

        public FrameMapping(PatternCallBasedDeferred constraint, Map<PVariable, Integer> variableMapping) {
            Set<Integer> bindings = AbstractOperationCompiler.this.variableBindings.get(constraint);
            int keySize = constraint.getActualParametersTuple().getSize();
            int i = 0;
            while (i < keySize) {
                PParameter symbolicParameter = (PParameter)constraint.getReferredQuery().getParameters().get(i);
                PVariable parameter = (PVariable)constraint.getActualParametersTuple().get(i);
                this.mapping.put(symbolicParameter, variableMapping.get(parameter));
                if (bindings.contains(variableMapping.get(parameter))) {
                    this.adornment.add(symbolicParameter);
                }
                ++i;
            }
        }

        public FrameMapping(PositivePatternCall pCall, Map<PVariable, Integer> variableMapping) {
            Set<Integer> bindings = AbstractOperationCompiler.this.variableBindings.get(pCall);
            int keySize = pCall.getVariablesTuple().getSize();
            int i = 0;
            while (i < keySize) {
                PParameter symbolicParameter = (PParameter)pCall.getReferredQuery().getParameters().get(i);
                PVariable parameter = (PVariable)pCall.getVariablesTuple().get(i);
                this.mapping.put(symbolicParameter, variableMapping.get(parameter));
                if (bindings.contains(variableMapping.get(parameter))) {
                    this.adornment.add(symbolicParameter);
                }
                ++i;
            }
        }
    }
}

