/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.matcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.MatchingTable;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdaptable;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanDescriptor;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanExecutor;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class LocalSearchMatcher
implements ILocalSearchAdaptable {
    private ImmutableList<SearchPlanExecutor> plan;
    private int frameSize;
    private IPlanDescriptor planDescriptor;
    private List<ILocalSearchAdapter> adapters = Lists.newLinkedList();

    public ImmutableList<SearchPlanExecutor> getPlan() {
        return this.plan;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    @Override
    public List<ILocalSearchAdapter> getAdapters() {
        return Lists.newArrayList(this.adapters);
    }

    protected LocalSearchMatcher(IPlanDescriptor query) {
        Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"Cannot initialize matcher with null query.");
        this.planDescriptor = query;
    }

    public LocalSearchMatcher(IPlanDescriptor planDescriptor, SearchPlanExecutor plan, int frameSize) {
        this(planDescriptor, (ImmutableList<SearchPlanExecutor>)ImmutableList.of((Object)plan), frameSize);
    }

    public LocalSearchMatcher(IPlanDescriptor planDescriptor, SearchPlanExecutor[] plan, int frameSize) {
        this(planDescriptor, (ImmutableList<SearchPlanExecutor>)ImmutableList.copyOf((Object[])plan), frameSize);
    }

    public LocalSearchMatcher(IPlanDescriptor planDescriptor, Collection<SearchPlanExecutor> plan, int frameSize) {
        this(planDescriptor, (ImmutableList<SearchPlanExecutor>)ImmutableList.copyOf(plan), frameSize);
    }

    protected LocalSearchMatcher(IPlanDescriptor planDescriptor, ImmutableList<SearchPlanExecutor> plan, int frameSize) {
        this(planDescriptor);
        this.plan = plan;
        this.frameSize = frameSize;
        this.adapters = Lists.newLinkedList(this.adapters);
    }

    @Override
    public void addAdapter(ILocalSearchAdapter adapter) {
        this.addAdapters(Lists.newArrayList((Object[])new ILocalSearchAdapter[]{adapter}));
    }

    @Override
    public void removeAdapter(ILocalSearchAdapter adapter) {
        this.addAdapters(Lists.newArrayList((Object[])new ILocalSearchAdapter[]{adapter}));
    }

    @Override
    public void addAdapters(List<ILocalSearchAdapter> adapters) {
        this.adapters.addAll(adapters);
        for (ILocalSearchAdapter adapter : adapters) {
            adapter.adapterRegistered(this);
        }
    }

    @Override
    public void removeAdapters(List<ILocalSearchAdapter> adapters) {
        this.adapters.removeAll(adapters);
        for (ILocalSearchAdapter adapter : adapters) {
            adapter.adapterUnregistered(this);
        }
    }

    protected void setPlan(SearchPlanExecutor plan) {
        this.plan = ImmutableList.of((Object)plan);
    }

    protected void setPlan(SearchPlanExecutor[] plan) {
        this.plan = ImmutableList.copyOf((Object[])plan);
    }

    protected void setFramesize(int frameSize) {
        this.frameSize = frameSize;
    }

    public MatchingFrame editableMatchingFrame() {
        return new MatchingFrame(null, this.frameSize);
    }

    public boolean hasMatch() {
        boolean hasMatch = this.hasMatch(this.editableMatchingFrame());
        return hasMatch;
    }

    public boolean hasMatch(MatchingFrame initialFrame) {
        this.matchingStarted();
        PlanExecutionIterator it = new PlanExecutionIterator(this.plan, initialFrame);
        boolean hasMatch = it.hasNext();
        this.matchingFinished();
        return hasMatch;
    }

    public int countMatches() {
        int countMatches = this.countMatches(this.editableMatchingFrame());
        return countMatches;
    }

    public int countMatches(MatchingFrame initialFrame) {
        this.matchingStarted();
        PlanExecutionIterator it = new PlanExecutionIterator(this.plan, initialFrame);
        MatchingTable results = new MatchingTable();
        while (it.hasNext()) {
            MatchingFrame frame = it.next();
            results.put(frame.getKey(), frame);
        }
        int result = results.size();
        this.matchingFinished();
        return result;
    }

    public int getParameterCount() {
        return this.planDescriptor.getQuery().getParameters().size();
    }

    public MatchingFrame getOneArbitraryMatch() {
        MatchingFrame oneArbitraryMatch = this.getOneArbitraryMatch(this.editableMatchingFrame());
        return oneArbitraryMatch;
    }

    public MatchingFrame getOneArbitraryMatch(MatchingFrame initialFrame) {
        this.matchingStarted();
        PlanExecutionIterator it = new PlanExecutionIterator(this.plan, initialFrame);
        MatchingFrame returnValue = null;
        if (it.hasNext()) {
            returnValue = it.next();
        }
        this.matchingFinished();
        return returnValue;
    }

    public Collection<Tuple> getAllMatches() {
        Collection<Tuple> allMatches = this.getAllMatches(this.editableMatchingFrame());
        return allMatches;
    }

    private void matchingStarted() {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.patternMatchingStarted(this);
        }
    }

    private void matchingFinished() {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.patternMatchingFinished(this);
        }
    }

    public Collection<Tuple> getAllMatches(MatchingFrame initialFrame) {
        this.matchingStarted();
        PlanExecutionIterator it = new PlanExecutionIterator(this.plan, initialFrame);
        MatchingTable results = new MatchingTable();
        while (it.hasNext()) {
            MatchingFrame frame = it.next();
            results.put(frame.getKey(), frame);
        }
        this.matchingFinished();
        return ImmutableList.copyOf(results.iterator());
    }

    public PQuery getQuerySpecification() {
        return this.planDescriptor.getQuery();
    }

    public IPlanDescriptor getPlanDescriptor() {
        return this.planDescriptor;
    }

    private class PlanExecutionIterator
    extends UnmodifiableIterator<MatchingFrame> {
        private UnmodifiableIterator<SearchPlanExecutor> iterator;
        private SearchPlanExecutor currentPlan;
        private MatchingFrame frame;
        private boolean frameReturned;

        public PlanExecutionIterator(ImmutableList<SearchPlanExecutor> plan, MatchingFrame initialFrame) {
            this.frame = new MatchingFrame(initialFrame);
            Preconditions.checkArgument((!plan.isEmpty() ? 1 : 0) != 0);
            this.iterator = plan.iterator();
            this.getNextPlan();
            this.frameReturned = true;
        }

        private void getNextPlan() {
            if (this.currentPlan != null) {
                this.currentPlan.removeAdapters(LocalSearchMatcher.this.adapters);
            }
            SearchPlanExecutor nextPlan = (SearchPlanExecutor)this.iterator.next();
            nextPlan.addAdapters(LocalSearchMatcher.this.adapters);
            nextPlan.resetPlan();
            for (ILocalSearchAdapter adapter : LocalSearchMatcher.this.adapters) {
                adapter.planChanged(this.currentPlan, nextPlan);
            }
            this.currentPlan = nextPlan;
        }

        public boolean hasNext() {
            if (!this.frameReturned) {
                return true;
            }
            try {
                boolean foundMatch = this.currentPlan.execute(this.frame);
                while (!foundMatch && this.iterator.hasNext()) {
                    this.getNextPlan();
                    foundMatch = this.currentPlan.execute(this.frame);
                }
                if (foundMatch) {
                    this.frameReturned = false;
                }
                return foundMatch;
            }
            catch (LocalSearchException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }

        public MatchingFrame next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more matches available.");
            }
            this.frameReturned = true;
            return new MatchingFrame(this.frame);
        }
    }
}

