/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.phases;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostType;
import org.eclipse.viatra.examples.cps.generator.dtos.CPSFragment;
import org.eclipse.viatra.examples.cps.generator.dtos.HostClass;
import org.eclipse.viatra.examples.cps.generator.operations.HostInstanceCommunicatesWithOperation;
import org.eclipse.viatra.examples.cps.generator.utils.CPSModelBuilderUtil;
import org.eclipse.viatra.examples.cps.generator.utils.RandomUtils;
import org.eclipse.viatra.examples.cps.planexecutor.api.IOperation;
import org.eclipse.viatra.examples.cps.planexecutor.api.IPhase;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CPSPhaseHostCommunication
implements IPhase<CPSFragment> {
    @Extension
    private RandomUtils randUtil = new RandomUtils();

    public Iterable<IOperation<CPSFragment>> getOperations(CPSFragment fragment) {
        try {
            ArrayList operations = Lists.newArrayList();
            HashMultimap<HostClass, HostInstance> hostClassToInstanceMap = CPSModelBuilderUtil.calculateHostInstancesToHostClassMap(fragment);
            Set _keySet = fragment.getHostTypes().keySet();
            for (HostClass hostClass : _keySet) {
                ArrayList<HostInstance> possibleTargetInstances = this.calculatePossibleTargetInstances(hostClass, hostClassToInstanceMap);
                Collection _get = fragment.getHostTypes().get((Object)hostClass);
                for (HostType hostType : _get) {
                    EList _instances = hostType.getInstances();
                    for (HostInstance hostInstance : _instances) {
                        ArrayList possibleTargetCopy = Lists.newArrayList(possibleTargetInstances);
                        possibleTargetCopy.remove(hostInstance);
                        int numberOfCommLinks = this.randUtil.randInt(hostClass.numberOfCommunicationLines, fragment.getRandom());
                        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, numberOfCommLinks, true);
                        for (Integer i : _doubleDotLessThan) {
                            boolean _notEquals;
                            boolean _not;
                            boolean _isEmpty = possibleTargetCopy.isEmpty();
                            boolean bl = _not = !_isEmpty;
                            if (!_not) continue;
                            HostInstance targetHostInstance = (HostInstance)this.randUtil.randElement(possibleTargetCopy, fragment.getRandom());
                            boolean bl2 = _notEquals = !Objects.equal((Object)targetHostInstance, null);
                            if (!_notEquals) continue;
                            possibleTargetCopy.remove(targetHostInstance);
                            HostInstanceCommunicatesWithOperation _hostInstanceCommunicatesWithOperation = new HostInstanceCommunicatesWithOperation(hostInstance, targetHostInstance);
                            operations.add(_hostInstanceCommunicatesWithOperation);
                        }
                    }
                }
            }
            return operations;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ArrayList<HostInstance> calculatePossibleTargetInstances(HostClass sourceClass, HashMultimap<HostClass, HostInstance> hostClassToInstances) {
        Functions.Function2<Integer, Integer, Integer> _function = new Functions.Function2<Integer, Integer, Integer>(){

            public Integer apply(Integer min, Integer act) {
                Integer _xifexpression = null;
                _xifexpression = act.compareTo(min) < 0 && act != 0 ? act : min;
                return _xifexpression;
            }
        };
        Integer minRatio = (Integer)IterableExtensions.fold(sourceClass.communicationRatios.values(), (Object)Integer.MAX_VALUE, (Functions.Function2)_function);
        ArrayList possibleInstances = Lists.newArrayList();
        Set<HostClass> _keySet = sourceClass.communicationRatios.keySet();
        for (HostClass targetHClass : _keySet) {
            Integer targetRatio = sourceClass.communicationRatios.get(targetHClass);
            int normRatio = Math.round((float)targetRatio.intValue() / (float)minRatio.intValue());
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, normRatio, true);
            for (Integer i : _doubleDotLessThan) {
                possibleInstances.addAll(hostClassToInstances.get((Object)targetHClass));
            }
        }
        return possibleInstances;
    }
}

