/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.dtos;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.examples.cps.deployment.Deployment;
import org.eclipse.viatra.examples.cps.deployment.DeploymentPackage;
import org.eclipse.viatra.examples.cps.generator.dtos.ModelStats;
import org.eclipse.viatra.examples.cps.generator.utils.StatsUtil;
import org.eclipse.viatra.examples.cps.generator.utils.SumProcessor;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.base.api.IEClassifierProcessor;
import org.eclipse.viatra.query.runtime.base.api.IEStructuralFeatureProcessor;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.base.api.ViatraBaseFactory;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class DeploymentStats
extends ModelStats {
    private Logger logger = Logger.getLogger((String)"cps.generator.StatsUtil.DeploymentStats");
    public int deploymentHosts = 0;
    public int deploymentApps = 0;
    public int deploymentBehavior = 0;
    public int deploymentState = 0;
    public int deploymentTransition = 0;
    public int deploymentCurrent = 0;
    public int deploymentTrigger = 0;
    public int deploymentOutgoing = 0;

    public void log() {
        this.logger.info((Object)"====================================================================");
        this.logger.info((Object)"= Deployment Stats: ");
        this.logger.info((Object)("=   Hosts: " + Integer.valueOf(this.deploymentHosts)));
        this.logger.info((Object)("=   Apps: " + Integer.valueOf(this.deploymentApps)));
        this.logger.info((Object)("=   Behaviors: " + Integer.valueOf(this.deploymentBehavior)));
        this.logger.info((Object)("=   States: " + Integer.valueOf(this.deploymentState)));
        this.logger.info((Object)("=   Transitions: " + Integer.valueOf(this.deploymentTransition)));
        this.logger.info((Object)("=   Current States: " + Integer.valueOf(this.deploymentCurrent)));
        this.logger.info((Object)("=   Triggers: " + Integer.valueOf(this.deploymentTrigger)));
        this.logger.info((Object)("=   Outgoing: " + Integer.valueOf(this.deploymentOutgoing)));
        this.logger.info((Object)("=   EObjects: " + Integer.valueOf(this.eObjects)));
        this.logger.info((Object)("=   EReferences: " + Integer.valueOf(this.eReferences)));
        this.logger.info((Object)"====================================================================");
    }

    public DeploymentStats(ViatraQueryEngine engine, Deployment model) {
        try {
            NavigationHelper baseIndex = ViatraBaseFactory.getInstance().createNavigationHelper((Notifier)model.eResource().getResourceSet(), true, this.logger);
            SumProcessor sumProcessor = new SumProcessor();
            baseIndex.processAllInstances(DeploymentPackage.Literals.DEPLOYMENT_APPLICATION, (IEClassifierProcessor.IEClassProcessor)sumProcessor);
            this.deploymentApps = sumProcessor.getSum();
            sumProcessor.resetSum();
            SumProcessor sp = new SumProcessor();
            baseIndex.processAllInstances(DeploymentPackage.Literals.DEPLOYMENT_HOST, (IEClassifierProcessor.IEClassProcessor)sp);
            this.deploymentHosts = sp.getSum();
            SumProcessor sp2 = new SumProcessor();
            baseIndex.processAllInstances(DeploymentPackage.Literals.DEPLOYMENT_BEHAVIOR, (IEClassifierProcessor.IEClassProcessor)sp2);
            this.deploymentBehavior = sp2.getSum();
            SumProcessor sp3 = new SumProcessor();
            baseIndex.processAllInstances(DeploymentPackage.Literals.BEHAVIOR_STATE, (IEClassifierProcessor.IEClassProcessor)sp3);
            this.deploymentState = sp3.getSum();
            SumProcessor sp4 = new SumProcessor();
            baseIndex.processAllInstances(DeploymentPackage.Literals.BEHAVIOR_TRANSITION, (IEClassifierProcessor.IEClassProcessor)sp4);
            this.deploymentTransition = sp4.getSum();
            SumProcessor sp5 = new SumProcessor();
            baseIndex.processAllFeatureInstances((EStructuralFeature)DeploymentPackage.Literals.DEPLOYMENT_BEHAVIOR__CURRENT, (IEStructuralFeatureProcessor)sp5);
            this.deploymentCurrent = sp5.getSum();
            SumProcessor sp6 = new SumProcessor();
            baseIndex.processAllFeatureInstances((EStructuralFeature)DeploymentPackage.Literals.BEHAVIOR_TRANSITION__TRIGGER, (IEStructuralFeatureProcessor)sp6);
            this.deploymentTrigger = sp6.getSum();
            SumProcessor sp7 = new SumProcessor();
            baseIndex.processAllFeatureInstances((EStructuralFeature)DeploymentPackage.Literals.BEHAVIOR_STATE__OUTGOING, (IEStructuralFeatureProcessor)sp7);
            this.deploymentOutgoing = sp7.getSum();
            this.eObjects = IteratorExtensions.size((Iterator)model.eAllContents());
            this.eReferences = StatsUtil.countEdges((EObject)model);
            baseIndex.dispose();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

