/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.profiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdaptable;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanExecutor;

public class LocalSearchProfilerAdapter
implements ILocalSearchAdapter {
    private final Map<MatcherReference, PlanProfile> profile = new HashMap<MatcherReference, PlanProfile>();
    private final Map<SearchPlanExecutor, int[]> currentBodies = new HashMap<SearchPlanExecutor, int[]>();

    @Override
    public void adapterRegistered(ILocalSearchAdaptable adaptable) {
    }

    @Override
    public void adapterUnregistered(ILocalSearchAdaptable adaptable) {
    }

    @Override
    public void patternMatchingStarted(LocalSearchMatcher lsMatcher) {
        MatcherReference key = new MatcherReference(lsMatcher.getPlanDescriptor().getQuery(), lsMatcher.getPlanDescriptor().getAdornment());
        PlanProfile pp = this.profile.computeIfAbsent(key, input -> new PlanProfile(lsMatcher));
        pp.register(lsMatcher);
    }

    @Override
    public void patternMatchingFinished(LocalSearchMatcher lsMatcher) {
        MatcherReference key = new MatcherReference(lsMatcher.getPlanDescriptor().getQuery(), lsMatcher.getPlanDescriptor().getAdornment());
        this.profile.computeIfPresent(key, (ref, pp) -> {
            pp.unRegister(lsMatcher);
            return null;
        });
    }

    @Override
    public void planChanged(SearchPlanExecutor oldPlanExecutor, SearchPlanExecutor newPlanExecutor) {
    }

    @Override
    public void operationSelected(SearchPlanExecutor planExecutor, MatchingFrame frame) {
    }

    @Override
    public void operationExecuted(SearchPlanExecutor planExecutor, MatchingFrame frame) {
        int[] bodyProfile = this.currentBodies.get(planExecutor);
        int n = planExecutor.getCurrentOperation();
        bodyProfile[n] = bodyProfile[n] + 1;
    }

    @Override
    public void matchFound(SearchPlanExecutor planExecutor, MatchingFrame frame) {
    }

    @Override
    public void executorInitializing(SearchPlanExecutor searchPlanExecutor, MatchingFrame frame) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<MatcherReference, PlanProfile> entry : this.profile.entrySet()) {
            sb.append(entry.getKey());
            sb.append("\n");
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    private class PlanProfile {
        final int[][] bodies;
        final ArrayList<List<ISearchOperation>> operations;

        public PlanProfile(LocalSearchMatcher lsMatcher) {
            List<SearchPlanExecutor> plan = lsMatcher.getPlan();
            this.bodies = new int[plan.size()][];
            this.operations = new ArrayList(plan.size());
            int i = 0;
            while (i < this.bodies.length) {
                List<ISearchOperation> ops = plan.get(i).getSearchPlan().getOperations();
                this.operations.add(i, ops);
                this.bodies[i] = new int[ops.size()];
                ++i;
            }
        }

        public void register(LocalSearchMatcher lsMatcher) {
            List<SearchPlanExecutor> plan = lsMatcher.getPlan();
            int i = 0;
            while (i < this.bodies.length) {
                LocalSearchProfilerAdapter.this.currentBodies.put(plan.get(i), this.bodies[i]);
                ++i;
            }
        }

        public void unRegister(LocalSearchMatcher lsMatcher) {
            for (SearchPlanExecutor executor : lsMatcher.getPlan()) {
                LocalSearchProfilerAdapter.this.currentBodies.remove(executor);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{\n");
            int i = 0;
            while (i < this.bodies.length) {
                sb.append("\tbody #");
                sb.append(i);
                sb.append("(\n");
                int j = 0;
                while (j < this.operations.get(i).size()) {
                    sb.append("\t\t");
                    sb.append(this.bodies[i][j]);
                    sb.append("\t");
                    sb.append(this.operations.get(i).get(j));
                    sb.append("\n");
                    ++j;
                }
                sb.append("\t)\n");
                ++i;
            }
            sb.append("}\n");
            return sb.toString();
        }
    }
}

