/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class BinaryTransitiveClosureCheck
extends CheckOperation
implements IPatternMatcherOperation {
    private final CallInformation information;
    private IQueryResultProvider matcher;
    private final int sourcePosition;
    private final int targetPosition;

    public BinaryTransitiveClosureCheck(CallInformation information, int sourcePosition, int targetPosition) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.information = information;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        super.onInitialize(frame, context);
        this.matcher = context.getMatcher(this.information.getReference());
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) {
        Object targetValue = frame.get(this.targetPosition);
        LinkedList<Object> sourcesToEvaluate = new LinkedList<Object>();
        sourcesToEvaluate.add(frame.get(this.sourcePosition));
        HashSet sourceEvaluated = new HashSet();
        Object[] mappedFrame = new Object[2];
        while (!sourcesToEvaluate.isEmpty()) {
            Object currentValue = sourcesToEvaluate.poll();
            sourceEvaluated.add(currentValue);
            mappedFrame[0] = currentValue;
            for (Tuple match : this.matcher.getAllMatches(mappedFrame)) {
                Object foundTarget = match.get(1);
                if (targetValue.equals(foundTarget)) {
                    return true;
                }
                if (sourceEvaluated.contains(foundTarget)) continue;
                sourcesToEvaluate.add(foundTarget);
            }
        }
        return false;
    }

    public String toString() {
        String c = this.information.toString();
        int p = c.indexOf(40);
        return "check     find " + c.substring(0, p) + "+" + c.substring(p);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.sourcePosition, this.targetPosition);
    }
}

