/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.queries.MonitoredHostInstanceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.AbstractRule;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class HostUpdate
extends AbstractRule<MonitoredHostInstanceMatch> {
    public HostUpdate(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public RuleSpecification<MonitoredHostInstanceMatch> getSpecification() {
        Job<MonitoredHostInstanceMatch> _appearedJob = this.getAppearedJob();
        Job<MonitoredHostInstanceMatch> _disappearedJob = this.getDisappearedJob();
        Job<MonitoredHostInstanceMatch> _updatedJob = this.getUpdatedJob();
        return Rules.newMatcherRuleSpecification((IQuerySpecification)this.cpsXformM2M.getMonitoredHostInstance(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _disappearedJob, _updatedJob})));
    }

    private Job<MonitoredHostInstanceMatch> getAppearedJob() {
        IMatchProcessor _function = match -> {
            String hostIp = match.getHostInstance().getNodeIp();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Starting monitoring mapped host with IP: ");
            _builder.append(hostIp);
            this.logger.debug((Object)_builder);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private Job<MonitoredHostInstanceMatch> getDisappearedJob() {
        IMatchProcessor _function = match -> {
            String hostIp = match.getHostInstance().getNodeIp();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Stopped monitoring mapped host with IP: ");
            _builder.append(hostIp);
            this.logger.debug((Object)_builder);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }

    private Job<MonitoredHostInstanceMatch> getUpdatedJob() {
        IMatchProcessor _function = match -> {
            String hostIp = match.getHostInstance().getNodeIp();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Updating mapped host with IP: ");
            _builder.append(hostIp);
            this.logger.debug((Object)_builder);
            Set<DeploymentHost> depHosts = this.cpsXformM2M.getMappedHostInstance(this.engine).getAllValuesOfdepHost(match.getHostInstance());
            Consumer<DeploymentHost> _function_1 = it -> {
                boolean _notEquals;
                String nodeIp = it.getIp();
                boolean bl = _notEquals = !Objects.equal((Object)nodeIp, (Object)hostIp);
                if (_notEquals) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("IP changed to ");
                    _builder_1.append(hostIp);
                    this.logger.trace((Object)_builder_1);
                    it.setIp(hostIp);
                }
            };
            depHosts.forEach(_function_1);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Updated mapped host with IP: ");
            _builder_1.append(hostIp);
            this.logger.debug((Object)_builder_1);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }
}

