/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets.zooming;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef4.zest.core.widgets.internal.SharedMessages;
import org.eclipse.gef4.zest.core.widgets.zooming.ZoomListener;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoomManager {
    public static final int ANIMATE_NEVER = 0;
    public static final int ANIMATE_ZOOM_IN_OUT = 1;
    private List<ZoomListener> listeners = new ArrayList<ZoomListener>();
    private double multiplier = 1.0;
    private ScalableFigure pane;
    private Viewport viewport;
    private double zoom = 1.0;
    private String currentZoomContant = null;
    private double[] zoomLevels = new double[]{0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0};
    public static final String FIT_HEIGHT = SharedMessages.FitHeightAction_Label;
    public static final String FIT_WIDTH = SharedMessages.FitWidthAction_Label;
    public static final String FIT_ALL = SharedMessages.FitAllAction_Label;
    private List<String> zoomLevelContributions = Collections.emptyList();

    public ZoomManager(ScalableFigure pane, Viewport viewport) {
        this.pane = pane;
        this.viewport = viewport;
        this.zoomLevelContributions = new ArrayList<String>();
        this.zoomLevelContributions.add(FIT_ALL);
    }

    public ZoomManager(ScalableFreeformLayeredPane pane, Viewport viewport) {
        this.pane = pane;
        this.viewport = viewport;
    }

    public void addZoomListener(ZoomListener listener) {
        this.listeners.add(listener);
    }

    public boolean canZoomIn() {
        return this.getZoom() < this.getMaxZoom();
    }

    public boolean canZoomOut() {
        return this.getZoom() > this.getMinZoom();
    }

    protected void fireZoomChanged() {
        Iterator<ZoomListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().zoomChanged(this.zoom);
        }
    }

    private double getFitXZoomLevel(int which) {
        ScalableFigure fig = this.getScalableFigure();
        Dimension available = this.getViewport().getClientArea().getSize();
        Dimension desired = fig instanceof FreeformFigure ? ((FreeformFigure)fig).getFreeformExtent().getCopy().union(0, 0).getSize() : fig.getPreferredSize().getCopy();
        desired.width -= fig.getInsets().getWidth();
        desired.height -= fig.getInsets().getHeight();
        while (fig != this.getViewport()) {
            available.width -= fig.getInsets().getWidth();
            available.height -= fig.getInsets().getHeight();
            fig = fig.getParent();
        }
        double scaleX = Math.min((double)available.width * this.zoom / (double)desired.width, this.getMaxZoom());
        double scaleY = Math.min((double)available.height * this.zoom / (double)desired.height, this.getMaxZoom());
        if (which == 0) {
            return scaleX;
        }
        if (which == 1) {
            return scaleY;
        }
        return Math.min(scaleX, scaleY);
    }

    protected double getFitHeightZoomLevel() {
        return this.getFitXZoomLevel(1);
    }

    protected double getFitPageZoomLevel() {
        return this.getFitXZoomLevel(2);
    }

    protected double getFitWidthZoomLevel() {
        return this.getFitXZoomLevel(0);
    }

    public double getMaxZoom() {
        return this.getZoomLevels()[this.getZoomLevels().length - 1];
    }

    public double getMinZoom() {
        return this.getZoomLevels()[0];
    }

    public double getUIMultiplier() {
        return this.multiplier;
    }

    public double getNextZoomLevel() {
        int i = 0;
        while (i < this.zoomLevels.length) {
            if (this.zoomLevels[i] > this.zoom) {
                return this.zoomLevels[i];
            }
            ++i;
        }
        return this.getMaxZoom();
    }

    public double getPreviousZoomLevel() {
        int i = 1;
        while (i < this.zoomLevels.length) {
            if (this.zoomLevels[i] >= this.zoom) {
                return this.zoomLevels[i - 1];
            }
            ++i;
        }
        return this.getMinZoom();
    }

    public ScalableFigure getScalableFigure() {
        return this.pane;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public double getZoom() {
        return this.zoom;
    }

    private String format(double d) {
        return (int)(d * 100.0) + "%";
    }

    public String getZoomAsText() {
        if (this.currentZoomContant != null) {
            return this.currentZoomContant;
        }
        String newItem = this.format(this.zoom * this.multiplier);
        return newItem;
    }

    public List<String> getZoomLevelContributions() {
        return this.zoomLevelContributions;
    }

    public double[] getZoomLevels() {
        return this.zoomLevels;
    }

    public String[] getZoomLevelsAsText() {
        int i;
        String[] zoomLevelStrings = new String[this.zoomLevels.length + this.zoomLevelContributions.size()];
        if (this.zoomLevelContributions != null) {
            i = 0;
            while (i < this.zoomLevelContributions.size()) {
                zoomLevelStrings[i] = this.zoomLevelContributions.get(i);
                ++i;
            }
        }
        i = 0;
        while (i < this.zoomLevels.length) {
            zoomLevelStrings[i + this.zoomLevelContributions.size()] = this.format(this.zoomLevels[i] * this.multiplier);
            ++i;
        }
        return zoomLevelStrings;
    }

    protected void primSetZoom(double zoom) {
        Point p1 = this.getViewport().getClientArea().getCenter();
        Point p2 = p1.getCopy();
        Point p = this.getViewport().getViewLocation();
        double prevZoom = this.zoom;
        this.zoom = zoom;
        this.pane.setScale(zoom);
        this.fireZoomChanged();
        this.getViewport().validate();
        p2.scale(zoom / prevZoom);
        Dimension dif = p2.getDifference(p1);
        p.x += dif.width;
        p.y += dif.height;
        this.setViewLocation(p);
    }

    public void removeZoomListener(ZoomListener listener) {
        this.listeners.remove(listener);
    }

    public void setUIMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public void setViewLocation(Point p) {
        this.viewport.setViewLocation(p.x, p.y);
    }

    public void setZoom(double zoom) {
        this.currentZoomContant = null;
        zoom = Math.min(this.getMaxZoom(), zoom);
        zoom = Math.max(this.getMinZoom(), zoom);
        if (this.zoom != zoom) {
            this.primSetZoom(zoom);
        }
    }

    public void setZoomAnimationStyle(int style) {
    }

    public void setZoomAsText(String zoomString) {
        this.currentZoomContant = null;
        if (zoomString.equalsIgnoreCase(FIT_HEIGHT)) {
            this.currentZoomContant = FIT_HEIGHT;
            this.primSetZoom(this.getFitHeightZoomLevel());
            this.viewport.getUpdateManager().performUpdate();
            this.viewport.setViewLocation(this.viewport.getHorizontalRangeModel().getValue(), this.viewport.getVerticalRangeModel().getMinimum());
        } else if (zoomString.equalsIgnoreCase(FIT_ALL)) {
            this.currentZoomContant = FIT_ALL;
            this.primSetZoom(this.getFitPageZoomLevel());
            this.viewport.getUpdateManager().performUpdate();
            this.viewport.setViewLocation(this.viewport.getHorizontalRangeModel().getMinimum(), this.viewport.getVerticalRangeModel().getMinimum());
        } else if (zoomString.equalsIgnoreCase(FIT_WIDTH)) {
            this.currentZoomContant = FIT_WIDTH;
            this.primSetZoom(this.getFitWidthZoomLevel());
            this.viewport.getUpdateManager().performUpdate();
            this.viewport.setViewLocation(this.viewport.getHorizontalRangeModel().getMinimum(), this.viewport.getVerticalRangeModel().getValue());
        } else {
            try {
                if (zoomString.charAt(zoomString.length() - 1) == '%') {
                    zoomString = zoomString.substring(0, zoomString.length() - 1);
                }
                double newZoom = Double.parseDouble(zoomString) / 100.0;
                this.setZoom(newZoom / this.multiplier);
            }
            catch (Exception exception) {
                Display.getCurrent().beep();
            }
        }
    }

    public void setZoomLevelContributions(List<String> contributions) {
        this.zoomLevelContributions = contributions;
    }

    public void setZoomLevels(double[] zoomLevels) {
        this.zoomLevels = zoomLevels;
    }

    public void zoomIn() {
        this.setZoom(this.getNextZoomLevel());
    }

    public void zoomTo(Rectangle rect) {
    }

    public void zoomOut() {
        this.setZoom(this.getPreviousZoomLevel());
    }
}

