/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets.internal;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class RoundedChopboxAnchor
extends ChopboxAnchor {
    private int arcRadius = 10;
    private int shift = 7;

    public RoundedChopboxAnchor(int arcRadius) {
        this.arcRadius = arcRadius;
        this.shift = arcRadius - (int)(0.707 * (double)arcRadius);
    }

    public RoundedChopboxAnchor(IFigure owner, int arcRadius) {
        super(owner);
        this.arcRadius = arcRadius;
        this.shift = arcRadius - (int)(0.707 * (double)arcRadius);
    }

    public Point getLocation(Point reference) {
        Point p = super.getLocation(reference);
        Rectangle bounds = this.getBox();
        boolean done = this.getTranslatedPoint(bounds.getTopLeft(), p, this.shift, this.shift);
        if (!done) {
            done = this.getTranslatedPoint(bounds.getTopRight(), p, -this.shift, this.shift);
        }
        if (!done) {
            done = this.getTranslatedPoint(bounds.getBottomLeft(), p, this.shift, -this.shift);
        }
        if (!done) {
            done = this.getTranslatedPoint(bounds.getBottomRight(), p, -this.shift, -this.shift);
        }
        return p;
    }

    private boolean getTranslatedPoint(Point corner, Point p, int dx, int dy) {
        int diff = (int)corner.getDistance(p);
        if (diff < this.arcRadius) {
            Point t = corner.getTranslated(dx, dy);
            p.setLocation(t.x, t.y);
            return true;
        }
        return false;
    }
}

