/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.gef4.geometry.convert.awt.AWT2Geometry;
import org.eclipse.gef4.geometry.convert.awt.Geometry2AWT;
import org.eclipse.gef4.geometry.planar.AbstractGeometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;

public class Path
extends AbstractGeometry
implements IGeometry {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final long serialVersionUID = 1L;
    private int windingRule = 1;
    private List<Segment> segments = new ArrayList<Segment>();

    public static Path add(Path pa, Path pb) {
        Area a = new Area(Geometry2AWT.toAWTPath(pa));
        Area b = new Area(Geometry2AWT.toAWTPath(pb));
        a.add(b);
        return AWT2Geometry.toPath(new Path2D.Double(a));
    }

    public static Path exclusiveOr(Path pa, Path pb) {
        Area a = new Area(Geometry2AWT.toAWTPath(pa));
        Area b = new Area(Geometry2AWT.toAWTPath(pb));
        a.exclusiveOr(b);
        return AWT2Geometry.toPath(new Path2D.Double(a));
    }

    public static Path intersect(Path pa, Path pb) {
        Area a = new Area(Geometry2AWT.toAWTPath(pa));
        Area b = new Area(Geometry2AWT.toAWTPath(pb));
        a.intersect(b);
        return AWT2Geometry.toPath(new Path2D.Double(a));
    }

    public static Path subtract(Path pa, Path pb) {
        Area a = new Area(Geometry2AWT.toAWTPath(pa));
        Area b = new Area(Geometry2AWT.toAWTPath(pb));
        a.subtract(b);
        return AWT2Geometry.toPath(new Path2D.Double(a));
    }

    public Path() {
    }

    public Path(int windingRule) {
        this.windingRule = windingRule;
    }

    public Path(int windingRule, Segment ... segments) {
        this(windingRule);
        Segment[] segmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment s = segmentArray[n2];
            this.segments.add(s.getCopy());
            ++n2;
        }
    }

    public Path(Segment ... segments) {
        this(1, segments);
    }

    public final Path close() {
        this.segments.add(new Segment(4, new Point[0]));
        return this;
    }

    @Override
    public boolean contains(Point p) {
        return Geometry2AWT.toAWTPath(this).contains(Geometry2AWT.toAWTPoint(p));
    }

    public boolean contains(Rectangle r) {
        return Geometry2AWT.toAWTPath(this).contains(Geometry2AWT.toAWTRectangle(r));
    }

    public final Path cubicTo(double control1X, double control1Y, double control2X, double control2Y, double x, double y) {
        this.segments.add(new Segment(3, new Point(control1X, control1Y), new Point(control2X, control2Y), new Point(x, y)));
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Path) {
            Object[] thisSegments = this.getSegments();
            Object[] objSegments = ((Path)obj).getSegments();
            return Arrays.equals(thisSegments, objSegments);
        }
        return false;
    }

    @Override
    public Rectangle getBounds() {
        return AWT2Geometry.toRectangle(Geometry2AWT.toAWTPath(this).getBounds2D());
    }

    @Override
    public Path getCopy() {
        return new Path(this.getWindingRule(), this.getSegments());
    }

    public Segment[] getSegments() {
        Segment[] segments = new Segment[this.segments.size()];
        int i = 0;
        while (i < segments.length) {
            segments[i] = this.segments.get(i).getCopy();
            ++i;
        }
        return segments;
    }

    @Override
    public Path getTransformed(AffineTransform t) {
        return AWT2Geometry.toPath(new Path2D.Double(Geometry2AWT.toAWTPath(this), Geometry2AWT.toAWTAffineTransform(t)));
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public final Path lineTo(double x, double y) {
        this.segments.add(new Segment(1, new Point(x, y)));
        return this;
    }

    public final Path moveTo(double x, double y) {
        this.segments.add(new Segment(0, new Point(x, y)));
        return this;
    }

    public final Path quadTo(double controlX, double controlY, double x, double y) {
        this.segments.add(new Segment(2, new Point(controlX, controlY), new Point(x, y)));
        return this;
    }

    public final Path reset() {
        this.segments.clear();
        return this;
    }

    public Path setWindingRule(int windingRule) {
        this.windingRule = windingRule;
        return this;
    }

    @Override
    public Path toPath() {
        return this.getCopy();
    }

    public boolean touches(Rectangle r) {
        return Geometry2AWT.toAWTPath(this).intersects(Geometry2AWT.toAWTRectangle(r));
    }

    public static class Segment {
        public static final int MOVE_TO = 0;
        public static final int LINE_TO = 1;
        public static final int QUAD_TO = 2;
        public static final int CUBIC_TO = 3;
        public static final int CLOSE = 4;
        private int type;
        private Point[] points;

        public Segment(int type, Point ... points) {
            switch (type) {
                case 0: {
                    if (points != null && points.length == 1) break;
                    throw new IllegalArgumentException("A Segment of type MOVE_TO has to be associate with exactly 1 point: new Segment(" + type + ", " + points + ")");
                }
                case 1: {
                    if (points != null && points.length == 1) break;
                    throw new IllegalArgumentException("A Segment of type LINE_TO has to be associate with exactly 1 point: new Segment(" + type + ", " + points + ")");
                }
                case 2: {
                    if (points != null && points.length == 2) break;
                    throw new IllegalArgumentException("A Segment of type QUAD_TO has to be associate with exactly 2 points: new Segment(" + type + ", " + points + ")");
                }
                case 3: {
                    if (points != null && points.length == 3) break;
                    throw new IllegalArgumentException("A Segment of type CUBIC_TO has to be associate with exactly 3 point: new Segment(" + type + ", " + points + ")");
                }
                case 4: {
                    if (points == null || points.length == 0) break;
                    throw new IllegalArgumentException("A Segment of type CLOSE is not to be associated with any points: new Segment(" + type + ", " + points + ")");
                }
                default: {
                    throw new IllegalArgumentException("You can only create Segments of types MOVE_TO, LINE_TO, QUAD_TO, or CUBIC_TO: new Segment(" + type + ", " + points + ")");
                }
            }
            this.type = type;
            this.points = Point.getCopy(points);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Segment) {
                Segment s = (Segment)obj;
                if (s.type == this.type && Arrays.equals(s.points, this.points)) {
                    return true;
                }
            }
            return false;
        }

        public Segment getCopy() {
            return new Segment(this.type, this.getPoints());
        }

        public Point[] getPoints() {
            return Point.getCopy(this.points);
        }

        public int getType() {
            return this.type;
        }

        public int hashCode() {
            return this.type;
        }
    }
}

