/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.layout.algorithms.NodeWrapper;
import org.eclipse.gef4.layout.interfaces.CrossingReducer;
import org.eclipse.gef4.layout.interfaces.NodeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarycentricCrossingReducer
implements CrossingReducer {
    private List<List<NodeWrapper>> layers = new ArrayList<List<NodeWrapper>>();
    private Map<NodeLayout, NodeWrapper> map = new IdentityHashMap<NodeLayout, NodeWrapper>();
    private static final int MAX_SWEEPS = 35;
    private int last;

    private void padLayers() {
        this.last = 0;
        for (List<NodeWrapper> iter : this.layers) {
            if (iter.size() <= this.last) continue;
            this.last = iter.size();
        }
        --this.last;
        for (List<NodeWrapper> iter : this.layers) {
            int i = iter.size();
            while (i <= this.last) {
                iter.add(new NodeWrapper());
                ++i;
            }
            this.updateIndex(iter);
        }
    }

    private void reduceCrossings() {
        int round = 0;
        while (round < 35) {
            int index;
            if ((round & 1) == 0) {
                index = 1;
                while (index < this.layers.size()) {
                    this.reduceCrossingsDown(this.layers.get(index));
                    ++index;
                }
            } else {
                index = this.layers.size() - 2;
                while (index >= 0) {
                    this.reduceCrossingsUp(this.layers.get(index));
                    --index;
                }
            }
            ++round;
        }
    }

    private void reduceCrossingsDown(List<NodeWrapper> layer) {
        for (NodeWrapper node : layer) {
            node.index = node.getBaryCenter(node.pred);
        }
        Collections.sort(layer, new Comparator<NodeWrapper>(){

            @Override
            public int compare(NodeWrapper node1, NodeWrapper node2) {
                return node1.index - node2.index;
            }
        });
        this.updateIndex(layer);
    }

    private void reduceCrossingsUp(List<NodeWrapper> layer) {
        for (NodeWrapper node : layer) {
            node.index = node.getBaryCenter(node.succ);
        }
        Collections.sort(layer, new Comparator<NodeWrapper>(){

            @Override
            public int compare(NodeWrapper node1, NodeWrapper node2) {
                return node1.index - node2.index;
            }
        });
        this.updateIndex(layer);
    }

    private void refineLayers() {
        int index = 1;
        while (index < this.layers.size()) {
            this.refineLayersDown(this.layers.get(index));
            ++index;
        }
        index = this.layers.size() - 2;
        while (index >= 0) {
            this.refineLayersUp(this.layers.get(index));
            --index;
        }
        index = 1;
        while (index < this.layers.size()) {
            this.refineLayersDown(this.layers.get(index));
            ++index;
        }
    }

    private void refineLayersDown(List<NodeWrapper> layer) {
        ArrayList<NodeWrapper> list = new ArrayList<NodeWrapper>(layer);
        Collections.sort(list, new Comparator<NodeWrapper>(){

            @Override
            public int compare(NodeWrapper node1, NodeWrapper node2) {
                return node2.getPriorityDown() - node1.getPriorityDown();
            }
        });
        for (NodeWrapper iter : list) {
            if (iter.isPadding()) break;
            int delta = iter.getBaryCenter(iter.pred) - iter.index;
            int i = 0;
            while (i < delta) {
                layer.add(iter.index, layer.remove(this.last));
                ++i;
            }
        }
        this.updateIndex(layer);
    }

    private void refineLayersUp(List<NodeWrapper> layer) {
        ArrayList<NodeWrapper> list = new ArrayList<NodeWrapper>(layer);
        Collections.sort(list, new Comparator<NodeWrapper>(){

            @Override
            public int compare(NodeWrapper node1, NodeWrapper node2) {
                return node2.getPriorityUp() - node1.getPriorityUp();
            }
        });
        for (NodeWrapper iter : list) {
            if (iter.isPadding()) break;
            int delta = iter.getBaryCenter(iter.succ) - iter.index;
            int i = 0;
            while (i < delta) {
                layer.add(iter.index, layer.remove(this.last));
                ++i;
            }
        }
        this.updateIndex(layer);
    }

    private void updateIndex(List<NodeWrapper> list) {
        int index = 0;
        while (index < list.size()) {
            list.get((int)index).index = index;
            this.map.put(list.get((int)index).node, list.get(index));
            ++index;
        }
    }

    @Override
    public Map<NodeLayout, NodeWrapper> crossReduction(List<List<NodeWrapper>> nodes) {
        this.layers = nodes;
        this.padLayers();
        int i = 0;
        while (i < this.layers.size()) {
            this.reduceCrossings();
            this.refineLayers();
            ++i;
        }
        this.reduceCrossings();
        return this.map;
    }
}

