/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;

public final class Edge {
    private final Map<String, Object> attrs;
    private final Node source;
    private final Node target;

    public Edge(Map<String, Object> attrs, Node source, Node target) {
        this.attrs = attrs;
        this.source = source;
        this.target = target;
    }

    public Map<String, Object> getAttrs() {
        return Collections.unmodifiableMap(this.attrs);
    }

    public Node getSource() {
        return this.source;
    }

    public Node getTarget() {
        return this.target;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Edge)) {
            return false;
        }
        Edge thatEdge = (Edge)that;
        boolean attrsEqual = this.getAttrs().equals(thatEdge.getAttrs());
        boolean sourceEqual = this.getSource().equals(thatEdge.getSource());
        boolean targetEqual = this.getTarget().equals(thatEdge.getTarget());
        return attrsEqual && sourceEqual && targetEqual;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getAttrs().hashCode();
        result = 31 * result + this.getSource().hashCode();
        result = 31 * result + this.getTarget().hashCode();
        return result;
    }

    public String toString() {
        return String.format("Edge {%s attrs} from %s to %s", this.getAttrs().size(), this.getSource(), this.getTarget());
    }

    public static class Builder {
        private Map<String, Object> attrs = new HashMap<String, Object>();
        private Node source;
        private Node target;

        public Builder(Node source, Node target) {
            this.source = source;
            this.target = target;
        }

        public Builder attr(String key, Object value) {
            this.attrs.put(key, value);
            return this;
        }

        public Builder attr(Graph.Attr.Key attr, Object value) {
            return this.attr(attr.toString(), value);
        }

        public Edge build() {
            return new Edge(this.attrs, this.source, this.target);
        }
    }
}

