/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.map.primitive;

import java.util.Collection;
import java.util.Map;

import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.predicate.primitive.LongObjectPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;

/**
 * This file was automatically generated from template file primitiveObjectMap.stg.
 *
 * @since 3.0.
 */
public interface LongObjectMap<V> extends RichIterable<V>
{
    V get(long key);

    V getIfAbsent(long key, Function0<? extends V> ifAbsent);

    boolean containsKey(long key);

    boolean containsValue(Object value);

    LongObjectMap<V> tap(Procedure<? super V> procedure);

    void forEachValue(Procedure<? super V> procedure);

    void forEachKey(LongProcedure procedure);

    void forEachKeyValue(LongObjectProcedure<? super V> procedure);

    LongObjectMap<V> select(LongObjectPredicate<? super V> predicate);

    LongObjectMap<V> reject(LongObjectPredicate<? super V> predicate);

    /**
     * Follows the same general contract as {@link Map#equals(Object)}.
     */
    @Override
    boolean equals(Object o);

    /**
     * Follows the same general contract as {@link Map#hashCode()}.
     */
    @Override
    int hashCode();

    /**
     * Returns a string representation of this LongObjectMap. The string representation consists of a list of the
     * map's key-value pairs in the order they are returned by its iterator. The key and value in each key-value pair are separated
     * by a colon (<tt>":"</tt>) and each pair is enclosed in square brackets (<tt>"[]"</tt>). Adjacent key-value pairs
     * are separated by the characters <tt>", "</tt> (comma and space). Keys and values are converted to strings as by
     * String#valueOf().
     *
     * @return a string representation of this LongObjectMap
     */
    String toString();

    ImmutableLongObjectMap<V> toImmutable();

    MutableLongSet keySet();

    Collection<V> values();

    /**
     * @since 5.0
     */
    LazyLongIterable keysView();

    /**
     * @since 5.0
     */
    RichIterable<LongObjectPair<V>> keyValuesView();
}
