/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.CategoryParser;
import org.eclipse.equinox.internal.p2.updatesite.DefaultSiteParser;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSite {
    private static final String VERSION_SEPARATOR = "_";
    private static final String JAR_EXTENSION = ".jar";
    private static final String FEATURE_DIR = "features/";
    private static final String PLUGIN_DIR = "plugins/";
    private static final String FEATURE_TEMP_FILE = "feature";
    private static final String SITE_FILE = "site.xml";
    private static final String PROTOCOL_FILE = "file";
    private static final int RETRY_COUNT = 2;
    private static final String DOT_XML = ".xml";
    private static final String SITE = "site";
    private String checksum;
    private URI location;
    private URI rootLocation;
    private SiteModel site;
    private static Map<String, SoftReference<UpdateSite>> siteCache = new HashMap<String, SoftReference<UpdateSite>>();
    private static Map<String, SoftReference<UpdateSite>> categoryCache = new HashMap<String, SoftReference<UpdateSite>>();
    private Map<String, Feature> featureCache = new HashMap<String, Feature>();
    private Transport transport;

    private static URI getSiteURI(URI baseLocation) {
        String segment = URIUtil.lastSegment((URI)baseLocation);
        if (UpdateSite.constainsUpdateSiteFileName(segment)) {
            return baseLocation;
        }
        return URIUtil.append((URI)baseLocation, (String)SITE_FILE);
    }

    private static boolean constainsUpdateSiteFileName(String segment) {
        return segment != null && segment.endsWith(DOT_XML) && segment.indexOf(SITE) != -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized UpdateSite loadCategoryFile(URI location, Transport transport, IProgressMonitor monitor) throws ProvisionException {
        UpdateSite updateSite;
        if (location == null) {
            return null;
        }
        UpdateSite result = null;
        if (!PROTOCOL_FILE.equals(location.getScheme()) && categoryCache.containsKey(location.toString())) {
            result = categoryCache.get(location.toString()).get();
            if (result != null) {
                return result;
            }
            categoryCache.remove(location.toString());
        }
        InputStream input = null;
        File siteFile = UpdateSite.loadActualSiteFile(location, location, transport, monitor);
        try {
            try {
                CategoryParser siteParser = new CategoryParser(location);
                CRC32 checksum = new CRC32();
                input = new CheckedInputStream(new BufferedInputStream(new FileInputStream(siteFile)), checksum);
                SiteModel siteModel = siteParser.parse(input);
                String checksumString = Long.toString(checksum.getValue());
                result = new UpdateSite(siteModel, location, transport, checksumString);
                if (!PROTOCOL_FILE.equals(location.getScheme())) {
                    categoryCache.put(location.toString(), new SoftReference<UpdateSite>(result));
                }
                updateSite = result;
                Object var10_15 = null;
            }
            catch (SAXException e) {
                String msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
                throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1002, msg, (Throwable)e));
            }
            catch (IOException e) {
                String msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
                throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1002, msg, (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
            if (PROTOCOL_FILE.equals(location.getScheme())) throw throwable;
            siteFile.delete();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (input != null) {
            input.close();
        }
        if (PROTOCOL_FILE.equals(location.getScheme())) return updateSite;
        siteFile.delete();
        return updateSite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized UpdateSite load(URI location, Transport transport, IProgressMonitor monitor) throws ProvisionException {
        UpdateSite updateSite;
        if (location == null) {
            return null;
        }
        UpdateSite result = null;
        if (!PROTOCOL_FILE.equals(location.getScheme()) && siteCache.containsKey(location.toString())) {
            result = siteCache.get(location.toString()).get();
            if (result != null) {
                return result;
            }
            siteCache.remove(location.toString());
        }
        InputStream input = null;
        File siteFile = UpdateSite.loadActualSiteFile(location, UpdateSite.getSiteURI(location), transport, monitor);
        try {
            try {
                DefaultSiteParser siteParser = new DefaultSiteParser(location);
                CRC32 checksum = new CRC32();
                input = new CheckedInputStream(new BufferedInputStream(new FileInputStream(siteFile)), checksum);
                SiteModel siteModel = siteParser.parse(input);
                String checksumString = Long.toString(checksum.getValue());
                result = new UpdateSite(siteModel, UpdateSite.getSiteURI(location), transport, checksumString);
                if (!PROTOCOL_FILE.equals(location.getScheme())) {
                    siteCache.put(location.toString(), new SoftReference<UpdateSite>(result));
                }
                updateSite = result;
                Object var10_15 = null;
            }
            catch (SAXException e) {
                String msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
                throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1002, msg, (Throwable)e));
            }
            catch (IOException e) {
                String msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
                throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1002, msg, (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
            if (PROTOCOL_FILE.equals(location.getScheme())) throw throwable;
            siteFile.delete();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (input != null) {
            input.close();
        }
        if (PROTOCOL_FILE.equals(location.getScheme())) return updateSite;
        siteFile.delete();
        return updateSite;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File loadActualSiteFile(URI location, URI actualLocation, Transport transport, IProgressMonitor monitor) throws ProvisionException {
        block23: {
            submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
            try {
                siteFile = null;
                transferResult = null;
                deleteSiteFile = false;
                try {
                    block22: {
                        if ("file".equals(actualLocation.getScheme())) {
                            siteFile = URIUtil.toFile((URI)actualLocation);
                            if (siteFile.exists()) {
                                transferResult = Status.OK_STATUS;
                                break block22;
                            } else {
                                msg = NLS.bind((String)Messages.ErrorReadingSite, (Object)location);
                                transferResult = new Status(4, Activator.ID, 1200, msg, (Throwable)new FileNotFoundException(siteFile.getAbsolutePath()));
                            }
                        } else {
                            deleteSiteFile = true;
                            destination = null;
                            try {
                                siteFile = File.createTempFile("site", ".xml");
                                destination = new BufferedOutputStream(new FileOutputStream(siteFile));
                            }
                            catch (IOException e) {
                                throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1, "Can not create tempfile for site.xml", (Throwable)e));
                            }
                            try {
                                transferResult = transport.download(actualLocation, (OutputStream)destination, (IProgressMonitor)submonitor.newChild(999));
                            }
                            catch (Throwable var10_12) {
                                var9_10 = null;
                                try {
                                    destination.close();
                                    throw var10_12;
                                }
                                catch (IOException e) {
                                    throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1, "Failing to close tempfile for site.xml", (Throwable)e));
                                }
                            }
                            {
                                var9_11 = null;
                            }
                            ** try [egrp 4[TRYBLOCK] [3 : 187->195)] { 
lbl36:
                            // 1 sources

                            destination.close();
                        }
                        break block22;
lbl38:
                        // 1 sources

                        catch (IOException e) {
                            throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1, "Failing to close tempfile for site.xml", (Throwable)e));
                        }
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (transferResult.isOK()) {
                        deleteSiteFile = false;
                        var14_15 = siteFile;
                        var12_16 = null;
                        if (deleteSiteFile && siteFile != null) {
                            siteFile.delete();
                        }
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var13_20) {
                    var12_17 = null;
                    if (deleteSiteFile == false) throw var13_20;
                    if (siteFile == null) throw var13_20;
                    siteFile.delete();
                    throw var13_20;
                }
                var15_18 = null;
                if (monitor == null) return var14_15;
                break block23;
lbl-1000:
                // 1 sources

                {
                    ms = null;
                    if (transferResult.getException() instanceof FileNotFoundException) {
                        ms = new MultiStatus(Activator.ID, 1000, new IStatus[]{transferResult}, NLS.bind((String)Messages.ErrorReadingSite, (Object)location), null);
                        throw new ProvisionException(ms);
                    }
                    ms = transferResult;
                    throw new ProvisionException(ms);
                }
            }
            catch (Throwable var16_21) {
                var15_19 = null;
                if (monitor == null) throw var16_21;
                monitor.done();
                throw var16_21;
            }
        }
        monitor.done();
        return var14_15;
    }

    /*
     * Exception decompiling
     */
    private Feature parseFeature(FeatureParser featureParser, URI featureURI, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [1 : 147->150)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private UpdateSite(SiteModel site, URI location, Transport transport, String checksum) {
        this.site = site;
        this.location = location;
        this.checksum = checksum;
        this.rootLocation = this.getRootLocation();
        this.transport = transport;
    }

    private URI getRootLocation() {
        String locationString = this.location.toString();
        int slashIndex = locationString.lastIndexOf(47);
        if (slashIndex == -1 || slashIndex == locationString.length() - 1) {
            return this.location;
        }
        return URI.create(locationString.substring(0, slashIndex + 1));
    }

    private URI getArchiveURI(URI base, String identifier) {
        URLEntry[] archives = this.site.getArchives();
        int i = 0;
        while (archives != null && i < archives.length) {
            URLEntry entry = archives[i];
            if (identifier.equals(entry.getAnnotation())) {
                return this.internalGetURI(base, entry.getURL());
            }
            ++i;
        }
        return null;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public URI getSiteFeatureURI(SiteFeature siteFeature) {
        URL url = siteFeature.getURL();
        try {
            if (url != null) {
                return URIUtil.toURI((URL)url);
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        URI base = this.getBaseURI();
        String featureURIString = siteFeature.getURLString();
        return this.internalGetURI(base, featureURIString);
    }

    public URI getFeatureURI(String id, String version) {
        SiteFeature[] entries = this.site.getFeatures();
        int i = 0;
        while (i < entries.length) {
            if (id.equals(entries[i].getFeatureIdentifier()) && version.equals(entries[i].getFeatureVersion())) {
                return this.getSiteFeatureURI(entries[i]);
            }
            ++i;
        }
        URI base = this.getBaseURI();
        URI url = this.getArchiveURI(base, new StringBuffer(FEATURE_DIR).append(id).append(VERSION_SEPARATOR).append(version).append(JAR_EXTENSION).toString());
        if (url != null) {
            return url;
        }
        return URIUtil.append((URI)base, (String)new StringBuffer(FEATURE_DIR).append(id).append(VERSION_SEPARATOR).append(version).append(JAR_EXTENSION).toString());
    }

    public URI getLocation() {
        return this.location;
    }

    public String getMirrorsURI() {
        String mirrors = this.site.getMirrorsURI();
        if (mirrors == null) {
            return null;
        }
        int index = mirrors.indexOf(SITE_FILE);
        if (index != -1) {
            mirrors = new StringBuffer(String.valueOf(mirrors.substring(0, index))).append(mirrors.substring(index + SITE_FILE.length())).toString();
        }
        return mirrors;
    }

    public URI getPluginURI(FeatureEntry plugin) {
        String path;
        URI base = this.getBaseURI();
        URI url = this.getArchiveURI(base, path = new StringBuffer(PLUGIN_DIR).append(plugin.getId()).append(VERSION_SEPARATOR).append(plugin.getVersion()).append(JAR_EXTENSION).toString());
        if (url != null) {
            return url;
        }
        return URIUtil.append((URI)base, (String)path);
    }

    private URI getBaseURI() {
        URI base = null;
        String siteURIString = this.site.getLocationURIString();
        if (siteURIString != null) {
            if (!siteURIString.endsWith("/")) {
                siteURIString = new StringBuffer(String.valueOf(siteURIString)).append("/").toString();
            }
            base = this.internalGetURI(this.rootLocation, siteURIString);
        }
        if (base == null) {
            base = this.rootLocation;
        }
        return base;
    }

    public SiteModel getSite() {
        return this.site;
    }

    private URI internalGetURI(URI base, String trailing) {
        if (trailing == null) {
            return null;
        }
        return URIUtil.makeAbsolute((URI)URI.create(trailing), (URI)base);
    }

    public synchronized Feature[] loadFeatures(IProgressMonitor monitor) throws ProvisionException {
        if (!this.featureCache.isEmpty()) {
            return this.featureCache.values().toArray(new Feature[this.featureCache.size()]);
        }
        Feature[] result = this.loadFeaturesFromDigest(monitor);
        return result == null ? this.loadFeaturesFromSite(monitor) : result;
    }

    /*
     * Exception decompiling
     */
    private Feature[] loadFeaturesFromDigest(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [1 : 144->147)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URI getDigestURI() {
        URI digestBase = null;
        String digestURIString = this.site.getDigestURIString();
        if (digestURIString != null) {
            if (!digestURIString.endsWith("/")) {
                digestURIString = new StringBuffer(String.valueOf(digestURIString)).append("/").toString();
            }
            digestBase = this.internalGetURI(this.rootLocation, digestURIString);
        }
        if (digestBase == null) {
            digestBase = this.rootLocation;
        }
        return URIUtil.append((URI)digestBase, (String)"digest.zip");
    }

    private Feature[] loadFeaturesFromSite(IProgressMonitor monitor) throws ProvisionException {
        SiteFeature[] siteFeatures = this.site.getFeatures();
        FeatureParser featureParser = new FeatureParser();
        HashMap<String, Feature> tmpFeatureCache = new HashMap<String, Feature>(siteFeatures.length);
        int i = 0;
        while (i < siteFeatures.length) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            SiteFeature siteFeature = siteFeatures[i];
            String key = null;
            if (siteFeature.getFeatureIdentifier() == null || siteFeature.getFeatureVersion() == null || !tmpFeatureCache.containsKey(key = new StringBuffer(String.valueOf(siteFeature.getFeatureIdentifier())).append(VERSION_SEPARATOR).append(siteFeature.getFeatureVersion()).toString())) {
                URI featureURI = this.getSiteFeatureURI(siteFeature);
                Feature feature = this.parseFeature(featureParser, featureURI, (IProgressMonitor)new NullProgressMonitor());
                if (feature == null) {
                    LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.ErrorReadingFeature, (Object)featureURI)));
                } else {
                    if (key == null) {
                        siteFeature.setFeatureIdentifier(feature.getId());
                        siteFeature.setFeatureVersion(feature.getVersion());
                        key = new StringBuffer(String.valueOf(siteFeature.getFeatureIdentifier())).append(VERSION_SEPARATOR).append(siteFeature.getFeatureVersion()).toString();
                    }
                    tmpFeatureCache.put(key, feature);
                    this.loadIncludedFeatures(feature, featureParser, tmpFeatureCache, monitor);
                }
            }
            ++i;
        }
        this.featureCache = tmpFeatureCache;
        return this.featureCache.values().toArray(new Feature[this.featureCache.size()]);
    }

    private void loadIncludedFeatures(Feature feature, FeatureParser featureParser, Map<String, Feature> features, IProgressMonitor monitor) throws ProvisionException {
        FeatureEntry[] featureEntries = feature.getEntries();
        int i = 0;
        while (i < featureEntries.length) {
            String key;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            FeatureEntry entry = featureEntries[i];
            if (!(entry.isRequires() || entry.isPlugin() || features.containsKey(key = new StringBuffer(String.valueOf(entry.getId())).append(VERSION_SEPARATOR).append(entry.getVersion()).toString()))) {
                URI includedFeatureURI = this.getFeatureURI(entry.getId(), entry.getVersion());
                Feature includedFeature = this.parseFeature(featureParser, includedFeatureURI, monitor);
                if (includedFeature == null) {
                    LogHelper.log((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.ErrorReadingFeature, (Object)includedFeatureURI)));
                } else {
                    features.put(key, includedFeature);
                    this.loadIncludedFeatures(includedFeature, featureParser, features, monitor);
                }
            }
            ++i;
        }
    }
}

