/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policy {
    public static final int RESTART_POLICY_FORCE = 1;
    public static final int RESTART_POLICY_FORCE_APPLY = 2;
    public static final int RESTART_POLICY_PROMPT = 3;
    public static final int RESTART_POLICY_PROMPT_RESTART_OR_APPLY = 4;
    public static final int UPDATE_STYLE_MULTIPLE_IUS = 1;
    public static final int UPDATE_STYLE_SINGLE_IUS = 2;
    private IQuery<IInstallableUnit> visibleAvailableIUQuery = QueryUtil.createIUGroupQuery();
    private IQuery<IInstallableUnit> visibleInstalledIUQuery = new UserVisibleRootQuery();
    private boolean groupByCategory = true;
    private boolean allowDrilldown = true;
    private boolean repositoriesVisible = true;
    private boolean showLatestVersionsOnly = true;
    private int restartPolicy = 4;
    private String repoPrefPageId;
    private String repoPrefPageName;
    private boolean filterOnEnv = false;
    private int updateWizardStyle = 1;
    private Point wizardDetailsPreferredSize = null;

    public boolean continueWorkingWithOperation(ProfileChangeOperation operation, Shell shell) {
        Assert.isTrue((operation.getResolutionResult() != null ? 1 : 0) != 0);
        IStatus status = operation.getResolutionResult();
        if (status.getSeverity() == 8) {
            return false;
        }
        if (status.getCode() == 10000) {
            ProvUI.reportStatus(status, 4);
            return false;
        }
        if (operation.getProvisioningPlan() == null && !status.isOK()) {
            StatusManager.getManager().handle(status, 3);
            return false;
        }
        return true;
    }

    public IStatus getNoProfileChosenStatus() {
        return null;
    }

    public IQuery<IInstallableUnit> getVisibleAvailableIUQuery() {
        return this.visibleAvailableIUQuery;
    }

    public void setVisibleAvailableIUQuery(IQuery<IInstallableUnit> query) {
        this.visibleAvailableIUQuery = query;
    }

    public IQuery<IInstallableUnit> getVisibleInstalledIUQuery() {
        return this.visibleInstalledIUQuery;
    }

    public void setVisibleInstalledIUQuery(IQuery<IInstallableUnit> query) {
        this.visibleInstalledIUQuery = query;
    }

    public int getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(int restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public boolean getRepositoriesVisible() {
        return this.repositoriesVisible;
    }

    public void setRepositoriesVisible(boolean visible) {
        this.repositoriesVisible = visible;
    }

    public boolean getShowLatestVersionsOnly() {
        return this.showLatestVersionsOnly;
    }

    public void setShowLatestVersionsOnly(boolean showLatest) {
        this.showLatestVersionsOnly = showLatest;
    }

    public boolean getShowDrilldownRequirements() {
        return this.allowDrilldown;
    }

    public void setShowDrilldownRequirements(boolean drilldown) {
        this.allowDrilldown = drilldown;
    }

    public boolean getFilterOnEnv() {
        return this.filterOnEnv;
    }

    public void setFilterOnEnv(boolean filterOnEnv) {
        this.filterOnEnv = filterOnEnv;
    }

    public boolean getGroupByCategory() {
        return this.groupByCategory;
    }

    public void setGroupByCategory(boolean group) {
        this.groupByCategory = group;
    }

    public String getRepositoryPreferencePageId() {
        return this.repoPrefPageId;
    }

    public void setRepositoryPreferencePageId(String id) {
        this.repoPrefPageId = id;
    }

    public String getRepositoryPreferencePageName() {
        return this.repoPrefPageName;
    }

    public void setRepositoryPreferencePageName(String name) {
        this.repoPrefPageName = name;
    }

    public int getUpdateWizardStyle() {
        return this.updateWizardStyle;
    }

    public void setUpdateWizardStyle(int updateWizardStyle) {
        this.updateWizardStyle = updateWizardStyle;
    }

    public Point getUpdateDetailsPreferredSize() {
        return this.wizardDetailsPreferredSize;
    }

    public void setUpdateDetailsPreferredSize(Point preferredSize) {
        this.wizardDetailsPreferredSize = preferredSize;
    }
}

