/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateManagerCompatibility {
    private static final String ECLIPSE_INSTALL_HANDLER_PROP = "org.eclipse.update.installHandler";
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    private static void parse(String fileName, Vector<MetadataRepositoryElement> bookmarks) {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        try {
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            Document doc = parser.parse(file);
            Element root = doc.getDocumentElement();
            UpdateManagerCompatibility.processRoot(root, bookmarks);
        }
        catch (ParserConfigurationException e) {
            UpdateManagerCompatibility.logFail(e);
        }
        catch (SAXException e) {
            UpdateManagerCompatibility.logFail(e);
        }
        catch (IOException e) {
            UpdateManagerCompatibility.logFail(e);
        }
    }

    private static MetadataRepositoryElement[] getSites(Vector<MetadataRepositoryElement> bookmarks) {
        return bookmarks.toArray(new MetadataRepositoryElement[bookmarks.size()]);
    }

    private static void processRoot(Node root, Vector<MetadataRepositoryElement> bookmarks) {
        if (root.getNodeName().equals("bookmarks")) {
            NodeList children = root.getChildNodes();
            UpdateManagerCompatibility.processChildren(children, bookmarks);
        }
    }

    private static void processChildren(NodeList children, Vector<MetadataRepositoryElement> bookmarks) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("site")) {
                    UpdateManagerCompatibility.createSite(child, bookmarks);
                } else if (child.getNodeName().equals("folder")) {
                    UpdateManagerCompatibility.createFolder(child, bookmarks);
                }
            }
            ++i;
        }
    }

    private static void createSite(Node child, Vector<MetadataRepositoryElement> bookmarks) {
        URI uri = null;
        try {
            uri = URIUtil.fromString((String)UpdateManagerCompatibility.getAttribute(child, "url"));
        }
        catch (URISyntaxException e) {
            UpdateManagerCompatibility.logFail(e);
            return;
        }
        String sel = UpdateManagerCompatibility.getAttribute(child, "selected");
        boolean selected = sel != null && sel.equals("true");
        MetadataRepositoryElement element = new MetadataRepositoryElement(null, uri, selected);
        String nickname = UpdateManagerCompatibility.getAttribute(child, "name");
        if (nickname != null && nickname.length() > 0) {
            element.setNickname(nickname);
        }
        bookmarks.add(element);
    }

    private static void createFolder(Node child, Vector<MetadataRepositoryElement> bookmarks) {
        if (child.hasChildNodes()) {
            UpdateManagerCompatibility.processChildren(child.getChildNodes(), bookmarks);
        }
    }

    private static String getAttribute(Node node, String name) {
        NamedNodeMap atts = node.getAttributes();
        Node att = atts.getNamedItem(name);
        if (att != null) {
            return att.getNodeValue();
        }
        return "";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void store(String fileName, Vector<MetadataRepositoryElement> bookmarks) {
        block17: {
            block16: {
                fos = null;
                osw = null;
                writer = null;
                try {
                    try {
                        fos = new FileOutputStream(fileName);
                        osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
                        writer = new PrintWriter(osw);
                        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        writer.println("<bookmarks>");
                        i = 0;
                        while (i < bookmarks.size()) {
                            obj = bookmarks.get(i);
                            UpdateManagerCompatibility.writeObject("   ", obj, writer);
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        UpdateManagerCompatibility.logFail(e);
                    }
                }
                catch (Throwable var8_8) {
                    var7_9 = null;
                    if (writer != null) {
                        writer.println("</bookmarks>");
                        writer.flush();
                        writer.close();
                    }
                    try {
                        if (osw != null) {
                            osw.close();
                        }
                    }
                    catch (IOException e1) {
                        UpdateManagerCompatibility.logFail(e1);
                    }
                    try {
                        if (fos == null) throw var8_8;
                        fos.close();
                        throw var8_8;
                    }
                    catch (IOException e2) {
                        UpdateManagerCompatibility.logFail(e2);
                    }
                    throw var8_8;
                }
                {
                    var7_10 = null;
                    if (writer == null) break block16;
                    writer.println("</bookmarks>");
                    writer.flush();
                    writer.close();
                }
            }
            ** try [egrp 2[TRYBLOCK] [3 : 132->143)] { 
lbl49:
            // 1 sources

            if (osw != null) {
                osw.close();
            }
            break block17;
lbl52:
            // 1 sources

            catch (IOException e1) {
                UpdateManagerCompatibility.logFail(e1);
            }
        }
        try {}
        catch (IOException e2) {
            UpdateManagerCompatibility.logFail(e2);
            return;
        }
        if (fos == null) return;
        fos.close();
    }

    private static void writeObject(String indent, Object obj, PrintWriter writer) {
        if (obj instanceof MetadataRepositoryElement) {
            MetadataRepositoryElement element = (MetadataRepositoryElement)obj;
            String sel = element.isEnabled() ? "true" : "false";
            String name = element.getName();
            writer.print(new StringBuffer(String.valueOf(indent)).append("<site url=\"").append(URIUtil.toUnencodedString((URI)element.getLocation())).append("\" selected=\"").append(sel).append("\" name=\"").append(UpdateManagerCompatibility.getWritableXMLString(name)).append("\"").toString());
            writer.println("/>");
        }
    }

    public static IStatus getInstallHandlerStatus(IProvisioningPlan plan) {
        IQueryResult result = plan.getAdditions().query(QueryUtil.createIUAnyQuery(), null);
        for (IInstallableUnit iu : result) {
            if (iu == null || iu.getProperty(ECLIPSE_INSTALL_HANDLER_PROP) == null) continue;
            return new Status(4, "org.eclipse.equinox.p2.ui", NLS.bind((String)ProvUIMessages.UpdateManagerCompatibility_ItemRequiresUpdateManager, (Object)iu.getId()));
        }
        return Status.OK_STATUS;
    }

    public static MetadataRepositoryElement[] importSites(Shell shell) {
        FileDialog dialog = new FileDialog(shell);
        dialog.setText(ProvUIMessages.UpdateManagerCompatibility_ImportSitesTitle);
        dialog.setFilterExtensions(new String[]{"*.xml", "*"});
        MetadataRepositoryElement[] sites = null;
        String bookmarksFile = dialog.open();
        while (bookmarksFile != null && sites == null) {
            File file = new File(bookmarksFile);
            sites = UpdateManagerCompatibility.readBookmarkFile(file);
            if (sites != null && sites.length != 0) continue;
            MessageDialog.openInformation((Shell)shell, (String)ProvUIMessages.UpdateManagerCompatibility_InvalidSitesTitle, (String)ProvUIMessages.UpdateManagerCompatibility_InvalidSiteFileMessage);
            bookmarksFile = dialog.open();
        }
        return sites == null ? new MetadataRepositoryElement[]{} : sites;
    }

    public static MetadataRepositoryElement[] readBookmarkFile(File file) {
        Vector<MetadataRepositoryElement> bookmarks = new Vector<MetadataRepositoryElement>();
        UpdateManagerCompatibility.parse(file.getAbsolutePath(), bookmarks);
        return UpdateManagerCompatibility.getSites(bookmarks);
    }

    public static void writeBookmarkFile(String filename, MetadataRepositoryElement[] sites) {
        Vector<MetadataRepositoryElement> bookmarks = new Vector<MetadataRepositoryElement>(sites.length);
        int i = 0;
        while (i < sites.length) {
            bookmarks.add(sites[i]);
            ++i;
        }
        UpdateManagerCompatibility.store(filename, bookmarks);
    }

    public static void exportSites(Shell shell, MetadataRepositoryElement[] sites) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setText(ProvUIMessages.UpdateManagerCompatibility_ExportSitesTitle);
        dialog.setFileName("bookmarks.xml");
        dialog.setFilterExtensions(new String[]{"*.xml", "*"});
        dialog.setOverwrite(true);
        String bookmarksFile = dialog.open();
        if (bookmarksFile == null) {
            return;
        }
        UpdateManagerCompatibility.writeBookmarkFile(bookmarksFile, sites);
    }

    public static void openInstaller() {
        ProvUI.openUpdateManagerInstaller(null);
    }

    public static void openConfigurationManager() {
        ProvUI.openUpdateManagerConfigurationManager(null);
    }

    private static void logFail(Throwable t) {
        Status failStatus = new Status(4, "org.eclipse.equinox.p2.ui", t.getLocalizedMessage(), t);
        ProvUI.reportStatus((IStatus)failStatus, 1);
    }

    private static String getWritableXMLString(String value) {
        StringBuffer buf = new StringBuffer();
        if (value == null) {
            return buf.toString();
        }
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

