/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositoryNameAndLocationDialog;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ColocatedRepositoryTracker
extends RepositoryTracker {
    ProvisioningUI ui;
    String parsedNickname;
    URI parsedLocation;

    public ColocatedRepositoryTracker(ProvisioningUI ui) {
        this.ui = ui;
        this.setArtifactRepositoryFlags(2);
        this.setMetadataRepositoryFlags(2);
    }

    public URI[] getKnownRepositories(ProvisioningSession session) {
        return this.getMetadataRepositoryManager().getKnownRepositories(this.getMetadataRepositoryFlags());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addRepository(URI repoLocation, String nickname, ProvisioningSession session) {
        this.ui.signalRepositoryOperationStart();
        try {
            this.getMetadataRepositoryManager().addRepository(repoLocation);
            this.getArtifactRepositoryManager().addRepository(repoLocation);
            if (nickname != null) {
                this.getMetadataRepositoryManager().setRepositoryProperty(repoLocation, "p2.nickname", nickname);
                this.getArtifactRepositoryManager().setRepositoryProperty(repoLocation, "p2.nickname", nickname);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.ui.signalRepositoryOperationComplete(new RepositoryEvent(repoLocation, 0, 0, true), true);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.ui.signalRepositoryOperationComplete(new RepositoryEvent(repoLocation, 0, 0, true), true);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeRepositories(URI[] repoLocations, ProvisioningSession session) {
        this.ui.signalRepositoryOperationStart();
        try {
            int i = 0;
            while (i < repoLocations.length) {
                this.getMetadataRepositoryManager().removeRepository(repoLocations[i]);
                this.getArtifactRepositoryManager().removeRepository(repoLocations[i]);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.ui.signalRepositoryOperationComplete(null, true);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.ui.signalRepositoryOperationComplete(null, true);
            return;
        }
    }

    public void refreshRepositories(URI[] locations, ProvisioningSession session, IProgressMonitor monitor) {
        this.ui.signalRepositoryOperationStart();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(locations.length * 100));
        int i = 0;
        while (i < locations.length) {
            try {
                this.getArtifactRepositoryManager().refreshRepository(locations[i], (IProgressMonitor)mon.newChild(50));
                this.getMetadataRepositoryManager().refreshRepository(locations[i], (IProgressMonitor)mon.newChild(50));
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        this.ui.signalRepositoryOperationComplete(null, true);
    }

    public void reportLoadFailure(final URI location, ProvisionException e) {
        int code = e.getStatus().getCode();
        if (!this.ui.getPolicy().getRepositoriesVisible()) {
            super.reportLoadFailure(location, e);
            return;
        }
        if (code == 1000 || code == 1006) {
            if (!this.hasNotFoundStatusBeenReported(location)) {
                this.addNotFound(location);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        if (workbench.isClosing()) {
                            return;
                        }
                        Shell shell = ProvUI.getDefaultParentShell();
                        if (!MessageDialog.openQuestion((Shell)shell, (String)ProvUIMessages.ColocatedRepositoryTracker_SiteNotFoundTitle, (String)NLS.bind((String)ProvUIMessages.ColocatedRepositoryTracker_PromptForSiteLocationEdit, (Object)URIUtil.toUnencodedString((URI)location)))) return;
                        RepositoryNameAndLocationDialog dialog = new RepositoryNameAndLocationDialog(shell, ColocatedRepositoryTracker.this.ui){

                            protected String getInitialLocationText() {
                                return URIUtil.toUnencodedString((URI)location);
                            }

                            protected String getInitialNameText() {
                                String nickname = ColocatedRepositoryTracker.this.getMetadataRepositoryManager().getRepositoryProperty(location, "p2.nickname");
                                return nickname == null ? "" : nickname;
                            }
                        };
                        int ret = dialog.open();
                        if (ret != 0) return;
                        URI correctedLocation = dialog.getLocation();
                        if (correctedLocation == null) return;
                        ColocatedRepositoryTracker.this.ui.signalRepositoryOperationStart();
                        try {
                            ColocatedRepositoryTracker.this.removeRepositories(new URI[]{location}, ColocatedRepositoryTracker.this.ui.getSession());
                            ColocatedRepositoryTracker.this.addRepository(correctedLocation, dialog.getName(), ColocatedRepositoryTracker.this.ui.getSession());
                        }
                        catch (Throwable throwable) {
                            Object var6_7 = null;
                            ColocatedRepositoryTracker.this.ui.signalRepositoryOperationComplete(null, true);
                            throw throwable;
                        }
                        {
                            Object var6_8 = null;
                            ColocatedRepositoryTracker.this.ui.signalRepositoryOperationComplete(null, true);
                            return;
                        }
                    }
                });
            }
        } else {
            ProvUI.handleException(e, null, 3);
        }
    }

    IMetadataRepositoryManager getMetadataRepositoryManager() {
        return ProvUI.getMetadataRepositoryManager(this.ui.getSession());
    }

    IArtifactRepositoryManager getArtifactRepositoryManager() {
        return ProvUI.getArtifactRepositoryManager(this.ui.getSession());
    }

    public URI locationFromString(String locationString) {
        URI uri = super.locationFromString(locationString);
        if (uri != null) {
            return uri;
        }
        int start = 0;
        int index = 0;
        String pattern = ProvUIMessages.RepositorySelectionGroup_NameAndLocationSeparator;
        while (index >= 0) {
            String locationSubset;
            index = locationString.indexOf(pattern, start);
            if (index < 0 || (uri = super.locationFromString(locationSubset = locationString.substring(start = index + pattern.length()))) == null) continue;
            this.parsedLocation = uri;
            this.parsedNickname = locationString.substring(0, index);
            return uri;
        }
        return null;
    }

    public String getParsedNickname(URI location) {
        if (this.parsedNickname == null || this.parsedLocation == null) {
            return null;
        }
        if (location.toString().equals(this.parsedLocation.toString())) {
            return this.parsedNickname;
        }
        return null;
    }

    protected boolean contains(URI location, ProvisioningSession session) {
        return ProvUI.getMetadataRepositoryManager(session).contains(location);
    }
}

