/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal.wizard;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.AbstractPage;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractImportPage
extends AbstractPage {
    IProfile profile = null;
    private final ProvisioningOperationWizard wizard;
    private final ProvisioningUI ui;

    public AbstractImportPage(String pageName, ProvisioningUI ui, ProvisioningOperationWizard wizard) {
        super(pageName);
        this.wizard = wizard;
        this.ui = ui;
        this.profile = this.getSelfProfile();
    }

    protected ProvisioningOperationWizard getProvisioningWizard() {
        return this.wizard;
    }

    protected ProvisioningUI getProvisioningUI() {
        return this.ui;
    }

    protected void createInstallationTable(Composite parent) {
        super.createInstallationTable(parent);
        this.viewer.getTree().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    if (AbstractImportPage.this.hasInstalled((IInstallableUnit)ProvUI.getAdapter((Object)event.item.getData(), clazz))) {
                        AbstractImportPage.this.viewer.getTree().setRedraw(false);
                        ((TreeItem)event.item).setChecked(false);
                        AbstractImportPage.this.viewer.getTree().setRedraw(true);
                    }
                }
                AbstractImportPage.this.updatePageCompletion();
            }
        });
    }

    public boolean hasInstalled(IInstallableUnit iu) {
        IQueryResult results = this.profile.query(QueryUtil.createIUQuery((String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, null, false)), null);
        return !results.isEmpty();
    }

    public String getIUNameWithDetail(IInstallableUnit iu) {
        IQueryResult results = this.profile.query(QueryUtil.createIUQuery((String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, null, false)), null);
        String text = iu.getProperty("org.eclipse.equinox.p2.name", null);
        if (!results.isEmpty()) {
            boolean hasHigherVersion = false;
            boolean hasEqualVersion = false;
            Iterator iterator = results.toSet().iterator();
            while (iterator.hasNext()) {
                IInstallableUnit installedIU = (IInstallableUnit)iterator.next();
                int compareValue = installedIU.getVersion().compareTo((Object)iu.getVersion());
                if (compareValue > 0) {
                    hasHigherVersion = true;
                    break;
                }
                if (compareValue != 0) continue;
                hasEqualVersion = true;
            }
            if (hasHigherVersion) {
                return NLS.bind((String)Messages.AbstractImportPage_HigherVersionInstalled, (Object)text);
            }
            if (hasEqualVersion) {
                return NLS.bind((String)Messages.AbstractImportPage_SameVersionInstalled, (Object)text);
            }
        }
        return text;
    }

    protected ICheckStateProvider getViewerDefaultState() {
        return new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (AbstractImportPage.this.profile != null) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter((Object)element, clazz);
                    IQueryResult collector = AbstractImportPage.this.profile.query(QueryUtil.createIUQuery((String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, null, false)), (IProgressMonitor)new NullProgressMonitor());
                    if (collector.isEmpty()) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    protected void doFinish() throws Exception {
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }
}

