/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryUtilities;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.osgi.util.NLS;

public class RecreateRepositoryApplication
extends AbstractApplication {
    private static final String PUBLISH_PACK_FILES_AS_SIBLINGS = "publishPackFilesAsSiblings";
    private RepositoryDescriptor descriptor;
    private String repoName = null;
    boolean removeArtifactRepo = true;
    private Map<String, String> repoProperties = null;
    private Map<IArtifactKey, IArtifactDescriptor[]> repoMap = null;

    /*
     * Exception decompiling
     */
    public IStatus run(IProgressMonitor monitor) throws ProvisionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 59->62)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setArtifactRepository(RepositoryDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    private IArtifactRepository initialize(IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager repositoryManager = this.getArtifactRepositoryManager();
        this.removeArtifactRepo = !repositoryManager.contains(this.descriptor.getRepoLocation());
        IArtifactRepository repository = repositoryManager.loadRepository(this.descriptor.getRepoLocation(), 1, monitor);
        if (repository == null || !repository.isModifiable()) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_destinationNotModifiable, (Object)repository.getLocation()));
        }
        if (!(repository instanceof IFileArtifactRepository)) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_notLocalFileRepo, (Object)repository.getLocation()));
        }
        this.repoName = repository.getName();
        this.repoProperties = repository.getProperties();
        this.repoMap = new HashMap<IArtifactKey, IArtifactDescriptor[]>();
        IQueryResult keys = repository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            IArtifactKey key = (IArtifactKey)iterator.next();
            IArtifactDescriptor[] descriptors = repository.getArtifactDescriptors(key);
            this.repoMap.put(key, descriptors);
        }
        return repository;
    }

    private void removeRepository(IArtifactRepository repository, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager = this.getArtifactRepositoryManager();
        manager.removeRepository(repository.getLocation());
        boolean compressed = Boolean.valueOf(this.repoProperties.get("p2.compressed"));
        URI realLocation = SimpleArtifactRepository.getActualLocation((URI)repository.getLocation(), (boolean)compressed);
        File realFile = URIUtil.toFile((URI)realLocation);
        if (!realFile.exists() || !realFile.delete()) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_unableToRemoveRepo, (Object)realFile.toString()));
        }
    }

    private void recreateRepository(IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager = this.getArtifactRepositoryManager();
        HashMap<String, String> newProperties = new HashMap<String, String>(this.repoProperties);
        newProperties.put(PUBLISH_PACK_FILES_AS_SIBLINGS, "true");
        IArtifactRepository repository = manager.createRepository(this.descriptor.getRepoLocation(), this.repoName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", newProperties);
        if (!(repository instanceof IFileArtifactRepository)) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_notLocalFileRepo, (Object)repository.getLocation()));
        }
        IFileArtifactRepository simple = (IFileArtifactRepository)repository;
        Iterator<IArtifactKey> iterator = this.repoMap.keySet().iterator();
        while (iterator.hasNext()) {
            IArtifactKey key = iterator.next();
            IArtifactDescriptor[] descriptors = this.repoMap.get(key);
            String unpackedSize = null;
            File packFile = null;
            HashSet<File> files = new HashSet<File>();
            int i = 0;
            while (i < descriptors.length) {
                File temp;
                File artifactFile = simple.getArtifactFile(descriptors[i]);
                files.add(artifactFile);
                String size = Long.toString(artifactFile.length());
                ArtifactDescriptor newDescriptor = new ArtifactDescriptor(descriptors[i]);
                newDescriptor.setProperty("artifact.size", size);
                newDescriptor.setProperty("download.size", size);
                String md5 = RepositoryUtilities.computeMD5(artifactFile);
                if (md5 != null) {
                    newDescriptor.setProperty("download.md5", md5);
                }
                if ((temp = new File(artifactFile.getParentFile(), String.valueOf(artifactFile.getName()) + ".pack.gz")).exists()) {
                    packFile = temp;
                    unpackedSize = size;
                }
                repository.addDescriptor((IArtifactDescriptor)newDescriptor, null);
                ++i;
            }
            if (packFile == null || files.contains(packFile) || packFile.length() <= 0L) continue;
            ArtifactDescriptor packDescriptor = this.createPack200ArtifactDescriptor(key, packFile, unpackedSize);
            repository.addDescriptor((IArtifactDescriptor)packDescriptor, null);
        }
    }

    private ArtifactDescriptor createPack200ArtifactDescriptor(IArtifactKey key, File packFile, String installSize) {
        if (packFile != null && packFile.exists()) {
            ArtifactDescriptor result = new ArtifactDescriptor(key);
            result.setProperty("artifact.size", installSize);
            result.setProperty("download.size", Long.toString(packFile.length()));
            IProcessingStepDescriptor[] steps = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
            result.setProcessingSteps(steps);
            result.setProperty("format", "packed");
            return result;
        }
        return null;
    }
}

