/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.engine.ActionManager;
import org.eclipse.equinox.internal.p2.engine.EngineSession;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.p2.engine.MissingAction;
import org.eclipse.equinox.internal.p2.engine.MissingActionsException;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class PhaseSet
implements IPhaseSet {
    private final Phase[] phases;

    public PhaseSet(Phase[] phases) {
        if (phases == null) {
            throw new IllegalArgumentException(Messages.null_phases);
        }
        this.phases = phases;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final MultiStatus perform(EngineSession session, Operand[] operands, IProgressMonitor monitor) {
        SubMonitor pm;
        MultiStatus status;
        block17: {
            MultiStatus multiStatus;
            block16: {
                MultiStatus multiStatus2;
                block15: {
                    MultiStatus multiStatus3;
                    block14: {
                        status = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
                        int[] weights = this.getProgressWeights(operands);
                        int totalWork = this.getTotalWork(weights);
                        pm = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
                        try {
                            int i = 0;
                            while (i < this.phases.length) {
                                MultiStatus result;
                                Object var11_14;
                                if (pm.isCanceled()) {
                                    status.add(Status.CANCEL_STATUS);
                                    multiStatus3 = status;
                                    Object var13_18 = null;
                                    break block14;
                                }
                                Phase phase = this.phases[i];
                                phase.actionManager = (ActionManager)session.getAgent().getService(ActionManager.SERVICE_NAME);
                                try {
                                    try {
                                        phase.perform(status, session, operands, (IProgressMonitor)pm.newChild(weights[i]));
                                    }
                                    catch (OperationCanceledException e) {
                                        status.add((IStatus)new Status(8, "org.eclipse.equinox.p2.engine", e.getMessage(), (Throwable)e));
                                    }
                                    catch (RuntimeException e) {
                                        status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", e.getMessage(), (Throwable)e));
                                    }
                                    catch (LinkageError e) {
                                        status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", e.getMessage(), (Throwable)e));
                                    }
                                }
                                catch (Throwable throwable) {
                                    var11_14 = null;
                                    phase.actionManager = null;
                                    throw throwable;
                                }
                                {
                                    var11_14 = null;
                                    phase.actionManager = null;
                                }
                                if (status.matches(8)) {
                                    result = new MultiStatus("org.eclipse.equinox.p2.engine", 8, Messages.Engine_Operation_Canceled_By_User, null);
                                    result.merge((IStatus)status);
                                    multiStatus2 = result;
                                    break block15;
                                }
                                if (status.matches(4)) {
                                    result = new MultiStatus("org.eclipse.equinox.p2.engine", 4, phase.getProblemMessage(), null);
                                    result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", session.getContextString(), null));
                                    result.merge((IStatus)status);
                                    multiStatus = result;
                                    break block16;
                                }
                                ++i;
                            }
                            break block17;
                        }
                        catch (Throwable throwable) {
                            Object var13_21 = null;
                            pm.done();
                            throw throwable;
                        }
                    }
                    pm.done();
                    return multiStatus3;
                }
                Object var13_19 = null;
                pm.done();
                return multiStatus2;
            }
            Object var13_20 = null;
            pm.done();
            return multiStatus;
        }
        Object var13_22 = null;
        pm.done();
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IStatus validate(ActionManager actionManager, IProfile profile, Operand[] operands, ProvisioningContext context, IProgressMonitor monitor) {
        HashSet<MissingAction> missingActions = new HashSet<MissingAction>();
        int i = 0;
        while (true) {
            Object var14_17;
            if (i >= this.phases.length) {
                if (missingActions.isEmpty()) break;
                MissingAction[] missingActionsArray = missingActions.toArray(new MissingAction[missingActions.size()]);
                MissingActionsException exception = new MissingActionsException(missingActionsArray);
                return new Status(4, "org.eclipse.equinox.p2.engine", exception.getMessage(), (Throwable)((Object)exception));
            }
            Phase phase = this.phases[i];
            phase.actionManager = actionManager;
            try {
                int j = 0;
                while (j < operands.length) {
                    Operand operand = operands[j];
                    try {
                        List<ProvisioningAction> actions;
                        if (phase.isApplicable(operand) && (actions = phase.getActions(operand)) != null) {
                            int k = 0;
                            while (k < actions.size()) {
                                ProvisioningAction action = actions.get(k);
                                if (action instanceof MissingAction) {
                                    missingActions.add((MissingAction)action);
                                }
                                ++k;
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        Status status = new Status(4, "org.eclipse.equinox.p2.engine", String.valueOf(e.getMessage()) + " " + this.getContextString(profile, phase, operand), (Throwable)e);
                        var14_17 = null;
                        phase.actionManager = null;
                        return status;
                    }
                    catch (LinkageError e) {
                        Status status = new Status(4, "org.eclipse.equinox.p2.engine", String.valueOf(e.getMessage()) + " " + this.getContextString(profile, phase, operand), (Throwable)e);
                        var14_17 = null;
                        phase.actionManager = null;
                        return status;
                    }
                    ++j;
                }
            }
            catch (Throwable throwable) {
                var14_17 = null;
                phase.actionManager = null;
                throw throwable;
            }
            {
                var14_17 = null;
                phase.actionManager = null;
                ++i;
                continue;
            }
            break;
        }
        return Status.OK_STATUS;
    }

    private String getContextString(IProfile profile, Phase phase, Operand operand) {
        return NLS.bind((String)Messages.session_context, (Object[])new Object[]{profile.getProfileId(), phase.getClass().getName(), operand.toString(), ""});
    }

    private int getTotalWork(int[] weights) {
        int sum = 0;
        int i = 0;
        while (i < weights.length) {
            sum += weights[i];
            ++i;
        }
        return sum;
    }

    private int[] getProgressWeights(Operand[] operands) {
        int[] weights = new int[this.phases.length];
        int i = 0;
        while (i < this.phases.length) {
            weights[i] = operands.length > 0 ? this.phases[i].weight * this.countApplicable(this.phases[i], operands) / operands.length : this.phases[i].weight;
            ++i;
        }
        return weights;
    }

    private int countApplicable(Phase phase, Operand[] operands) {
        int count = 0;
        int i = 0;
        while (i < operands.length) {
            if (phase.isApplicable(operands[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public String[] getPhaseIds() {
        String[] ids = new String[this.phases.length];
        int i = 0;
        while (i < ids.length) {
            ids[i] = this.phases[i].phaseId;
            ++i;
        }
        return ids;
    }

    public Phase[] getPhases() {
        return this.phases;
    }
}

