/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.scatter.AbstractSegmentStoreScatterChartTreeViewer2;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.XmlLatencyViewInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency.PatternScatterGraphViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.xychart.TmfChartView;

public class PatternScatterGraphView
extends TmfChartView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.scattergraph";
    private final XmlLatencyViewInfo fViewInfo = new XmlLatencyViewInfo("org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.scattergraph");
    private PatternScatterGraphViewer fViewer;

    public PatternScatterGraphView() {
        super(ID);
        this.addPartPropertyListener(event -> {
            Object newValue;
            if (event.getProperty().equals("xmlLatencyOutputData") && (newValue = event.getNewValue()) instanceof String) {
                String data = (String)newValue;
                this.fViewInfo.setViewData(data);
                this.setPartName(this.fViewInfo.getLabel());
                this.loadLatencyView();
            }
        });
    }

    public void createPartControl(@Nullable Composite parent) {
        String name = this.getViewSite().getSecondaryId();
        if (name != null) {
            this.fViewInfo.setName(name);
        }
        super.createPartControl(parent);
        Display.getDefault().asyncExec(() -> this.setPartName(this.fViewInfo.getLabel()));
    }

    private void loadLatencyView() {
        if (this.fViewer != null) {
            this.fViewer.updateViewer(this.fViewInfo.getViewAnalysisId());
        }
    }

    protected TmfXYChartViewer createChartViewer(Composite parent) {
        PatternScatterGraphViewer viewer;
        this.fViewer = viewer = new PatternScatterGraphViewer((Composite)NonNullUtils.checkNotNull((Object)parent), (String)NonNullUtils.checkNotNull((Object)Messages.PatternLatencyViews_ScatterGraphTitle), (String)NonNullUtils.checkNotNull((Object)Messages.PatternLatencyViews_ScatterGraphXLabel), (String)NonNullUtils.checkNotNull((Object)Messages.PatternLatencyViews_ScatterGraphYLabel));
        this.loadLatencyView();
        return viewer;
    }

    protected @NonNull TmfViewer createLeftChildViewer(@Nullable Composite parent) {
        String analysisId = this.fViewInfo.getViewAnalysisId();
        return new AbstractSegmentStoreScatterChartTreeViewer2(Objects.requireNonNull(parent), String.valueOf(analysisId)){

            protected @NonNull String getAnalysisId() {
                String viewAnalysisId = PatternScatterGraphView.this.fViewInfo.getViewAnalysisId();
                return viewAnalysisId == null ? super.getAnalysisId() : viewAnalysisId;
            }
        };
    }
}

