/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.tests.analysis.cpu;

import java.util.List;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.cpu.UstCpuAnalysisModule;
import org.eclipse.tracecompass.lttng2.ust.core.tests.shared.LttngUstTestTraceUtils;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UstCpuAnalysisModuleTest {
    private static final @NonNull CtfTestTrace TRACE_WITHOUT_VTID = CtfTestTrace.DEBUG_INFO4;
    private static final @NonNull CtfTestTrace TRACE_WITH_VTID = CtfTestTrace.CYG_PROFILE;
    private UstCpuAnalysisModule fModule;

    @Before
    public void setup() {
        this.fModule = new UstCpuAnalysisModule();
    }

    @After
    public void tearDown() {
        this.fModule.dispose();
        this.fModule = null;
    }

    @Test
    public void testGetAnalysisRequirements() {
        Iterable requirements = this.fModule.getAnalysisRequirements();
        Assert.assertNotNull((Object)requirements);
        Assert.assertEquals((long)1L, (long)StreamSupport.stream(requirements.spliterator(), false).count());
    }

    @Test
    public void testCanExecute() {
        LttngUstTrace trace = LttngUstTestTraceUtils.getTrace(TRACE_WITH_VTID);
        Assert.assertTrue((boolean)this.fModule.canExecute((ITmfTrace)trace));
        LttngUstTestTraceUtils.dispose(TRACE_WITH_VTID);
    }

    @Test
    public void testCannotExcecute() {
        LttngUstTrace invalidTrace = LttngUstTestTraceUtils.getTrace(TRACE_WITHOUT_VTID);
        Assert.assertFalse((boolean)this.fModule.canExecute((ITmfTrace)invalidTrace));
        LttngUstTestTraceUtils.dispose(TRACE_WITHOUT_VTID);
    }

    private void executeModule(@NonNull ITmfTrace trace) {
        try {
            this.fModule.setTrace(trace);
        }
        catch (TmfAnalysisException e) {
            Assert.fail();
        }
        this.fModule.schedule();
        this.fModule.waitForCompletion();
    }

    @Test
    public void testExecution() {
        LttngUstTrace trace = LttngUstTestTraceUtils.getTrace(TRACE_WITH_VTID);
        this.executeModule((ITmfTrace)trace);
        ITmfStateSystem ss = this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        LttngUstTestTraceUtils.dispose(TRACE_WITH_VTID);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testGetCpuForThread() {
        LttngUstTrace trace = LttngUstTestTraceUtils.getTrace(TRACE_WITH_VTID);
        this.executeModule((ITmfTrace)trace);
        ITmfStateSystem ss = this.fModule.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int parentThreadsQuark = -1;
        try {
            parentThreadsQuark = ss.getQuarkAbsolute(new String[]{"Threads"});
        }
        catch (AttributeNotFoundException e) {
            Assert.fail();
        }
        @NonNull List threadsQuarks = ss.getSubAttributes(parentThreadsQuark, false);
        Assert.assertEquals((long)1L, (long)threadsQuarks.size());
        Integer threadQuark = (Integer)threadsQuarks.iterator().next();
        try {
            ITmfStateInterval cpuState = ss.querySingleState(ss.getCurrentEndTime(), threadQuark.intValue());
            Assert.assertNotNull((Object)cpuState.getValue());
            Assert.assertEquals((Object)3, (Object)cpuState.getValue());
            cpuState = ss.querySingleState(ss.getStartTime(), threadQuark.intValue());
            Assert.assertNotNull((Object)cpuState.getValue());
            Assert.assertEquals((Object)0, (Object)cpuState.getValue());
            cpuState = ss.querySingleState(ss.getStartTime() + (ss.getCurrentEndTime() - ss.getStartTime()) / 2L, threadQuark.intValue());
            Assert.assertNotNull((Object)cpuState.getValue());
            Assert.assertEquals((Object)3, (Object)cpuState.getValue());
        }
        catch (StateSystemDisposedException e) {
            Assert.fail();
        }
        LttngUstTestTraceUtils.dispose(TRACE_WITH_VTID);
    }
}

