/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.CallStackSeries;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.EdgeStateValue;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.FlameChartArrowProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.FlameChartEntryModel;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.InstrumentedCallStackElement;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.Messages;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ProcessStatusInterval;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.FlameDefaultPalette;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.FlameWithKernelPalette;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callstack.CallStack;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callstack.CallStackDepth;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.instrumented.IFlameChartProvider;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.model.IHostModel;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphStateFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class FlameChartDataProvider
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<FlameChartEntryModel>,
IOutputStyleProvider {
    public static final String ID = "org.eclipse.tracecompass.analysis.profiling.core.flamechart";
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private static final Logger LOGGER = TraceCompassLog.getLogger(FlameChartDataProvider.class);
    private final Map<Long, FlameChartEntryModel> fEntries = new HashMap<Long, FlameChartEntryModel>();
    private final BiMap<Long, Long> fLinkedEntries = HashBiMap.create();
    private final Collection<ISymbolProvider> fProviders = new ArrayList<ISymbolProvider>();
    private final BiMap<Long, CallStackDepth> fIdToCallstack = HashBiMap.create();
    private final BiMap<Long, ICallStackElement> fIdToElement = HashBiMap.create();
    private final long fTraceId = ENTRY_ID.getAndIncrement();
    private final Map<Long, Multimap<String, Object>> fEntryMetadata = new HashMap<Long, Multimap<String, Object>>();
    private final LoadingCache<Pair<Integer, ICalledFunction>, @Nullable String> fTimeEventNames = Objects.requireNonNull(CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Pair<Integer, ICalledFunction>, String>(){

        public @Nullable String load(Pair<Integer, ICalledFunction> pidInterval) {
            Integer pid = (Integer)pidInterval.getFirst();
            ICalledFunction interval = (ICalledFunction)pidInterval.getSecond();
            Object nameValue = interval.getSymbol();
            Long address = null;
            Object name = null;
            if (nameValue instanceof String) {
                name = (String)nameValue;
                try {
                    address = Long.parseLong((String)name, 16);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (nameValue instanceof Integer) {
                Integer intValue = (Integer)nameValue;
                name = "0x" + Integer.toUnsignedString(intValue, 16);
                address = intValue.longValue();
            } else if (nameValue instanceof Long) {
                address = (long)((Long)nameValue);
                name = "0x" + Long.toUnsignedString(address, 16);
            }
            if (address != null) {
                name = SymbolProviderUtils.getSymbolText(FlameChartDataProvider.this.fProviders, (int)pid, (long)interval.getStart(), (long)address);
            }
            return name;
        }
    }));
    private final IFlameChartProvider fFcProvider;
    private final String fAnalysisId;
    private final FlameChartArrowProvider fArrowProvider;
    private @Nullable TmfModelResponse<TmfTreeModel<FlameChartEntryModel>> fCached;

    public FlameChartDataProvider(ITmfTrace trace, IFlameChartProvider module, String secondaryId) {
        super(trace);
        this.fFcProvider = module;
        this.fAnalysisId = secondaryId;
        this.fArrowProvider = new FlameChartArrowProvider(trace);
        this.resetFunctionNames((IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        List<ITmfStateInterval> arrows = this.fArrowProvider.fetchArrows(fetchParameters, monitor);
        if (monitor != null && monitor.isCanceled()) {
            return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        if (arrows.isEmpty()) {
            return new TmfModelResponse(Collections.emptyList(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        ArrayList<TimeGraphArrow> tgArrows = new ArrayList<TimeGraphArrow>();
        ArrayList csList = new ArrayList();
        BiMap<Long, CallStackDepth> biMap = this.fIdToCallstack;
        synchronized (biMap) {
            csList.addAll(this.fIdToCallstack.values());
        }
        HashSet<CallStack> callstacks = new HashSet<CallStack>();
        for (CallStackDepth csd : csList) {
            callstacks.add(csd.getCallStack());
        }
        for (ITmfStateInterval interval : arrows) {
            if (monitor != null && monitor.isCanceled()) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
            EdgeStateValue edge = (EdgeStateValue)((Object)interval.getValue());
            if (edge == null) continue;
            Long src = this.findEntry(callstacks, edge.getSource(), interval.getStartTime());
            Long dst = this.findEntry(callstacks, edge.getDestination(), interval.getEndTime() + 1L);
            if (src == null || dst == null) continue;
            long duration = interval.getEndTime() - interval.getStartTime() + 1L;
            tgArrows.add(new TimeGraphArrow(src.longValue(), dst.longValue(), interval.getStartTime(), duration, edge.getId()));
        }
        return new TmfModelResponse(tgArrows, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable Long findEntry(Set<CallStack> callstacks, HostThread hostThread, long ts) {
        for (CallStack callstack : callstacks) {
            HostThread csHt = callstack.getHostThread(ts);
            if (csHt == null || !csHt.equals((Object)hostThread)) continue;
            int currentDepth = callstack.getCurrentDepth(ts);
            CallStackDepth csd = new CallStackDepth(callstack, currentDepth);
            BiMap<Long, CallStackDepth> biMap = this.fIdToCallstack;
            synchronized (biMap) {
                return (Long)this.fIdToCallstack.inverse().get((Object)csd);
            }
        }
        return null;
    }

    public TmfModelResponse<Map<String, String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameChartDataProvider#fetchTooltip", new Object[0]).setCategory(((Object)((Object)this)).getClass().getSimpleName()).build();){
            List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
            if (times == null || times.isEmpty()) {
                return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            }
            BiMap<Long, FlameChartEntryModel> entries = this.getSelectedEntries(fetchParameters);
            if (entries.size() != 1) {
                return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            }
            Map.Entry entry = entries.entrySet().iterator().next();
            Map<String, String> tooltip = this.getTooltip((Long)entry.getKey(), (FlameChartEntryModel)((Object)entry.getValue()), (Long)times.get(0));
            return new TmfModelResponse(tooltip, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private @Nullable Map<String, String> getTooltip(Long entryId, FlameChartEntryModel entryModel, Long time) {
        switch (entryModel.getEntryType()) {
            case FUNCTION: {
                CallStackDepth selectedDepth = (CallStackDepth)this.fIdToCallstack.get((Object)entryId);
                if (selectedDepth == null) {
                    return null;
                }
                Multimap<CallStackDepth, ISegment> csFunctions = this.fFcProvider.queryCallStacks(Collections.singleton(selectedDepth), Collections.singleton(time));
                Collection functions = csFunctions.get((Object)selectedDepth);
                if (functions.isEmpty()) {
                    return null;
                }
                ISegment next = (ISegment)functions.iterator().next();
                if (!(next instanceof ICalledFunction)) {
                    return null;
                }
                ICalledFunction currentFct = (ICalledFunction)next;
                HashMap<String, String> tooltips = new HashMap<String, String>();
                int threadId = currentFct.getThreadId();
                if (threadId > 0) {
                    tooltips.put(String.valueOf(Messages.FlameChartDataProvider_ThreadId), String.valueOf(threadId));
                }
                Object symbol = currentFct.getSymbol();
                tooltips.put(String.valueOf(Messages.FlameChartDataProvider_Symbol), (String)(symbol instanceof Long ? "0x" + Long.toHexString((Long)symbol) : String.valueOf(symbol)));
                return tooltips;
            }
        }
        return null;
    }

    public String getId() {
        return "org.eclipse.tracecompass.analysis.profiling.core.flamechart:" + this.fAnalysisId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getEntryId(CallStackDepth stack) {
        BiMap<Long, CallStackDepth> biMap = this.fIdToCallstack;
        synchronized (biMap) {
            return (Long)this.fIdToCallstack.inverse().computeIfAbsent((Object)stack, q -> ENTRY_ID.getAndIncrement());
        }
    }

    private long getEntryId(ICallStackElement instrumentedCallStackElement) {
        return (Long)this.fIdToElement.inverse().computeIfAbsent((Object)instrumentedCallStackElement, q -> ENTRY_ID.getAndIncrement());
    }

    private long getKernelEntryId(long baseId) {
        return (Long)this.fLinkedEntries.inverse().computeIfAbsent((Object)baseId, id -> ENTRY_ID.getAndIncrement());
    }

    public TmfModelResponse<TmfTreeModel<FlameChartEntryModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        if (this.fCached != null) {
            return this.fCached;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameChartDataProvider#fetchTree", new Object[0]).setCategory(((Object)((Object)this)).getClass().getSimpleName()).build();){
            IFlameChartProvider fcProvider = this.fFcProvider;
            boolean complete = fcProvider.isComplete();
            CallStackSeries callstack = fcProvider.getCallStackSeries();
            if (callstack == null) {
                return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), Collections.emptyList()), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
            }
            long start = this.getTrace().getStartTime().getValue();
            long end = Math.max(start, fcProvider.getEnd());
            ImmutableList.Builder builder = ImmutableList.builder();
            FlameChartEntryModel traceEntry = new FlameChartEntryModel(this.fTraceId, -1L, this.getTrace().getName(), start, end, FlameChartEntryModel.EntryType.TRACE);
            builder.add((Object)traceEntry);
            FlameChartEntryModel callStackRoot = traceEntry;
            for (ICallStackElement element : callstack.getRootElements()) {
                if (monitor != null && monitor.isCanceled()) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                this.processCallStackElement(element, (ImmutableList.Builder<FlameChartEntryModel>)builder, callStackRoot);
            }
            ImmutableList tree = builder.build();
            tree.forEach(entry -> {
                FlameChartEntryModel flameChartEntryModel = this.fEntries.put(entry.getId(), (FlameChartEntryModel)((Object)entry));
            });
            for (FlameChartEntryModel model : tree) {
                this.fEntryMetadata.put(model.getId(), model.getMetadata());
            }
            if (complete) {
                TmfModelResponse response;
                this.fCached = response = new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), (List)tree), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                return response;
            }
            return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), (List)tree), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void processCallStackElement(ICallStackElement element, ImmutableList.Builder<FlameChartEntryModel> builder, FlameChartEntryModel parentEntry) {
        long elementId = this.getEntryId(element);
        if (element instanceof InstrumentedCallStackElement && ((InstrumentedCallStackElement)element).isCallStack()) {
            InstrumentedCallStackElement finalElement = (InstrumentedCallStackElement)element;
            CallStack callStack = finalElement.getCallStack();
            HostThread hostThread = callStack.getHostThread();
            FlameChartEntryModel entry = new FlameChartEntryModel(elementId, parentEntry.getId(), element.getName(), parentEntry.getStartTime(), parentEntry.getEndTime(), FlameChartEntryModel.EntryType.LEVEL, -1, hostThread);
            builder.add((Object)entry);
            int depth = 0;
            while (depth < callStack.getMaxDepth()) {
                FlameChartEntryModel flameChartEntry = new FlameChartEntryModel(this.getEntryId(new CallStackDepth(callStack, depth + 1)), entry.getId(), element.getName(), parentEntry.getStartTime(), parentEntry.getEndTime(), FlameChartEntryModel.EntryType.FUNCTION, depth + 1, hostThread);
                builder.add((Object)flameChartEntry);
                if (depth == 0 && callStack.hasKernelStatuses()) {
                    builder.add((Object)new FlameChartEntryModel(this.getKernelEntryId(flameChartEntry.getId()), entry.getId(), String.valueOf(Messages.FlameChartDataProvider_KernelStatusTitle), parentEntry.getStartTime(), parentEntry.getEndTime(), FlameChartEntryModel.EntryType.KERNEL, -1, hostThread));
                }
                ++depth;
            }
            if (!element.isLeaf()) {
                for (ICallStackElement child : element.getChildrenElements()) {
                    this.processCallStackElement(child, builder, entry);
                }
            }
            return;
        }
        FlameChartEntryModel entry = new FlameChartEntryModel(elementId, parentEntry.getId(), element.getName(), parentEntry.getStartTime(), parentEntry.getEndTime(), FlameChartEntryModel.EntryType.LEVEL);
        builder.add((Object)entry);
        for (ICallStackElement child : element.getChildrenElements()) {
            this.processCallStackElement(child, builder, entry);
        }
    }

    private BiMap<Long, FlameChartEntryModel> getSelectedEntries(Map<String, Object> fetchParameters) {
        HashBiMap selectedEntries = HashBiMap.create();
        List ids = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        if (ids == null) {
            return selectedEntries;
        }
        for (Long selectedItem : ids) {
            FlameChartEntryModel entryModel = this.fEntries.get(selectedItem);
            if (entryModel == null) continue;
            selectedEntries.put((Object)selectedItem, (Object)entryModel);
        }
        return selectedEntries;
    }

    public TmfModelResponse<TimeGraphModel> fetchRowModel(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameChartDataProvider#fetchRowModel", new Object[0]).setCategory(((Object)((Object)this)).getClass().getSimpleName()).build();){
                BiMap<Long, FlameChartEntryModel> entries = this.getSelectedEntries(fetchParameters);
                List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
                if (times == null) {
                    return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                }
                if (entries.size() == 1 && times.size() == 2) {
                    Map.Entry<Long, FlameChartEntryModel> entry2 = entries.entrySet().iterator().next();
                    if ((Long)times.get(0) == Long.MIN_VALUE) {
                        List<ITimeGraphRowModel> followEvents = this.getFollowEvent(entry2, (Long)times.get(times.size() - 1), false);
                        TimeGraphModel model = followEvents == null ? null : new TimeGraphModel(followEvents);
                        return new TmfModelResponse((Object)model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                    }
                    if ((Long)times.get(times.size() - 1) == Long.MAX_VALUE) {
                        List<ITimeGraphRowModel> followEvents = this.getFollowEvent(entry2, (Long)times.get(0), true);
                        TimeGraphModel model = followEvents == null ? null : new TimeGraphModel(followEvents);
                        return new TmfModelResponse((Object)model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                    }
                }
                this.addRequiredCallstacks((Map<Long, FlameChartEntryModel>)entries);
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"FlameChartDataProvider#fetchRowModel", (int)2);
                IFlameChartProvider fcProvider = this.fFcProvider;
                boolean complete = fcProvider.isComplete();
                Map<Long, List<ITimeGraphState>> csRows = this.getCallStackRows(fetchParameters, (Map<Long, FlameChartEntryModel>)entries, subMonitor);
                if (csRows == null) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                List collect = csRows.entrySet().stream().map(entry -> new TimeGraphRowModel(((Long)entry.getKey()).longValue(), (List)entry.getValue())).collect(Collectors.toList());
                return new TmfModelResponse((Object)new TimeGraphModel(collect), complete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING, complete ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IndexOutOfBoundsException | TimeRangeException e) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, String.valueOf(e.getMessage()));
        }
    }

    private void addRequiredCallstacks(Map<Long, FlameChartEntryModel> entries) {
        HashMap<Long, FlameChartEntryModel> toAdd = new HashMap<Long, FlameChartEntryModel>();
        for (Long id : entries.keySet()) {
            FlameChartEntryModel entry;
            Long csId = (Long)this.fLinkedEntries.get((Object)id);
            if (csId == null || (entry = this.fEntries.get(csId)) == null) continue;
            toAdd.put(csId, entry);
        }
        entries.putAll(toAdd);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable Map<Long, List<ITimeGraphState>> getCallStackRows(Map<String, Object> fetchParameters, Map<Long, FlameChartEntryModel> entries, SubMonitor subMonitor) throws IndexOutOfBoundsException, TimeRangeException {
        HashMap<Long, List<ITimeGraphState>> rows = new HashMap<Long, List<ITimeGraphState>>();
        ArrayList<TidInformation> tids = new ArrayList<TidInformation>();
        HashMap<Long, CallStackDepth> csEntries = new HashMap<Long, CallStackDepth>();
        for (Map.Entry<Long, FlameChartEntryModel> entry : entries.entrySet()) {
            CallStackDepth selectedDepth = (CallStackDepth)this.fIdToCallstack.get((Object)entry.getKey());
            if (selectedDepth == null || entry.getValue().getEntryType() != FlameChartEntryModel.EntryType.FUNCTION) continue;
            csEntries.put(entry.getKey(), selectedDepth);
        }
        List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        Collections.sort(times);
        Multimap<CallStackDepth, ISegment> csFunctions = this.fFcProvider.queryCallStacks(csEntries.values(), Objects.requireNonNull(times));
        HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(fetchParameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        for (Map.Entry entry : csEntries.entrySet()) {
            if (subMonitor.isCanceled()) {
                return null;
            }
            Collection states = csFunctions.get((Object)((CallStackDepth)entry.getValue()));
            Long key = Objects.requireNonNull((Long)entry.getKey());
            ArrayList<ITimeGraphState> eventList = new ArrayList<ITimeGraphState>(states.size());
            states.forEach(state -> {
                ITimeGraphState timeGraphState = this.createTimeGraphState((ISegment)state);
                this.applyFilterAndAddState(eventList, timeGraphState, key, predicates, (IProgressMonitor)subMonitor);
            });
            eventList.sort(Comparator.comparingLong(ITimeElement::getStartTime));
            rows.put((Long)entry.getKey(), eventList);
            Long linked = (Long)this.fLinkedEntries.inverse().get(entry.getKey());
            if (linked == null || !entries.containsKey(linked)) continue;
            tids.addAll(FlameChartDataProvider.getKernelTids((CallStackDepth)entry.getValue(), states, linked));
        }
        for (Long key : entries.keySet()) {
            rows.computeIfAbsent(key, k -> Collections.emptyList());
        }
        if (!tids.isEmpty()) {
            rows.putAll(this.getKernelStates(tids, times, predicates, subMonitor));
        }
        subMonitor.worked(1);
        return rows;
    }

    private Map<Long, List<ITimeGraphState>> getKernelStates(List<TidInformation> tids, List<Long> times, Map<Integer, Predicate<Multimap<String, Object>>> predicates, SubMonitor monitor) {
        HashMap<Long, List<ITimeGraphState>> kernelStates = new HashMap<Long, List<ITimeGraphState>>();
        IHostModel model = ModelManager.getModelFor(this.getTrace().getHostId());
        Map<Integer, Long> threadIdsToEntryIds = tids.stream().collect(Collectors.toMap(tid -> tid.fTid.getTid(), tid -> tid.fLinked));
        Map<Integer, Iterable<ProcessStatusInterval>> kernelStatuses = model.getThreadStatusIntervals(threadIdsToEntryIds.keySet(), times, (IProgressMonitor)monitor);
        for (Map.Entry<Integer, Iterable<ProcessStatusInterval>> processStatuses : kernelStatuses.entrySet()) {
            Long linkedEntryId = threadIdsToEntryIds.get(processStatuses.getKey());
            if (linkedEntryId == null) continue;
            Long entryId = (Long)this.fLinkedEntries.get((Object)linkedEntryId);
            if (entryId == null) {
                entryId = linkedEntryId;
            }
            List states = kernelStates.computeIfAbsent(linkedEntryId, k -> new ArrayList());
            for (ProcessStatusInterval processStatus : Objects.requireNonNull(processStatuses.getValue())) {
                OutputElementStyle style = new OutputElementStyle(FlameWithKernelPalette.getStyleFor(processStatus.getProcessStatus().getStateValue().unboxInt()));
                TimeGraphState state = new TimeGraphState(processStatus.getStart(), processStatus.getLength(), processStatus.getSyscallName(), style);
                this.applyFilterAndAddState(states, (ITimeGraphState)state, entryId, predicates, (IProgressMonitor)monitor);
            }
        }
        return kernelStates;
    }

    private static Collection<TidInformation> getKernelTids(CallStackDepth callStackDepth, Collection<ISegment> states, Long linked) {
        ArrayList<TidInformation> tids = new ArrayList<TidInformation>();
        CallStack callStack = callStackDepth.getCallStack();
        if (!callStack.isTidVariable()) {
            HostThread hostThread = callStack.getHostThread();
            if (hostThread != null) {
                tids.add(new TidInformation(hostThread, linked));
            }
            return tids;
        }
        for (ISegment state : states) {
            ICalledFunction function;
            HostThread hostThread;
            if (!(state instanceof ICalledFunction) || (hostThread = callStack.getHostThread((function = (ICalledFunction)state).getStart())) == null) continue;
            tids.add(new TidInformation(hostThread, linked));
        }
        return tids;
    }

    private ITimeGraphState createTimeGraphState(ISegment state) {
        if (!(state instanceof ICalledFunction)) {
            return new TimeGraphState(state.getStart(), state.getLength(), Integer.MIN_VALUE);
        }
        ICalledFunction function = (ICalledFunction)state;
        Integer pid = function.getProcessId();
        String name = String.valueOf(this.fTimeEventNames.getUnchecked((Object)new Pair((Object)pid, (Object)function)));
        return new TimeGraphState(function.getStart(), function.getLength(), name, FlameDefaultPalette.getInstance().getStyleFor(state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFunctionNames(IProgressMonitor monitor) {
        this.fTimeEventNames.invalidateAll();
        Collection<ISymbolProvider> collection = this.fProviders;
        synchronized (collection) {
            Collection symbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(this.getTrace());
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"CallStackDataProvider#resetFunctionNames", (int)symbolProviders.size());
            this.fProviders.clear();
            for (ISymbolProvider symbolProvider : symbolProviders) {
                this.fProviders.add(symbolProvider);
                symbolProvider.loadConfiguration((IProgressMonitor)sub);
                sub.worked(1);
            }
        }
    }

    private @Nullable List<ITimeGraphRowModel> getFollowEvent(Map.Entry<Long, FlameChartEntryModel> entry, long time, boolean forward) {
        FlameChartEntryModel value = Objects.requireNonNull(entry.getValue());
        switch (value.getEntryType()) {
            case FUNCTION: {
                CallStackDepth selectedDepth = (CallStackDepth)this.fIdToCallstack.get((Object)entry.getKey());
                if (selectedDepth == null) {
                    return null;
                }
                ITmfStateInterval nextDepth = selectedDepth.getCallStack().getNextDepth(time, forward);
                if (nextDepth == null) {
                    return null;
                }
                Object depthVal = nextDepth.getValue();
                int depth = depthVal instanceof Number ? ((Number)depthVal).intValue() : 0;
                TimeGraphState state = new TimeGraphState(nextDepth.getStartTime(), nextDepth.getEndTime() - nextDepth.getStartTime(), depth);
                TimeGraphRowModel row = new TimeGraphRowModel(entry.getKey().longValue(), Collections.singletonList(state));
                return Collections.singletonList(row);
            }
        }
        return null;
    }

    public @NonNull Multimap<String, Object> getFilterData(long entryId, long time, @Nullable IProgressMonitor monitor) {
        Multimap data = ITimeGraphStateFilter.mergeMultimaps((Multimap[])new Multimap[]{super.getFilterData(entryId, time, monitor), this.fEntryMetadata.getOrDefault(entryId, (Multimap<String, Object>)ImmutableMultimap.of())});
        FlameChartEntryModel entryModel = this.fEntries.get(entryId);
        if (entryModel == null) {
            return data;
        }
        Map<String, String> tooltip = this.getTooltip(entryId, entryModel, time);
        if (tooltip == null) {
            return data;
        }
        for (Map.Entry<String, String> entry : tooltip.entrySet()) {
            data.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return data;
    }

    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Map<String, OutputElementStyle> styles = FlameWithKernelPalette.getInstance().getStyles();
        return new TmfModelResponse((Object)new OutputStyleModel(styles), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private static class TidInformation {
        private final HostThread fTid;
        private final Long fLinked;

        public TidInformation(HostThread hostThread, Long linked) {
            this.fTid = hostThread;
            this.fLinked = linked;
        }
    }
}

