/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageEntryModel;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CPUUsagePresentationProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageView;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer2;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class CpuUsageTreeViewer
extends AbstractSelectTreeViewer2 {
    private CPUUsagePresentationProvider fPresentationProvider;

    public CpuUsageTreeViewer(Composite parent) {
        super(parent, 4, "org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageDataProvider");
        this.setLabelProvider((IBaseLabelProvider)new CpuLabelProvider());
    }

    protected void updateContent(long start, long end, boolean isSelection) {
        super.updateContent(start, end, isSelection);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Map<String, Object> getParameters(long start, long end, boolean isSelection) {
        long newStart = Long.max(start, this.getStartTime());
        long newEnd = Long.min(end, this.getEndTime());
        if (isSelection || newEnd < newStart) {
            return Collections.emptyMap();
        }
        @NonNull @NonNull Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(start, end, 2, Collections.emptyList()));
        parameters.put("requested_cpus", CpuUsageView.getCpus(this.getTrace()));
        return parameters;
    }

    protected ITmfTreeViewerEntry modelToTree(long start, long end, List<ITmfTreeDataModel> model) {
        double time = end - start;
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        TmfTreeViewerEntry root = new TmfTreeViewerEntry("");
        map.put(-1L, root);
        for (CpuUsageEntryModel entryModel : Iterables.filter(model, CpuUsageEntryModel.class)) {
            int tid = entryModel.getTid();
            if (tid < 0) {
                this.fPresentationProvider.addTotalSeries(entryModel.getId());
            }
            CpuUsageEntry cpuUsageEntry = new CpuUsageEntry(entryModel, (double)entryModel.getTime() / time);
            map.put(entryModel.getId(), (Object)cpuUsageEntry);
            TmfTreeViewerEntry parent = (TmfTreeViewerEntry)map.get(entryModel.getParentId());
            if (parent == null) continue;
            parent.addChild((TmfTreeViewerEntry)cpuUsageEntry);
        }
        return root;
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return () -> {
            ImmutableList.Builder columns = ImmutableList.builder();
            columns.add((Object)CpuUsageTreeViewer.createColumn((String)org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage.Messages.CpuUsageDataProvider_ColumnProcess, Comparator.comparing(TmfTreeViewerEntry::getName)));
            Comparator<CpuUsageEntry> tidCompare = Comparator.comparingInt(c -> ((CpuUsageEntryModel)c.getModel()).getTid());
            columns.add((Object)CpuUsageTreeViewer.createColumn((String)OsStrings.tid(), tidCompare));
            TmfTreeColumnData percentColumn = CpuUsageTreeViewer.createColumn((String)org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage.Messages.CpuUsageDataProvider_ColumnPercent, Comparator.comparingDouble(CpuUsageEntry::getPercent));
            percentColumn.setPercentageProvider(data -> ((CpuUsageEntry)((Object)((Object)((Object)data)))).getPercent());
            columns.add((Object)percentColumn);
            Comparator<CpuUsageEntry> timeCompare = Comparator.comparingLong(c -> ((CpuUsageEntryModel)c.getModel()).getTime());
            columns.add((Object)CpuUsageTreeViewer.createColumn((String)org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage.Messages.CpuUsageDataProvider_ColumnTime, timeCompare));
            columns.add((Object)new TmfTreeColumnData(Messages.CpuUsageComposite_ColumnLegend));
            return columns.build();
        };
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        this.fPresentationProvider = CPUUsagePresentationProvider.getForTrace(signal.getTrace());
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        super.traceOpened(signal);
        this.fPresentationProvider = CPUUsagePresentationProvider.getForTrace(signal.getTrace());
    }

    protected class CpuLabelProvider
    extends AbstractSelectTreeViewer2.DataProviderTreeLabelProvider {
        protected CpuLabelProvider() {
            super((AbstractSelectTreeViewer2)CpuUsageTreeViewer.this);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 4 && element instanceof CpuUsageEntry) {
                CpuUsageEntry cpuUsageEntry = (CpuUsageEntry)((Object)element);
                CpuUsageEntryModel model = (CpuUsageEntryModel)cpuUsageEntry.getModel();
                int tid = model.getTid();
                if (tid < 0) {
                    return CpuUsageTreeViewer.this.getLegendImage(model.getId());
                }
                if (CpuUsageTreeViewer.this.isChecked(element)) {
                    return CpuUsageTreeViewer.this.getLegendImage(model.getId());
                }
            }
            return null;
        }
    }
}

