/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.datamodel.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.IDataModelPausibleOperation;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.AddablePageGroup;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageGroup;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageHandler;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.PageExtensionManager;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.SimplePageGroup;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.WarningDialog;
import org.eclipse.wst.common.frameworks.internal.eclipse.ui.EclipseEnvironment;
import org.eclipse.wst.common.frameworks.internal.ui.ErrorDialog;
import org.eclipse.wst.common.frameworks.internal.ui.PageGroupManager;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;

public abstract class DataModelWizard
extends Wizard
implements IDMPageHandler {
    private IDataModel dataModel;
    private AddablePageGroup rootPageGroup;
    private IDataModelPausibleOperation rootOperation;
    private PageGroupManager pageGroupManager;
    private PageExtensionManager pageExtensionManager;
    private boolean executing = false;

    public DataModelWizard(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public DataModelWizard() {
    }

    protected abstract IDataModelProvider getDefaultProvider();

    public final String getWizardID() {
        return this.getDataModel().getID();
    }

    protected IDataModelPausibleOperation getRootOperation() {
        return (IDataModelPausibleOperation)this.getDataModel().getDefaultOperation();
    }

    public final void addPages() {
        this.init();
        this.doAddPages();
    }

    protected void doAddPages() {
    }

    public IWizardPage getStartingPage() {
        this.pageGroupManager.reset();
        return this.getNextPage(null);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage currentPage = this.pageGroupManager.getCurrentPage();
        this.pageGroupManager.moveForwardOnePage();
        IWizardPage nextPage = this.pageGroupManager.getCurrentPage();
        if (currentPage != nextPage && nextPage != null) {
            nextPage.setWizard((IWizard)this);
            nextPage.setPreviousPage(currentPage);
        }
        return currentPage == nextPage ? null : nextPage;
    }

    @Override
    public String getNextPage(String currentPageName, String expectedNextPageName) {
        return expectedNextPageName;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return page != null ? page.getPreviousPage() : null;
    }

    @Override
    public String getPreviousPage(String currentPageName, String expectedPreviousPageName) {
        return expectedPreviousPageName;
    }

    public boolean canFinish() {
        return super.canFinish() && this.getDataModel().isValid();
    }

    public PageGroupManager getPageGroupManager() {
        return this.pageGroupManager;
    }

    public PageExtensionManager getPageExtensionManager() {
        return this.pageExtensionManager;
    }

    protected void resetAfterFinishError() {
    }

    protected boolean isExecuting() {
        return this.executing;
    }

    public final boolean performFinish() {
        try {
            try {
                this.executing = true;
                if (this.prePerformFinish()) {
                    this.storeDefaultSettings();
                    IStatus st = this.runOperations();
                    if (st.getSeverity() == 4) {
                        WTPUIPlugin.log(st);
                        Throwable t = st.getException() == null ? new CoreException(st) : st.getException();
                        ErrorDialog.openError(this.getShell(), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_0, new Object[]{this.getWindowTitle()}), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_1, new Object[]{this.getWindowTitle()}), t, 0, false);
                    } else if (st.getSeverity() == 2) {
                        WarningDialog.openWarning(this.getShell(), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_2, new Object[]{this.getWindowTitle()}), st.getMessage(), st, 2);
                    }
                    this.postPerformFinish();
                }
            }
            catch (Exception exc) {
                WTPUIPlugin.log(exc);
                ErrorDialog.openError(this.getShell(), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_0, new Object[]{this.getWindowTitle()}), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_1, new Object[]{this.getWindowTitle()}), exc, 0, false);
                this.executing = false;
            }
        }
        finally {
            this.executing = false;
        }
        return true;
    }

    private IStatus runOperations() {
        IStatus[] status = new IStatus[1];
        class CatchThrowableRunnableWithProgress
        implements IRunnableWithProgress {
            public Throwable caught = null;
            private final /* synthetic */ IStatus[] val$status;

            CatchThrowableRunnableWithProgress(IStatus[] iStatusArray) {
                this.val$status = iStatusArray;
            }

            public void run(IProgressMonitor pm) {
                try {
                    if (DataModelWizard.this.rootOperation == null) {
                        DataModelWizard.this.rootOperation = DataModelWizard.this.getRootOperation();
                    }
                    this.val$status[0] = DataModelWizard.this.rootOperation.execute(pm, null);
                }
                catch (Throwable e) {
                    this.caught = e;
                }
            }
        }
        CatchThrowableRunnableWithProgress runnable = new CatchThrowableRunnableWithProgress(status);
        try {
            this.getContainer().run(this.runForked(), this.isCancelable(), (IRunnableWithProgress)runnable);
        }
        catch (Throwable e) {
            runnable.caught = e;
        }
        if (runnable.caught != null) {
            WTPUIPlugin.logError(runnable.caught);
            status[0] = new Status(4, "id", 0, runnable.caught.getMessage(), runnable.caught);
            ErrorDialog.openError(this.getShell(), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_0, new Object[]{this.getWindowTitle()}), WTPCommonUIResourceHandler.getString(WTPCommonUIResourceHandler.WTPWizard_UI_1, new Object[]{this.getWindowTitle()}), runnable.caught, 0, false);
        }
        return status[0];
    }

    public boolean performCancel() {
        this.pageGroupManager.undoAllCurrentOperations();
        return true;
    }

    protected boolean prePerformFinish() {
        return true;
    }

    protected void postPerformFinish() throws InvocationTargetException {
    }

    protected void storeDefaultSettings() {
        this.pageGroupManager.storeDefaultSettings(this);
    }

    public void storeDefaultSettings(IWizardPage page) {
        if (page instanceof DataModelWizardPage) {
            ((DataModelWizardPage)page).storeDefaultSettings();
        }
    }

    protected void storeDefaultSettings(IWizardPage page, int pageIndex) {
        this.storeDefaultSettings(page);
    }

    protected boolean isCancelable() {
        return false;
    }

    protected boolean runForked() {
        return true;
    }

    public void setDataModel(IDataModel model) {
        this.dataModel = model;
    }

    public IDataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = DataModelFactory.createDataModel((IDataModelProvider)this.getDefaultProvider());
        }
        return this.dataModel;
    }

    public void dispose() {
        super.dispose();
        if (this.rootPageGroup != null) {
            List pages = this.rootPageGroup.getPages(this.dataModel);
            for (Object page : pages) {
                if (!(page instanceof IWizardPage)) continue;
                ((IWizardPage)page).dispose();
            }
        }
        if (this.dataModel != null) {
            this.dataModel.dispose();
        }
    }

    protected AddablePageGroup createRootPageGroup() {
        String id = this.getWizardID();
        SimplePageGroup pageGroup = new SimplePageGroup(id, id);
        pageGroup.setPageHandler(this);
        return pageGroup;
    }

    protected IEnvironment createEnvironment() {
        return new EclipseEnvironment();
    }

    public void addPage(IWizardPage page) {
        this.rootPageGroup.addPage(page);
    }

    private void init() {
        this.rootPageGroup = this.createRootPageGroup();
        if (this.needsToRunOperationsBeforeFinish()) {
            this.rootOperation = this.getRootOperation();
            this.pageGroupManager = new PageGroupManager(this.rootOperation, (IDMPageGroup)this.rootPageGroup);
        } else {
            this.pageGroupManager = new PageGroupManager(this.getDataModel(), (IDMPageGroup)this.rootPageGroup);
        }
        this.pageExtensionManager = new PageExtensionManager(this);
    }

    protected boolean needsToRunOperationsBeforeFinish() {
        return false;
    }

    public boolean needsPreviousAndNextButtons() {
        return super.needsPreviousAndNextButtons() || this.getPageGroupManager().hasMultiplePages();
    }
}

