/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotStyledText;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class RawTextEditorTest {
    private static final RGB WHITE = new RGB(255, 255, 255);
    private static final RGB HIGHLIGHT_COLOR = new RGB(231, 246, 254);
    private static final String PROJECT_NAME = "Test";
    private static final String TRACE_TYPE_SYSLOG = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static final String TIMESTAMP_FORMAT = "MMM dd HH:mm:ss";
    private static final long INITIAL_NB_EVENTS = 100L;
    private static final long SECOND_TO_MILLISECOND = 1000L;
    private static final String TRACE_LOCATION = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator + "test.txt";
    private static SWTWorkbenchBot fBot;
    private long fNbWrittenEvents = 0L;

    @BeforeClass
    public static void init() {
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
    }

    @Before
    public void before() throws Exception {
        SWTBotUtils.createProject(PROJECT_NAME);
        SWTBotUtils.openTrace(PROJECT_NAME, this.createTrace(100L), this.getTraceType());
        WaitUtils.waitForJobs();
    }

    @After
    public void after() {
        SWTBotUtils.deleteProject(PROJECT_NAME, fBot);
    }

    @Test
    public void testRead() {
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        fBot.waitUntil((ICondition)new NumberOfEventsCondition(activeTrace, 100L));
        SWTBotEditor eventsEditor = SWTBotUtils.activeEventsEditor(fBot);
        eventsEditor.setFocus();
        Assert.assertFalse((eventsEditor.bot().table().rowCount() == 0 ? 1 : 0) != 0);
        eventsEditor.bot().table().select(new int[]{4});
        eventsEditor.bot().table().getTableItem(4).contextMenu("Show Raw").click();
        eventsEditor.bot().table().getTableItem(4).click();
        final SWTBotStyledText rawViewer = eventsEditor.bot().styledText();
        String selection = rawViewer.getText();
        Assert.assertEquals((Object)":03 HostF LoggerF: SourceFileF:9 Message F", (Object)selection.substring(12, 54));
        rawViewer.pressShortcut(new KeyStroke[]{Keystrokes.DOWN});
        DefaultCondition colorIsNotHighlight = new DefaultCondition(){

            public boolean test() throws Exception {
                return !HIGHLIGHT_COLOR.equals((Object)rawViewer.getLineBackground(0));
            }

            public String getFailureMessage() {
                return "Timed out";
            }
        };
        DefaultCondition colorIsHighlight = new DefaultCondition(){

            public boolean test() {
                return HIGHLIGHT_COLOR.equals((Object)rawViewer.getLineBackground(0));
            }

            public String getFailureMessage() {
                return "Timed out";
            }
        };
        fBot.waitUntil((ICondition)colorIsNotHighlight);
        Assert.assertEquals((String)"Non-highlighted color", (Object)WHITE, (Object)rawViewer.getLineBackground(0));
        Assert.assertEquals((String)"Highlighted color", (Object)HIGHLIGHT_COLOR, (Object)rawViewer.getLineBackground(1));
        rawViewer.pressShortcut(new KeyStroke[]{Keystrokes.UP});
        fBot.waitUntil((ICondition)colorIsHighlight);
        Assert.assertEquals((String)"Highlighted color", (Object)HIGHLIGHT_COLOR, (Object)rawViewer.getLineBackground(0));
        rawViewer.pressShortcut(new KeyStroke[]{Keystrokes.DOWN});
        fBot.waitUntil((ICondition)colorIsNotHighlight);
        Assert.assertEquals((String)"Non-highlighted color", (Object)WHITE, (Object)rawViewer.getLineBackground(0));
        Assert.assertEquals((String)"Highlighted color", (Object)HIGHLIGHT_COLOR, (Object)rawViewer.getLineBackground(1));
        rawViewer.pressShortcut(new KeyStroke[]{Keystrokes.PAGE_UP});
        fBot.waitUntil((ICondition)colorIsHighlight);
        Assert.assertEquals((String)"Highlighted color", (Object)HIGHLIGHT_COLOR, (Object)rawViewer.getLineBackground(0));
        rawViewer.pressShortcut(262144, 0x1000008, ' ');
        Assert.assertEquals((String)"Highlighted color", (Object)HIGHLIGHT_COLOR, (Object)rawViewer.getLineBackground(0));
        rawViewer.pressShortcut(new KeyStroke[]{Keystrokes.UP});
        rawViewer.pressShortcut(new KeyStroke[]{Keystrokes.PAGE_DOWN});
        fBot.waitUntil((ICondition)colorIsNotHighlight);
        Assert.assertEquals((String)"Non-highlighted color", (Object)WHITE, (Object)rawViewer.getLineBackground(0));
        Assert.assertEquals((String)"Highlighted color", (Object)HIGHLIGHT_COLOR, (Object)rawViewer.getLineBackground(1));
        rawViewer.pressShortcut(262144, 0x1000007, ' ');
        fBot.waitUntil((ICondition)colorIsHighlight);
        Assert.assertEquals((String)"Highlighted color", (Object)HIGHLIGHT_COLOR, (Object)rawViewer.getLineBackground(0));
        eventsEditor.bot().table().getTableItem(5).click();
        eventsEditor.bot().table().getTableItem(4).contextMenu("Hide Raw").click();
        Assert.assertFalse((boolean)rawViewer.isActive());
    }

    protected String createTrace(long nbEvents) throws Exception {
        this.writeToTrace(nbEvents, false);
        return TRACE_LOCATION;
    }

    private void writeToTrace(long nbEvents, boolean append) throws IOException {
        File file = new File(TRACE_LOCATION);
        Throwable throwable = null;
        Object var6_6 = null;
        try (FileWriter writer = new FileWriter(file, append);){
            int i = 0;
            while ((long)i < nbEvents) {
                this.writeEvent(writer);
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeEvent(FileWriter fw) throws IOException {
        SimpleDateFormat f = new SimpleDateFormat(TIMESTAMP_FORMAT);
        String timeStampStr = f.format(new Date(this.fNbWrittenEvents * 1000L));
        fw.write(String.valueOf(timeStampStr) + " HostF LoggerF: SourceFileF:9 Message F\n");
        ++this.fNbWrittenEvents;
    }

    protected String getTraceType() {
        return TRACE_TYPE_SYSLOG;
    }

    private static class NumberOfEventsCondition
    extends DefaultCondition {
        private ITmfTrace fTrace;
        private long fNbEvents;

        private NumberOfEventsCondition(ITmfTrace trace, long nbEvents) {
            this.fTrace = trace;
            this.fNbEvents = nbEvents;
        }

        public boolean test() throws Exception {
            return this.fTrace.getNbEvents() == this.fNbEvents;
        }

        public String getFailureMessage() {
            return String.valueOf(this.fTrace.getName()) + " did not contain the expected number of " + this.fNbEvents + " events. Current: " + this.fTrace.getNbEvents();
        }
    }
}

