/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.enumeration;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryIntegerParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryStringParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class EnumeratorParser
implements ICommonTreeParser {
    public static final EnumeratorParser INSTANCE = new EnumeratorParser();

    private EnumeratorParser() {
    }

    @Override
    public Long parse(ICTFMetadataNode enumerator, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        EnumDeclaration enumDeclaration = ((Param)param).fEnumDeclaration;
        List<ICTFMetadataNode> children = enumerator.getChildren();
        long low = 0L;
        long high = 0L;
        boolean valueSpecified = false;
        String label = null;
        for (ICTFMetadataNode child : children) {
            if (TsdlUtils.isAnyUnaryString(child)) {
                label = UnaryStringParser.INSTANCE.parse(child, null);
                continue;
            }
            if (CTFParser.tokenNames[96].equals(child.getType())) {
                valueSpecified = true;
                high = low = UnaryIntegerParser.INSTANCE.parse(child.getChild(0), null).longValue();
                continue;
            }
            if (CTFParser.tokenNames[97].equals(child.getType())) {
                valueSpecified = true;
                low = UnaryIntegerParser.INSTANCE.parse(child.getChild(0), null);
                high = UnaryIntegerParser.INSTANCE.parse(child.getChild(1), null);
                continue;
            }
            throw TsdlUtils.childTypeError(child);
        }
        if (low > high) {
            throw new ParseException("enum low value greater than high value");
        }
        if (valueSpecified && !enumDeclaration.add(low, high, label)) {
            Activator.log(2, "enum declarator values overlap. " + enumDeclaration.getLabels() + " and " + label);
        } else if (!valueSpecified && !enumDeclaration.add(label)) {
            throw new ParseException("enum cannot add element " + label);
        }
        IntegerDeclaration enumContainerType = enumDeclaration.getContainerType();
        if (valueSpecified && (BigInteger.valueOf(low).compareTo(enumContainerType.getMinValue()) < 0 || BigInteger.valueOf(high).compareTo(enumContainerType.getMaxValue()) > 0)) {
            throw new ParseException(String.format("enum value ( %d - %d ) is not in range ( %d - %d )", low, high, enumContainerType.getMinValue(), enumContainerType.getMinValue()));
        }
        return high;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final EnumDeclaration fEnumDeclaration;

        public Param(EnumDeclaration enumDeclaration) {
            this.fEnumDeclaration = enumDeclaration;
        }
    }
}

