/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.TmfCoreTracer;
import org.eclipse.tracecompass.internal.tmf.core.annotations.CustomOutputAnnotationProviderFactory;
import org.eclipse.tracecompass.internal.tmf.core.annotations.LostEventsOutputAnnotationProviderFactory;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceAdapterManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final @NonNull String PLUGIN_ID = "org.eclipse.tracecompass.tmf.core";
    private static Activator fPlugin;
    private static final LostEventsOutputAnnotationProviderFactory LOST_EVENTS_ANNOTATION_PROVIDER_FACTORY;
    private static final CustomOutputAnnotationProviderFactory CUSTOM_DEFINED_OUTPUT_ANNOTATION_PROVIDER_FACTORY;

    static {
        LOST_EVENTS_ANNOTATION_PROVIDER_FACTORY = new LostEventsOutputAnnotationProviderFactory();
        CUSTOM_DEFINED_OUTPUT_ANNOTATION_PROVIDER_FACTORY = new CustomOutputAnnotationProviderFactory();
    }

    public Activator() {
        Activator.setDefault(this);
    }

    public static Activator getDefault() {
        return fPlugin;
    }

    private static void setDefault(Activator plugin) {
        fPlugin = plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        System.setProperty("log4j.formatMsgNoLookups", "true");
        Activator.setDefault(this);
        TmfCoreTracer.init();
        TmfTraceManager.getInstance();
        TmfAnalysisManager.initialize();
        SymbolProviderManager.getInstance();
        DataProviderManager.getInstance();
        TmfTraceAdapterManager.registerFactory((IAdapterFactory)LOST_EVENTS_ANNOTATION_PROVIDER_FACTORY, ITmfTrace.class);
        TmfTraceAdapterManager.registerFactory((IAdapterFactory)CUSTOM_DEFINED_OUTPUT_ANNOTATION_PROVIDER_FACTORY, ITmfTrace.class);
    }

    public void stop(BundleContext context) throws Exception {
        TmfTraceAdapterManager.unregisterFactory(LOST_EVENTS_ANNOTATION_PROVIDER_FACTORY);
        TmfTraceAdapterManager.unregisterFactory(CUSTOM_DEFINED_OUTPUT_ANNOTATION_PROVIDER_FACTORY);
        LOST_EVENTS_ANNOTATION_PROVIDER_FACTORY.dispose();
        CUSTOM_DEFINED_OUTPUT_ANNOTATION_PROVIDER_FACTORY.dispose();
        TmfCoreTracer.stop();
        TmfTraceManager.getInstance().dispose();
        TmfAnalysisManager.dispose();
        SymbolProviderManager.dispose();
        DataProviderManager.dispose();
        TmfSignalManager.dispose();
        Activator.setDefault(null);
        super.stop(context);
    }

    public static void log(IStatus status) {
        fPlugin.getLog().log(status);
    }

    public static void logInfo(String message) {
        fPlugin.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void logInfo(String message, Throwable exception) {
        fPlugin.getLog().log((IStatus)new Status(1, PLUGIN_ID, message, exception));
    }

    public static void logWarning(String message) {
        fPlugin.getLog().log((IStatus)new Status(2, PLUGIN_ID, message));
    }

    public static void logWarning(String message, Throwable exception) {
        fPlugin.getLog().log((IStatus)new Status(2, PLUGIN_ID, message, exception));
    }

    public static void logError(String message) {
        fPlugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public static void logError(String message, Throwable exception) {
        fPlugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, exception));
    }
}

