/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.TreeMap;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetPreferencesGroup;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class ProjectFacetPreferences
implements Preferences {
    private static final String PATH_SEPARATOR = "/";
    private final ProjectFacetPreferencesGroup group;
    private final String facetId;
    private final IProjectFacet facet;
    private final IFacetedProject project;
    private final ProjectFacetPreferences parent;
    private final String name;
    private final String absolutePath;
    private final TreeMap<String, ProjectFacetPreferences> children;
    private final TreeMap<String, String> attributes;

    public ProjectFacetPreferences(ProjectFacetPreferencesGroup group, String facetId, IFacetedProject project) {
        this(group, facetId, ProjectFacetPreferences.toFacet(facetId), project, null, PATH_SEPARATOR);
    }

    public ProjectFacetPreferences(ProjectFacetPreferencesGroup group, String facetId, IProjectFacet facet, IFacetedProject project, ProjectFacetPreferences parent, String name) {
        this.group = group;
        this.facetId = facetId;
        this.facet = facet;
        this.project = project;
        this.parent = parent;
        this.name = name;
        this.absolutePath = this.parent == null ? name : String.valueOf(this.parent.absolutePath()) + PATH_SEPARATOR + name;
        this.children = new TreeMap();
        this.attributes = new TreeMap();
    }

    public String getProjectFacetId() {
        return this.facetId;
    }

    public IProjectFacet getProjectFacet() {
        return this.facet;
    }

    public IFacetedProject getFacetedProject() {
        return this.project;
    }

    public String name() {
        return this.name;
    }

    public String absolutePath() {
        return this.absolutePath;
    }

    public Preferences parent() {
        return this.parent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] childrenNames() {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            return this.children.keySet().toArray(new String[this.children.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences node(String path) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            return this.node(ProjectFacetPreferences.split(path), 0);
        }
    }

    private Preferences node(String[] path, int position) {
        String segment = path[position];
        ProjectFacetPreferences child = this.children.get(segment);
        if (child == null) {
            child = new ProjectFacetPreferences(this.group, this.facetId, this.facet, this.project, this, segment);
            this.children.put(segment, child);
        }
        if (position == path.length - 1) {
            return child;
        }
        return child.node(path, position + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodeExists(String path) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            return this.nodeExists(ProjectFacetPreferences.split(path), 0);
        }
    }

    private boolean nodeExists(String[] path, int position) {
        String segment = path[position];
        ProjectFacetPreferences child = this.children.get(segment);
        if (child == null) {
            return false;
        }
        if (position == path.length - 1) {
            return true;
        }
        return child.nodeExists(path, position + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode() throws BackingStoreException {
        if (this.parent == null) {
            this.group.removePreferences(this.facet);
        } else {
            ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
            synchronized (projectFacetPreferencesGroup) {
                this.parent.children.remove(this.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] keys() {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            return this.attributes.keySet().toArray(new String[this.attributes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key, String def) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            String value = this.attributes.get(key);
            if (value == null) {
                value = def;
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key, boolean def) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            String value = this.attributes.get(key);
            if (value == null) {
                return def;
            }
            return Boolean.parseBoolean(value);
        }
    }

    public byte[] getByteArray(String key, byte[] def) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String key, double def) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            String value = this.attributes.get(key);
            if (value == null) {
                return def;
            }
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                return def;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String key, float def) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            String value = this.attributes.get(key);
            if (value == null) {
                return def;
            }
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                return def;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key, int def) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            String value = this.attributes.get(key);
            if (value == null) {
                return def;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                return def;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key, long def) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            String value = this.attributes.get(key);
            if (value == null) {
                return def;
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                return def;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, String value) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            if (value == null) {
                this.attributes.remove(key);
            } else {
                this.attributes.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBoolean(String key, boolean value) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            this.attributes.put(key, String.valueOf(value));
        }
    }

    public void putByteArray(String key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDouble(String key, double value) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            this.attributes.put(key, String.valueOf(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFloat(String key, float value) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            this.attributes.put(key, String.valueOf(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putInt(String key, int value) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            this.attributes.put(key, String.valueOf(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLong(String key, long value) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            this.attributes.put(key, String.valueOf(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            this.attributes.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ProjectFacetPreferencesGroup projectFacetPreferencesGroup = this.group;
        synchronized (projectFacetPreferencesGroup) {
            this.attributes.clear();
        }
    }

    public void flush() throws BackingStoreException {
        this.group.save();
    }

    public void sync() throws BackingStoreException {
        this.flush();
    }

    private static String[] split(String path) {
        return path.split(PATH_SEPARATOR);
    }

    private static IProjectFacet toFacet(String facetId) {
        if (ProjectFacetsManager.isProjectFacetDefined(facetId)) {
            return ProjectFacetsManager.getProjectFacet(facetId);
        }
        return null;
    }
}

