/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.io.IOException;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.DocBaseBitSetIterator;
import org.apache.lucene.util.FixedBitSet;

final class DocIdsWriter {
    private static final byte CONTINUOUS_IDS = -2;
    private static final byte BITSET_IDS = -1;
    private static final byte DELTA_BPV_16 = 16;
    private static final byte BPV_24 = 24;
    private static final byte BPV_32 = 32;
    private static final byte LEGACY_DELTA_VINT = 0;
    private final int[] scratch;

    DocIdsWriter(int maxPointsInLeaf) {
        this.scratch = new int[maxPointsInLeaf];
    }

    void writeDocIds(int[] docIds, int start, int count, DataOutput out) throws IOException {
        block15: {
            int i;
            int max;
            block14: {
                int i2;
                boolean strictlySorted = true;
                int min = docIds[0];
                max = docIds[0];
                for (int i3 = 1; i3 < count; ++i3) {
                    int last = docIds[start + i3 - 1];
                    int current = docIds[start + i3];
                    if (last >= current) {
                        strictlySorted = false;
                    }
                    min = Math.min(min, current);
                    max = Math.max(max, current);
                }
                int min2max = max - min + 1;
                if (strictlySorted) {
                    if (min2max == count) {
                        out.writeByte((byte)-2);
                        out.writeVInt(docIds[start]);
                        return;
                    }
                    if (min2max <= count << 4) {
                        assert (min2max > count) : "min2max: " + min2max + ", count: " + count;
                        out.writeByte((byte)-1);
                        DocIdsWriter.writeIdsAsBitSet(docIds, start, count, out);
                        return;
                    }
                }
                if (min2max > 65535) break block14;
                out.writeByte((byte)16);
                for (i = 0; i < count; ++i) {
                    this.scratch[i] = docIds[start + i] - min;
                }
                out.writeVInt(min);
                int halfLen = count >>> 1;
                for (i2 = 0; i2 < halfLen; ++i2) {
                    this.scratch[i2] = this.scratch[halfLen + i2] | this.scratch[i2] << 16;
                }
                for (i2 = 0; i2 < halfLen; ++i2) {
                    out.writeInt(this.scratch[i2]);
                }
                if ((count & 1) != 1) break block15;
                out.writeShort((short)this.scratch[count - 1]);
                break block15;
            }
            if (max <= 0xFFFFFF) {
                out.writeByte((byte)24);
                for (i = 0; i < count - 7; i += 8) {
                    int doc1 = docIds[start + i];
                    int doc2 = docIds[start + i + 1];
                    int doc3 = docIds[start + i + 2];
                    int doc4 = docIds[start + i + 3];
                    int doc5 = docIds[start + i + 4];
                    int doc6 = docIds[start + i + 5];
                    int doc7 = docIds[start + i + 6];
                    int doc8 = docIds[start + i + 7];
                    long l1 = ((long)doc1 & 0xFFFFFFL) << 40 | ((long)doc2 & 0xFFFFFFL) << 16 | (long)(doc3 >>> 8) & 0xFFFFL;
                    long l2 = ((long)doc3 & 0xFFL) << 56 | ((long)doc4 & 0xFFFFFFL) << 32 | ((long)doc5 & 0xFFFFFFL) << 8 | (long)(doc6 >> 16) & 0xFFL;
                    long l3 = ((long)doc6 & 0xFFFFL) << 48 | ((long)doc7 & 0xFFFFFFL) << 24 | (long)doc8 & 0xFFFFFFL;
                    out.writeLong(l1);
                    out.writeLong(l2);
                    out.writeLong(l3);
                }
                while (i < count) {
                    out.writeShort((short)(docIds[start + i] >>> 8));
                    out.writeByte((byte)docIds[start + i]);
                    ++i;
                }
            } else {
                out.writeByte((byte)32);
                for (i = 0; i < count; ++i) {
                    out.writeInt(docIds[start + i]);
                }
            }
        }
    }

    private static void writeIdsAsBitSet(int[] docIds, int start, int count, DataOutput out) throws IOException {
        int min = docIds[start];
        int max = docIds[start + count - 1];
        int offsetWords = min >> 6;
        int offsetBits = offsetWords << 6;
        int totalWordCount = FixedBitSet.bits2words(max - offsetBits + 1);
        long currentWord = 0L;
        int currentWordIndex = 0;
        out.writeVInt(offsetWords);
        out.writeVInt(totalWordCount);
        for (int i = 0; i < count; ++i) {
            int index = docIds[start + i] - offsetBits;
            int nextWordIndex = index >> 6;
            assert (currentWordIndex <= nextWordIndex);
            if (currentWordIndex < nextWordIndex) {
                out.writeLong(currentWord);
                currentWord = 0L;
                ++currentWordIndex;
                while (currentWordIndex < nextWordIndex) {
                    ++currentWordIndex;
                    out.writeLong(0L);
                }
            }
            currentWord |= 1L << index;
        }
        out.writeLong(currentWord);
        assert (currentWordIndex + 1 == totalWordCount);
    }

    void readInts(IndexInput in, int count, int[] docIDs) throws IOException {
        byte bpv = in.readByte();
        switch (bpv) {
            case -2: {
                DocIdsWriter.readContinuousIds(in, count, docIDs);
                break;
            }
            case -1: {
                DocIdsWriter.readBitSet(in, count, docIDs);
                break;
            }
            case 16: {
                DocIdsWriter.readDelta16(in, count, docIDs);
                break;
            }
            case 24: {
                DocIdsWriter.readInts24(in, count, docIDs);
                break;
            }
            case 32: {
                DocIdsWriter.readInts32(in, count, docIDs);
                break;
            }
            case 0: {
                DocIdsWriter.readLegacyDeltaVInts(in, count, docIDs);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + bpv);
            }
        }
    }

    private static DocIdSetIterator readBitSetIterator(IndexInput in, int count) throws IOException {
        int offsetWords = in.readVInt();
        int longLen = in.readVInt();
        long[] bits = new long[longLen];
        in.readLongs(bits, 0, longLen);
        FixedBitSet bitSet = new FixedBitSet(bits, longLen << 6);
        return new DocBaseBitSetIterator(bitSet, count, offsetWords << 6);
    }

    private static void readContinuousIds(IndexInput in, int count, int[] docIDs) throws IOException {
        int start = in.readVInt();
        for (int i = 0; i < count; ++i) {
            docIDs[i] = start + i;
        }
    }

    private static void readLegacyDeltaVInts(IndexInput in, int count, int[] docIDs) throws IOException {
        int doc = 0;
        for (int i = 0; i < count; ++i) {
            docIDs[i] = doc += in.readVInt();
        }
    }

    private static void readBitSet(IndexInput in, int count, int[] docIDs) throws IOException {
        int docId;
        DocIdSetIterator iterator = DocIdsWriter.readBitSetIterator(in, count);
        int pos = 0;
        while ((docId = iterator.nextDoc()) != Integer.MAX_VALUE) {
            docIDs[pos++] = docId;
        }
        assert (pos == count) : "pos: " + pos + "count: " + count;
    }

    private static void readDelta16(IndexInput in, int count, int[] docIDs) throws IOException {
        int min = in.readVInt();
        int halfLen = count >>> 1;
        in.readInts(docIDs, 0, halfLen);
        for (int i = 0; i < halfLen; ++i) {
            int l = docIDs[i];
            docIDs[i] = (l >>> 16) + min;
            docIDs[halfLen + i] = (l & 0xFFFF) + min;
        }
        if ((count & 1) == 1) {
            docIDs[count - 1] = Short.toUnsignedInt(in.readShort()) + min;
        }
    }

    private static void readInts24(IndexInput in, int count, int[] docIDs) throws IOException {
        int i;
        for (i = 0; i < count - 7; i += 8) {
            long l1 = in.readLong();
            long l2 = in.readLong();
            long l3 = in.readLong();
            docIDs[i] = (int)(l1 >>> 40);
            docIDs[i + 1] = (int)(l1 >>> 16) & 0xFFFFFF;
            docIDs[i + 2] = (int)((l1 & 0xFFFFL) << 8 | l2 >>> 56);
            docIDs[i + 3] = (int)(l2 >>> 32) & 0xFFFFFF;
            docIDs[i + 4] = (int)(l2 >>> 8) & 0xFFFFFF;
            docIDs[i + 5] = (int)((l2 & 0xFFL) << 16 | l3 >>> 48);
            docIDs[i + 6] = (int)(l3 >>> 24) & 0xFFFFFF;
            docIDs[i + 7] = (int)l3 & 0xFFFFFF;
        }
        while (i < count) {
            docIDs[i] = Short.toUnsignedInt(in.readShort()) << 8 | Byte.toUnsignedInt(in.readByte());
            ++i;
        }
    }

    private static void readInts32(IndexInput in, int count, int[] docIDs) throws IOException {
        in.readInts(docIDs, 0, count);
    }

    void readInts(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        byte bpv = in.readByte();
        switch (bpv) {
            case -2: {
                DocIdsWriter.readContinuousIds(in, count, visitor);
                break;
            }
            case -1: {
                DocIdsWriter.readBitSet(in, count, visitor);
                break;
            }
            case 16: {
                this.readDelta16(in, count, visitor);
                break;
            }
            case 24: {
                DocIdsWriter.readInts24(in, count, visitor);
                break;
            }
            case 32: {
                this.readInts32(in, count, visitor);
                break;
            }
            case 0: {
                DocIdsWriter.readLegacyDeltaVInts(in, count, visitor);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + bpv);
            }
        }
    }

    private static void readBitSet(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        DocIdSetIterator bitSetIterator = DocIdsWriter.readBitSetIterator(in, count);
        visitor.visit(bitSetIterator);
    }

    private static void readContinuousIds(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        int start = in.readVInt();
        int extra = start & 0x3F;
        int offset = start - extra;
        int numBits = count + extra;
        FixedBitSet bitSet = new FixedBitSet(numBits);
        bitSet.set(extra, numBits);
        visitor.visit(new DocBaseBitSetIterator(bitSet, count, offset));
    }

    private static void readLegacyDeltaVInts(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        int doc = 0;
        for (int i = 0; i < count; ++i) {
            visitor.visit(doc += in.readVInt());
        }
    }

    private void readDelta16(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        DocIdsWriter.readDelta16(in, count, this.scratch);
        for (int i = 0; i < count; ++i) {
            visitor.visit(this.scratch[i]);
        }
    }

    private static void readInts24(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        int i;
        for (i = 0; i < count - 7; i += 8) {
            long l1 = in.readLong();
            long l2 = in.readLong();
            long l3 = in.readLong();
            visitor.visit((int)(l1 >>> 40));
            visitor.visit((int)(l1 >>> 16) & 0xFFFFFF);
            visitor.visit((int)((l1 & 0xFFFFL) << 8 | l2 >>> 56));
            visitor.visit((int)(l2 >>> 32) & 0xFFFFFF);
            visitor.visit((int)(l2 >>> 8) & 0xFFFFFF);
            visitor.visit((int)((l2 & 0xFFL) << 16 | l3 >>> 48));
            visitor.visit((int)(l3 >>> 24) & 0xFFFFFF);
            visitor.visit((int)l3 & 0xFFFFFF);
        }
        while (i < count) {
            visitor.visit(Short.toUnsignedInt(in.readShort()) << 8 | Byte.toUnsignedInt(in.readByte()));
            ++i;
        }
    }

    private void readInts32(IndexInput in, int count, PointValues.IntersectVisitor visitor) throws IOException {
        in.readInts(this.scratch, 0, count);
        for (int i = 0; i < count; ++i) {
            visitor.visit(this.scratch[i]);
        }
    }
}

