/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.statistics;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.statistics.NumberComparator;
import org.junit.Assert;
import org.junit.Test;

public class NumberComparatorTest {
    private static NumberComparator COMPARATOR = new NumberComparator();

    @Test
    public void longTest() {
        Long negInf = Long.MIN_VALUE;
        Long posInf = Long.MAX_VALUE;
        Long zero = 0L;
        Long one = 1L;
        NumberComparatorTest.runTests(negInf, posInf, zero, one);
    }

    @Test
    public void intTest() {
        Integer negInf = Integer.MIN_VALUE;
        Integer posInf = Integer.MAX_VALUE;
        Integer zero = 0;
        Integer one = 1;
        NumberComparatorTest.runTests(negInf, posInf, zero, one);
    }

    @Test
    public void doubleTest() {
        Double negInf = Double.MIN_VALUE;
        Double posInf = Double.MAX_VALUE;
        Double zero = 0.0;
        Double one = 1.0;
        NumberComparatorTest.runTests(negInf, posInf, zero, one);
    }

    @Test
    public void floatTest() {
        Float negInf = Float.valueOf(Float.MIN_VALUE);
        Float posInf = Float.valueOf(Float.MAX_VALUE);
        Float zero = Float.valueOf(0.0f);
        Float one = Float.valueOf(1.0f);
        NumberComparatorTest.runTests(negInf, posInf, zero, one);
    }

    @Test
    public void shortTest() {
        Short negInf = Short.MIN_VALUE;
        Short posInf = Short.MAX_VALUE;
        Short zero = 0;
        Short one = 1;
        NumberComparatorTest.runTests(negInf, posInf, zero, one);
    }

    @Test
    public void byteTest() {
        Byte negInf = -128;
        Byte posInf = 127;
        Byte zero = 0;
        Byte one = 1;
        NumberComparatorTest.runTests(negInf, posInf, zero, one);
    }

    @Test
    public void bigIntTest() {
        BigInteger negInf = new BigInteger("-10000000000000000000000000000");
        BigInteger posInf = new BigInteger("10000000000000000000000000000");
        BigInteger zero = BigInteger.ZERO;
        BigInteger one = BigInteger.ONE;
        NumberComparatorTest.runTests(negInf, posInf, zero, one);
    }

    @Test
    public void bigDecTest() {
        BigDecimal negInf = new BigDecimal("-10000000000000000000000000000");
        BigDecimal posInf = new BigDecimal("10000000000000000000000000000");
        BigDecimal zero = BigDecimal.ZERO;
        BigDecimal one = BigDecimal.ONE;
        NumberComparatorTest.runTests(negInf, posInf, zero, one);
    }

    @Test(expected=IllegalArgumentException.class)
    public void failLITest() {
        NumberComparatorTest.assertComparison(0, 0, 0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void failILTest() {
        NumberComparatorTest.assertComparison(0, 0L, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void failDFTest() {
        NumberComparatorTest.assertComparison(0, 0.0, Float.valueOf(0.0f));
    }

    @Test(expected=IllegalArgumentException.class)
    public void failFDTest() {
        NumberComparatorTest.assertComparison(0, Float.valueOf(0.0f), 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void failSBTest() {
        NumberComparatorTest.assertComparison(0, (short)0, (byte)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void failBSTest() {
        NumberComparatorTest.assertComparison(0, (byte)0, (short)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void failBiBdTest() {
        NumberComparatorTest.assertComparison(0, BigInteger.ZERO, BigDecimal.ZERO);
    }

    @Test(expected=IllegalArgumentException.class)
    public void failBdBiTest() {
        NumberComparatorTest.assertComparison(0, BigDecimal.ZERO, BigInteger.ZERO);
    }

    private static void runTests(Number negInf, Number posInf, Number zero, Number one) {
        NumberComparatorTest.assertComparison(0, negInf, negInf);
        NumberComparatorTest.assertComparison(0, posInf, posInf);
        NumberComparatorTest.assertComparison(0, zero, zero);
        NumberComparatorTest.assertComparison(0, one, one);
        NumberComparatorTest.assertComparison(1, posInf, negInf);
        NumberComparatorTest.assertComparison(-1, negInf, posInf);
        NumberComparatorTest.assertComparison(1, one, zero);
        NumberComparatorTest.assertComparison(-1, zero, one);
    }

    private static void assertComparison(int expected, Number left, Number right) {
        int actual = COMPARATOR.compare(left, right);
        if (expected < 0) {
            Assert.assertTrue((String)("Number " + left + " expected to be smaller than " + right), (actual < 0 ? 1 : 0) != 0);
        } else if (expected > 0) {
            Assert.assertTrue((String)("Number " + left + " expected to be larger than " + right), (actual > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)("Number " + left + " expected to be equal to " + right), (long)0L, (long)actual);
        }
    }
}

