/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.tracecompass.internal.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.junit.Assert;
import org.junit.Test;

public class TmfNanoTimestampTest {
    private final ITmfTimestamp ts0 = new TmfNanoTimestamp(0L);
    private final ITmfTimestamp ts1 = new TmfNanoTimestamp(12345L);
    private final ITmfTimestamp ts2 = new TmfNanoTimestamp(-1234L);

    @Test
    public void testDefaultConstructor() {
        Assert.assertEquals((String)"getValue", (long)0L, (long)this.ts0.getValue());
        Assert.assertEquals((String)"getscale", (long)-9L, (long)this.ts0.getScale());
    }

    @Test
    public void testFullConstructor() {
        Assert.assertEquals((String)"getValue", (long)12345L, (long)this.ts1.getValue());
        Assert.assertEquals((String)"getscale", (long)-9L, (long)this.ts1.getScale());
    }

    @Test
    public void testCopyConstructor() {
        long copy = this.ts1.toNanos();
        Assert.assertEquals((String)"getValue", (long)this.ts1.getValue(), (long)copy);
        Assert.assertEquals((String)"getscale", (long)this.ts1.getScale(), (long)-9L);
        Assert.assertEquals((String)"getValue", (long)12345L, (long)copy);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(this.ts0));
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(this.ts1));
        Assert.assertTrue((String)"equals", (boolean)this.ts2.equals(this.ts2));
        Assert.assertTrue((String)"equals", (!this.ts0.equals(this.ts1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts0.equals(this.ts2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts1.equals(this.ts0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts1.equals(this.ts2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts2.equals(this.ts0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts2.equals(this.ts1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        ITmfTimestamp ts0copy = TmfTimestamp.fromNanos((long)this.ts0.toNanos());
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(ts0copy));
        Assert.assertTrue((String)"equals", (boolean)ts0copy.equals(this.ts0));
        ITmfTimestamp ts1copy = TmfTimestamp.fromNanos((long)this.ts1.toNanos());
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(ts1copy));
        Assert.assertTrue((String)"equals", (boolean)ts1copy.equals(this.ts1));
    }

    @Test
    public void testEqualsTransivity() {
        ITmfTimestamp ts0copy1 = TmfTimestamp.fromNanos((long)this.ts0.toNanos());
        ITmfTimestamp ts0copy2 = TmfTimestamp.fromNanos((long)ts0copy1.toNanos());
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(ts0copy1));
        Assert.assertTrue((String)"equals", (boolean)ts0copy1.equals(ts0copy2));
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(ts0copy2));
        ITmfTimestamp ts1copy1 = TmfTimestamp.fromNanos((long)this.ts1.toNanos());
        ITmfTimestamp ts1copy2 = TmfTimestamp.fromNanos((long)ts1copy1.toNanos());
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(ts1copy1));
        Assert.assertTrue((String)"equals", (boolean)ts1copy1.equals(ts1copy2));
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(ts1copy2));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.ts0.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsNonTimestamp() {
        Assert.assertFalse((String)"equals", (boolean)this.ts0.equals(this.ts0.toString()));
    }

    @Test
    public void testToString() {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
        Date d0 = new Date(this.ts0.getValue() / 1000000L);
        Date d1 = new Date(this.ts1.getValue() / 1000000L);
        Date d2 = new Date(this.ts2.getValue() / 1000000L - 1L);
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d0)) + " 000 000"), (Object)this.ts0.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d1)) + " 012 345"), (Object)this.ts1.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d2)) + " 998 766"), (Object)this.ts2.toString());
    }

    @Test
    public void testHashCode() {
        ITmfTimestamp ts0copy = TmfTimestamp.create((long)this.ts0.getValue(), (int)this.ts0.getScale());
        ITmfTimestamp ts1copy = TmfTimestamp.create((long)this.ts1.getValue(), (int)this.ts1.getScale());
        ITmfTimestamp ts2copy = TmfTimestamp.create((long)this.ts2.getValue(), (int)this.ts2.getScale());
        Assert.assertEquals((String)"hashCode", (long)this.ts0.hashCode(), (long)ts0copy.hashCode());
        Assert.assertEquals((String)"hashCode", (long)this.ts1.hashCode(), (long)ts1copy.hashCode());
        Assert.assertEquals((String)"hashCode", (long)this.ts2.hashCode(), (long)ts2copy.hashCode());
        Assert.assertTrue((String)"hashCode", (this.ts0.hashCode() != this.ts1.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testNormalizeScale0() {
        ITmfTimestamp ts = this.ts0.normalize(0L, 0);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(12345L, 0);
        Assert.assertEquals((String)"getValue", (long)12345L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(10L, 0);
        Assert.assertEquals((String)"getValue", (long)10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(-10L, 0);
        Assert.assertEquals((String)"getValue", (long)-10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeScaleNot0() {
        ITmfTimestamp ts = this.ts0.normalize(0L, 1);
        Assert.assertEquals((String)"Zero", (Object)TmfTimestamp.ZERO, (Object)ts);
        ts = this.ts0.normalize(12345L, 1);
        Assert.assertEquals((String)"getValue", (long)12345L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)1L, (long)ts.getScale());
        ts = this.ts0.normalize(10L, 1);
        Assert.assertEquals((String)"getValue", (long)10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)1L, (long)ts.getScale());
        ts = this.ts0.normalize(-10L, 1);
        Assert.assertEquals((String)"getValue", (long)-10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)1L, (long)ts.getScale());
    }

    @Test
    public void testBasicCompareTo() {
        ITmfTimestamp tstamp1 = TmfTimestamp.fromNanos((long)900L);
        ITmfTimestamp tstamp2 = TmfTimestamp.fromNanos((long)1000L);
        ITmfTimestamp tstamp3 = TmfTimestamp.fromNanos((long)1100L);
        Assert.assertTrue((tstamp1.compareTo(tstamp1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (tstamp1.compareTo(tstamp2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (tstamp1.compareTo(tstamp3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (tstamp2.compareTo(tstamp1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (tstamp2.compareTo(tstamp3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (tstamp3.compareTo(tstamp1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (tstamp3.compareTo(tstamp2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareTo() {
        ITmfTimestamp ts0a = TmfTimestamp.create((long)0L, (int)2);
        ITmfTimestamp ts1a = TmfTimestamp.create((long)123450L, (int)-10);
        ITmfTimestamp ts2a = TmfTimestamp.create((long)-12340L, (int)-10);
        Assert.assertTrue((this.ts1.compareTo(this.ts1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts0.compareTo(ts0a) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts1.compareTo(ts1a) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts2.compareTo(ts2a) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDelta() {
        ITmfTimestamp tstamp0 = TmfTimestamp.fromNanos((long)10L);
        ITmfTimestamp tstamp1 = TmfTimestamp.fromNanos((long)5L);
        ITmfTimestamp expectd = TmfTimestamp.fromNanos((long)5L);
        ITmfTimestamp delta = tstamp0.getDelta(tstamp1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo(expectd));
        tstamp0 = TmfTimestamp.fromSeconds((long)5L);
        tstamp1 = TmfTimestamp.fromSeconds((long)10L);
        expectd = TmfTimestamp.fromSeconds((long)-5L);
        delta = tstamp0.getDelta(tstamp1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo(expectd));
    }

    @Test
    public void testDelta2() {
        ITmfTimestamp tstamp0 = TmfTimestamp.fromNanos((long)10L);
        ITmfTimestamp tstamp1 = TmfTimestamp.create((long)1L, (int)-8);
        ITmfTimestamp expectd = TmfTimestamp.create((long)0L, (int)0);
        ITmfTimestamp delta = tstamp0.getDelta(tstamp1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo(expectd));
    }
}

