/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.model;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfStateValueScenarioTest {
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace4.xml";
    ITmfTrace fTrace;
    XmlPatternAnalysis fModule;

    @Before
    public void setUp() throws TmfAnalysisException {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
        XmlPatternAnalysis module = XmlUtilsTest.initializePatternModule(TmfXmlTestFiles.STATE_VALUE_PATTERN_FILE);
        module.setTrace(trace);
        module.schedule();
        module.waitForCompletion();
        this.fTrace = trace;
        this.fModule = module;
    }

    @After
    public void cleanUp() {
        this.fTrace.dispose();
        this.fModule.dispose();
    }

    @Test
    public void testAttributePool() throws AttributeNotFoundException, StateSystemDisposedException {
        XmlPatternAnalysis module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem(module.getId());
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"Operations"});
        List subAttributes = ss.getSubAttributes(quark, false);
        Assert.assertEquals((String)"Number of attribute pool children", (long)2L, (long)subAttributes.size());
        int[] expectedStarts = new int[]{1, 2, 3, 5, 7, 10, 14, 20, 20};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueString((String)"op1"), TmfStateValue.newValueString((String)"op2"), TmfStateValue.nullValue(), TmfStateValue.newValueString((String)"op1"), TmfStateValue.nullValue(), TmfStateValue.newValueString((String)"op1"), TmfStateValue.newValueString((String)"op2"), TmfStateValue.nullValue()};
        XmlUtilsTest.verifyStateIntervals("testAttributePool", ss, (Integer)subAttributes.get(0), expectedStarts, expectedValues);
        int[] expectedStarts2 = new int[]{1, 2, 3, 4, 20};
        ITmfStateValue[] expectedValues2 = new ITmfStateValue[]{TmfStateValue.nullValue(), TmfStateValue.newValueString((String)"op1"), TmfStateValue.newValueString((String)"op2"), TmfStateValue.nullValue()};
        XmlUtilsTest.verifyStateIntervals("testAttributePool", ss, (Integer)subAttributes.get(1), expectedStarts2, expectedValues2);
    }
}

