/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.event;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CTFEventDefinitionTest {
    List<EventDefinition> fixture;

    @Before
    public void init() {
        this.fixture = new ArrayList<EventDefinition>();
        IntegerDeclaration pidDec = IntegerDeclaration.createDeclaration((int)5, (boolean)false, (int)10, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)8L);
        IntegerDeclaration ctxDec = IntegerDeclaration.createDeclaration((int)16, (boolean)false, (int)10, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)8L);
        IntegerDefinition pid = new IntegerDefinition(pidDec, null, "pid", 3L);
        IntegerDefinition pod = new IntegerDefinition(pidDec, null, "pod", 3L);
        IntegerDefinition ctx = new IntegerDefinition(pidDec, null, "ctx", 3L);
        StructDeclaration streamContextDec = new StructDeclaration(8L);
        streamContextDec.addField("pid", (IDeclaration)pidDec);
        streamContextDec.addField("ctx", (IDeclaration)ctxDec);
        StructDeclaration eventContextDec = new StructDeclaration(8L);
        eventContextDec.addField("pod", (IDeclaration)pidDec);
        eventContextDec.addField("ctx", (IDeclaration)pidDec);
        StructDeclaration fDec = new StructDeclaration(8L);
        EventDeclaration eventDeclaration = new EventDeclaration();
        fDec.addField("pid", (IDeclaration)pidDec);
        fDec.addField("ctx", (IDeclaration)ctxDec);
        fDec.addField("pod", (IDeclaration)pidDec);
        Definition[] sDefs = new Definition[]{pid, ctx};
        Definition[] eDefs = new Definition[]{pod, ctx};
        Definition[] fDefs = new Definition[]{pid, ctx, pod};
        StructDeclaration pContextDec = new StructDeclaration(8L);
        StructDefinition sContext = new StructDefinition(streamContextDec, null, ILexicalScope.STREAM_PACKET_CONTEXT.getPath(), sDefs);
        StructDefinition eContext = new StructDefinition(eventContextDec, null, ILexicalScope.STREAM_EVENT_CONTEXT.getPath(), eDefs);
        StructDefinition pContext = new StructDefinition(pContextDec, null, ILexicalScope.FIELDS.getPath(), new Definition[0]);
        StructDefinition fields = new StructDefinition(fDec, null, ILexicalScope.FIELDS.getPath(), fDefs);
        int cpu = -1;
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, null, null, null, null, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, null, null, null, (ICompositeDefinition)fields, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, null, null, (ICompositeDefinition)pContext, null, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, null, null, (ICompositeDefinition)pContext, (ICompositeDefinition)fields, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, null, (ICompositeDefinition)eContext, null, null, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, null, (ICompositeDefinition)eContext, null, (ICompositeDefinition)fields, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, null, (ICompositeDefinition)eContext, (ICompositeDefinition)pContext, null, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, null, (ICompositeDefinition)eContext, (ICompositeDefinition)pContext, (ICompositeDefinition)fields, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, (ICompositeDefinition)sContext, null, null, null, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, (ICompositeDefinition)sContext, null, null, (ICompositeDefinition)fields, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, (ICompositeDefinition)sContext, null, (ICompositeDefinition)pContext, null, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, (ICompositeDefinition)sContext, null, (ICompositeDefinition)pContext, (ICompositeDefinition)fields, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, (ICompositeDefinition)sContext, (ICompositeDefinition)eContext, null, null, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, (ICompositeDefinition)sContext, (ICompositeDefinition)eContext, null, (ICompositeDefinition)fields, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, (ICompositeDefinition)sContext, (ICompositeDefinition)eContext, (ICompositeDefinition)pContext, null, null));
        this.fixture.add(new EventDefinition((IEventDeclaration)eventDeclaration, cpu, 100L, null, (ICompositeDefinition)sContext, (ICompositeDefinition)eContext, (ICompositeDefinition)pContext, (ICompositeDefinition)fields, null));
    }

    @Test
    public void testEvents() {
        int i = 0;
        for (EventDefinition ed : this.fixture) {
            CTFEventDefinitionTest.test(i, ed);
            ++i;
        }
    }

    private static void test(int rank, EventDefinition ed) {
        String title = "event #" + rank;
        Assert.assertEquals((String)title, (long)100L, (long)ed.getTimestamp());
        ICompositeDefinition context = ed.getContext();
        if (rank >= 4) {
            Assert.assertNotNull((String)title, (Object)context);
            if (rank >= 12) {
                Assert.assertEquals((String)title, (long)3L, (long)context.getFieldNames().size());
            } else {
                Assert.assertEquals((String)title, (long)2L, (long)context.getFieldNames().size());
            }
        } else {
            Assert.assertNull((String)title, (Object)context);
        }
        if (rank / 4 % 2 == 1) {
            Assert.assertNotNull((String)title, (Object)ed.getEventContext());
        } else {
            Assert.assertNull((String)title, (Object)ed.getEventContext());
        }
        if (rank % 2 == 1) {
            Assert.assertNotNull((String)title, (Object)ed.getFields());
            Assert.assertEquals((String)title, (long)3L, (long)ed.getFields().getFieldNames().size());
        } else {
            Assert.assertNull((String)title, (Object)ed.getFields());
        }
        Assert.assertTrue((String)title, (boolean)ed.toString().startsWith("Event type: null" + System.getProperty("line.separator") + "Timestamp: 100"));
    }
}

