/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.sat4j.core.ASolverFactory;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Counter;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.specs.UnitClauseProvider;
import org.sat4j.specs.UnitPropagationListener;
import org.sat4j.tools.OutcomeListener;
import org.sat4j.tools.RunnableSolver;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyCore<S extends ISolver>
extends SearchListenerAdapter<ISolverService>
implements ISolver,
OutcomeListener,
UnitClauseProvider {
    private static final int NORMAL_SLEEP = 500;
    private static final int FAST_SLEEP = 50;
    private static final long serialVersionUID = 1L;
    private final String[] availableSolvers;
    protected final List<S> solvers;
    protected final int numberOfSolvers;
    private int winnerId;
    private boolean resultFound;
    private AtomicInteger remainingSolvers;
    private volatile int sleepTime;
    private volatile boolean solved;
    private final IVecInt sharedUnitClauses = new VecInt();
    private final IVec<Counter> solversStats = new Vec<Counter>();

    public ManyCore(ASolverFactory<S> factory, String ... solverNames) {
        this.availableSolvers = solverNames;
        this.numberOfSolvers = solverNames.length;
        this.solvers = new ArrayList<S>(this.numberOfSolvers);
        int i = 0;
        while (i < this.numberOfSolvers) {
            ISolverService solver = factory.createSolverByName(this.availableSolvers[i]);
            solver.setSearchListener(this);
            solver.setUnitClauseProvider(this);
            this.solvers.add(solver);
            this.solversStats.push(new Counter(0));
            ++i;
        }
    }

    public ManyCore(String[] names, S ... solverObjects) {
        this((ISolver[])solverObjects);
        int i = 0;
        while (i < names.length) {
            this.availableSolvers[i] = names[i];
            ++i;
        }
    }

    public ManyCore(S ... solverObjects) {
        this.availableSolvers = new String[solverObjects.length];
        int i = 0;
        while (i < solverObjects.length) {
            this.availableSolvers[i] = "solver" + i;
            ++i;
        }
        this.numberOfSolvers = solverObjects.length;
        this.solvers = new ArrayList<S>(this.numberOfSolvers);
        i = 0;
        while (i < this.numberOfSolvers) {
            this.solvers.add(solverObjects[i]);
            solverObjects[i].setSearchListener(this);
            solverObjects[i].setUnitClauseProvider(this);
            this.solversStats.push(new Counter(0));
            ++i;
        }
    }

    @Override
    public void addAllClauses(IVec<IVecInt> clauses) throws ContradictionException {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).addAllClauses(clauses);
            ++i;
        }
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        ConstrGroup group = new ConstrGroup(false);
        int i = 0;
        while (i < this.numberOfSolvers) {
            group.add(((ISolver)this.solvers.get(i)).addAtLeast(literals, degree));
            ++i;
        }
        return group;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        ConstrGroup group = new ConstrGroup(false);
        int i = 0;
        while (i < this.numberOfSolvers) {
            group.add(((ISolver)this.solvers.get(i)).addAtMost(literals, degree));
            ++i;
        }
        return group;
    }

    @Override
    public IConstr addExactly(IVecInt literals, int n) throws ContradictionException {
        ConstrGroup group = new ConstrGroup(false);
        int i = 0;
        while (i < this.numberOfSolvers) {
            group.add(((ISolver)this.solvers.get(i)).addExactly(literals, n));
            ++i;
        }
        return group;
    }

    @Override
    public IConstr addClause(IVecInt literals) throws ContradictionException {
        ConstrGroup group = new ConstrGroup(false);
        int i = 0;
        while (i < this.numberOfSolvers) {
            group.add(((ISolver)this.solvers.get(i)).addClause(literals));
            ++i;
        }
        return group;
    }

    @Override
    public void clearLearntClauses() {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).clearLearntClauses();
            ++i;
        }
    }

    @Override
    public void expireTimeout() {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).expireTimeout();
            ++i;
        }
        this.sleepTime = 50;
    }

    @Override
    public Map<String, Number> getStat() {
        return ((ISolver)this.solvers.get(this.winnerId)).getStat();
    }

    @Override
    public int getTimeout() {
        return ((ISolver)this.solvers.get(0)).getTimeout();
    }

    @Override
    public long getTimeoutMs() {
        return ((ISolver)this.solvers.get(0)).getTimeoutMs();
    }

    @Override
    public int newVar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int newVar(int howmany) {
        int result = 0;
        int i = 0;
        while (i < this.numberOfSolvers) {
            result = ((ISolver)this.solvers.get(i)).newVar(howmany);
            ++i;
        }
        return result;
    }

    @Override
    @Deprecated
    public void printStat(PrintStream out, String prefix) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            out.printf("%s>>>>>>>>>> Solver number %d (%d answers) <<<<<<<<<<<<<<<<<<%n", prefix, i, this.solversStats.get(i).getValue());
            ((ISolver)this.solvers.get(i)).printStat(out, prefix);
            ++i;
        }
    }

    @Override
    public void printStat(PrintWriter out, String prefix) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            out.printf("%s>>>>>>>>>> Solver number %d (%d answers) <<<<<<<<<<<<<<<<<<%n", prefix, i, this.solversStats.get(i).getValue());
            ((ISolver)this.solvers.get(i)).printStat(out, prefix);
            ++i;
        }
    }

    @Override
    public boolean removeConstr(IConstr c) {
        if (c instanceof ConstrGroup) {
            ConstrGroup group = (ConstrGroup)c;
            boolean removed = true;
            int i = 0;
            while (i < this.numberOfSolvers) {
                IConstr toRemove = group.getConstr(i);
                if (toRemove != null) {
                    removed &= ((ISolver)this.solvers.get(i)).removeConstr(toRemove);
                }
                ++i;
            }
            return removed;
        }
        throw new IllegalArgumentException("Can only remove a group of constraints!");
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).reset();
            ++i;
        }
        this.sharedUnitClauses.clear();
    }

    @Override
    public void setExpectedNumberOfClauses(int nb) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).setExpectedNumberOfClauses(nb);
            ++i;
        }
    }

    @Override
    public void setTimeout(int t) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).setTimeout(t);
            ++i;
        }
    }

    @Override
    public void setTimeoutMs(long t) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).setTimeoutMs(t);
            ++i;
        }
    }

    @Override
    public void setTimeoutOnConflicts(int count) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).setTimeoutOnConflicts(count);
            ++i;
        }
    }

    @Override
    public String toString(String prefix) {
        StringBuffer res = new StringBuffer();
        res.append(prefix);
        res.append("ManyCore solver with ");
        res.append(this.numberOfSolvers);
        res.append(" solvers running in parallel");
        res.append("\n");
        int i = 0;
        while (i < this.numberOfSolvers) {
            res.append(prefix);
            res.append(">>>>>>>>>> Solver number ");
            res.append(i);
            res.append(" <<<<<<<<<<<<<<<<<<\n");
            res.append(((ISolver)this.solvers.get(i)).toString(prefix));
            if (i < this.numberOfSolvers - 1) {
                res.append("\n");
            }
            ++i;
        }
        return res.toString();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        if (this.isSatisfiable()) {
            return this.model();
        }
        return null;
    }

    @Override
    public int[] findModel(IVecInt assumps) throws TimeoutException {
        if (this.isSatisfiable(assumps)) {
            return this.model();
        }
        return null;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, false);
    }

    @Override
    public synchronized boolean isSatisfiable(IVecInt assumps, boolean globalTimeout) throws TimeoutException {
        this.remainingSolvers = new AtomicInteger(this.numberOfSolvers);
        this.solved = false;
        int i = 0;
        while (i < this.numberOfSolvers) {
            new Thread(new RunnableSolver(i, (ISolver)this.solvers.get(i), assumps, globalTimeout, this)).start();
            ++i;
        }
        try {
            this.sleepTime = 500;
            do {
                this.wait(this.sleepTime);
            } while (this.remainingSolvers.get() > 0);
        }
        catch (InterruptedException interruptedException) {}
        if (!this.solved) {
            assert (this.remainingSolvers.get() == 0);
            throw new TimeoutException();
        }
        return this.resultFound;
    }

    @Override
    public boolean isSatisfiable(boolean globalTimeout) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] model() {
        return ((ISolver)this.solvers.get(this.winnerId)).model();
    }

    @Override
    public boolean model(int var) {
        return ((ISolver)this.solvers.get(this.winnerId)).model(var);
    }

    @Override
    public int nConstraints() {
        return ((ISolver)this.solvers.get(0)).nConstraints();
    }

    @Override
    public int nVars() {
        return ((ISolver)this.solvers.get(0)).nVars();
    }

    @Override
    public void printInfos(PrintWriter out, String prefix) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            out.printf("%s>>>>>>>>>> Solver number %d <<<<<<<<<<<<<<<<<<%n", prefix, i);
            ((ISolver)this.solvers.get(i)).printInfos(out, prefix);
            ++i;
        }
    }

    @Override
    public synchronized void onFinishWithAnswer(boolean finished, boolean result, int index) {
        if (finished && !this.solved) {
            this.winnerId = index;
            this.solversStats.get(index).inc();
            this.solved = true;
            this.resultFound = result;
            int i = 0;
            while (i < this.numberOfSolvers) {
                if (i != this.winnerId) {
                    ((ISolver)this.solvers.get(i)).expireTimeout();
                }
                ++i;
            }
            this.sleepTime = 50;
            System.out.println(String.valueOf(this.getLogPrefix()) + "And the winner is " + this.availableSolvers[this.winnerId]);
        }
        this.remainingSolvers.getAndDecrement();
    }

    @Override
    public boolean isDBSimplificationAllowed() {
        return ((ISolver)this.solvers.get(0)).isDBSimplificationAllowed();
    }

    @Override
    public void setDBSimplificationAllowed(boolean status) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(0)).setDBSimplificationAllowed(status);
            ++i;
        }
    }

    public <I extends ISolverService> void setSearchListener(SearchListener<I> sl) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).setSearchListener(sl);
            ++i;
        }
    }

    public <I extends ISolverService> SearchListener<I> getSearchListener() {
        return ((ISolver)this.solvers.get(0)).getSearchListener();
    }

    @Override
    public int nextFreeVarId(boolean reserve) {
        int res = -1;
        int i = 0;
        while (i < this.numberOfSolvers) {
            res = ((ISolver)this.solvers.get(i)).nextFreeVarId(reserve);
            ++i;
        }
        return res;
    }

    @Override
    public IConstr addBlockingClause(IVecInt literals) throws ContradictionException {
        ConstrGroup group = new ConstrGroup(false);
        int i = 0;
        while (i < this.numberOfSolvers) {
            group.add(((ISolver)this.solvers.get(i)).addBlockingClause(literals));
            ++i;
        }
        return group;
    }

    @Override
    public boolean removeSubsumedConstr(IConstr c) {
        if (c instanceof ConstrGroup) {
            ConstrGroup group = (ConstrGroup)c;
            boolean removed = true;
            int i = 0;
            while (i < this.numberOfSolvers) {
                IConstr toRemove = group.getConstr(i);
                if (toRemove != null) {
                    removed &= ((ISolver)this.solvers.get(i)).removeSubsumedConstr(toRemove);
                }
                ++i;
            }
            return removed;
        }
        throw new IllegalArgumentException("Can only remove a group of constraints!");
    }

    @Override
    public boolean isVerbose() {
        return ((ISolver)this.solvers.get(0)).isVerbose();
    }

    @Override
    public void setVerbose(boolean value) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).setVerbose(value);
            ++i;
        }
    }

    @Override
    public void setLogPrefix(String prefix) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).setLogPrefix(prefix);
            ++i;
        }
    }

    @Override
    public String getLogPrefix() {
        return ((ISolver)this.solvers.get(0)).getLogPrefix();
    }

    @Override
    public IVecInt unsatExplanation() {
        return ((ISolver)this.solvers.get(this.winnerId)).unsatExplanation();
    }

    @Override
    public int[] primeImplicant() {
        return ((ISolver)this.solvers.get(this.winnerId)).primeImplicant();
    }

    @Override
    public boolean primeImplicant(int p) {
        return ((ISolver)this.solvers.get(this.winnerId)).primeImplicant(p);
    }

    public List<S> getSolvers() {
        return new ArrayList<S>(this.solvers);
    }

    @Override
    public int[] modelWithInternalVariables() {
        return ((ISolver)this.solvers.get(this.winnerId)).modelWithInternalVariables();
    }

    @Override
    public int realNumberOfVariables() {
        return ((ISolver)this.solvers.get(0)).realNumberOfVariables();
    }

    @Override
    public void registerLiteral(int p) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).registerLiteral(p);
            ++i;
        }
    }

    @Override
    public boolean isSolverKeptHot() {
        return ((ISolver)this.solvers.get(0)).isSolverKeptHot();
    }

    @Override
    public void setKeepSolverHot(boolean value) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(i)).setKeepSolverHot(value);
            ++i;
        }
    }

    @Override
    public ISolver getSolvingEngine() {
        throw new UnsupportedOperationException("Not supported yet in ManyCore");
    }

    @Override
    public void printStat(PrintWriter out) {
        this.printStat(out, this.getLogPrefix());
    }

    @Override
    public void printInfos(PrintWriter out) {
        int i = 0;
        while (i < this.numberOfSolvers) {
            out.printf("%s>>>>>>>>>> Solver number %d <<<<<<<<<<<<<<<<<<%n", this.getLogPrefix(), i);
            ((ISolver)this.solvers.get(i)).printInfos(out);
            ++i;
        }
    }

    @Override
    public synchronized void learnUnit(int p) {
        this.sharedUnitClauses.push(LiteralsUtils.toInternal(p));
    }

    @Override
    public synchronized void provideUnitClauses(UnitPropagationListener upl) {
        int i = 0;
        while (i < this.sharedUnitClauses.size()) {
            upl.enqueue(this.sharedUnitClauses.get(i));
            ++i;
        }
    }

    @Override
    public void setUnitClauseProvider(UnitClauseProvider ucp) {
        throw new UnsupportedOperationException("Does not make sense in the parallel context");
    }
}

