/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysis;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysisReport;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler.HandlerUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler.Messages;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler.ParameterDialog;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiReportViewFactory;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.IOnDemandAnalysis;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.IOnDemandAnalysisReport;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOnDemandAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfReportsElement;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RunAnalysisHandler
extends AbstractHandler {
    public boolean isEnabled() {
        Object element = HandlerUtils.getSelectedModelElement();
        if (element == null) {
            return false;
        }
        TmfOnDemandAnalysisElement elem = (TmfOnDemandAnalysisElement)element;
        return elem.getAnalysis() instanceof LamiAnalysis && elem.canRun();
    }

    public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Object element = ((IStructuredSelection)selection).getFirstElement();
        final TmfOnDemandAnalysisElement analysisElem = (TmfOnDemandAnalysisElement)element;
        TmfCommonProjectElement traceElem = analysisElem.getParent().getParent();
        final ITmfTrace trace = traceElem.getTrace();
        if (trace == null) {
            return null;
        }
        IOnDemandAnalysis ondemandAnalysis = analysisElem.getAnalysis();
        if (!(ondemandAnalysis instanceof LamiAnalysis)) {
            return null;
        }
        final LamiAnalysis analysis = (LamiAnalysis)ondemandAnalysis;
        TmfTraceManager tm = TmfTraceManager.getInstance();
        TmfTimeRange timeRange = tm.getCurrentTraceContext().getSelectionRange();
        if (timeRange.getStartTime().equals(timeRange.getEndTime())) {
            timeRange = null;
        }
        final TmfTimeRange tr = timeRange;
        String baseCommand = analysis.getFullCommandAsString(trace, tr);
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ParameterDialog dialog = new ParameterDialog(shell, Messages.ParameterDialog_ExternalParameters, Messages.ParameterDialog_ExternalParametersDescription, baseCommand, null);
        if (dialog.open() != 0) {
            return null;
        }
        final String extraParams = NonNullUtils.nullToEmptyString((Object)dialog.getValue());
        Job job = new Job(Messages.LamiAnalysis_MainTaskName){

            protected @Nullable IStatus run(@Nullable IProgressMonitor monitor) {
                IProgressMonitor mon = monitor == null ? new NullProgressMonitor() : monitor;
                try {
                    List results = analysis.execute(trace, tr, extraParams, mon);
                    String reportName = String.valueOf(analysis.getName()) + ' ' + Messages.ParameterDialog_ReportNameSuffix;
                    LamiAnalysisReport report = new LamiAnalysisReport(reportName, results);
                    RunAnalysisHandler.this.registerNewReport(analysisElem, (IOnDemandAnalysisReport)report);
                    Display.getDefault().syncExec(() -> {
                        try {
                            LamiReportViewFactory.createNewView(report);
                        }
                        catch (PartInitException partInitException) {
                            // empty catch block
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    String dialogMessage;
                    String dialogTitle;
                    IStatus status = e.getStatus();
                    if (status.matches(8)) {
                        return status;
                    }
                    if (status.matches(4)) {
                        dialogTitle = Messages.ErrorDialog_Error;
                        dialogMessage = Messages.ErrorDialog_ErrorMessage;
                    } else {
                        dialogTitle = Messages.ErrorDialog_Info;
                        dialogMessage = Messages.ErrorDialog_InfoMessage;
                    }
                    Display.getDefault().asyncExec(() -> ErrorDialog.openError((Shell)shell, (String)dialogTitle, (String)dialogMessage, (IStatus)status));
                    return Status.OK_STATUS;
                }
            }
        };
        job.schedule();
        return null;
    }

    public void registerNewReport(TmfOnDemandAnalysisElement analysisElem, IOnDemandAnalysisReport report) {
        TmfReportsElement reportsElement = analysisElem.getParent().getParent().getChildElementReports();
        reportsElement.addReport(report);
    }
}

