/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.index.CPPTypedefClone;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPTypedef
extends PDOMCPPBinding
implements ITypedef,
ITypeContainer,
IIndexType {
    private static final int TYPE_OFFSET = 32;
    protected static final int RECORD_SIZE = 38;

    public PDOMCPPTypedef(PDOMLinkage linkage, PDOMNode parent, ITypedef typedef) throws CoreException {
        super(linkage, parent, typedef.getNameCharArray());
        this.setType(parent.getLinkage(), typedef.getType());
    }

    public PDOMCPPTypedef(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ITypedef) {
            ITypedef td = (ITypedef)newBinding;
            this.setType(linkage, td.getType());
        }
    }

    private void setType(PDOMLinkage linkage, IType newType) throws CoreException {
        linkage.storeType(this.record + 32L, newType);
        if (PDOMCPPTypedef.introducesRecursion(this.getType(), this.getParentNodeRec(), this.getNameCharArray())) {
            linkage.storeType(this.record + 32L, null);
        }
    }

    static boolean introducesRecursion(IType type, long parentRec, char[] tdname) {
        int maxDepth = 50;
        while (--maxDepth > 0) {
            if (type instanceof ITypedef) {
                try {
                    if ((!(type instanceof PDOMNode) || ((PDOMNode)((Object)type)).getParentNodeRec() == parentRec) && CharArrayUtils.equals(((ITypedef)type).getNameCharArray(), tdname)) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    return true;
                }
            }
            if (type instanceof ITypeContainer) {
                type = ((ITypeContainer)type).getType();
                continue;
            }
            if (type instanceof IFunctionType) {
                IType[] params;
                IFunctionType ft = (IFunctionType)type;
                if (PDOMCPPTypedef.introducesRecursion(ft.getReturnType(), parentRec, tdname)) {
                    return true;
                }
                IType[] iTypeArray = params = ft.getParameterTypes();
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    IType param = iTypeArray[n2];
                    if (PDOMCPPTypedef.introducesRecursion(param, parentRec, tdname)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    protected int getRecordSize() {
        return 38;
    }

    @Override
    public int getNodeType() {
        return 17;
    }

    @Override
    public IType getType() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadType(this.record + 32L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public boolean isSameType(IType type) {
        IType myrtype = this.getType();
        if (myrtype == null) {
            return false;
        }
        if (type instanceof ITypedef && (type = ((ITypedef)type).getType()) == null) {
            return false;
        }
        return myrtype.isSameType(type);
    }

    @Override
    public void setType(IType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        return new CPPTypedefClone(this);
    }

    @Override
    protected String toStringBase() {
        return String.valueOf(ASTTypeUtil.getQualifiedName(this)) + " -> " + super.toStringBase();
    }
}

