/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsExecutionGraphProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsSystemModel;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.BaseHandler;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.Messages;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.EventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class TraceEventHandlerSched
extends BaseHandler {
    private static final String TASK_UNKNOWN = "Unknown";

    public TraceEventHandlerSched(OsExecutionGraphProvider provider, int priority) {
        super(provider, priority);
    }

    @Override
    public void handleEvent(ITmfEvent ev) {
        IKernelAnalysisEventLayout eventLayout;
        String eventName = ev.getName();
        if (eventName.equals((eventLayout = this.getProvider().getEventLayout(ev.getTrace())).eventSchedSwitch())) {
            this.handleSchedSwitch(ev);
        } else if (eventName.equals(eventLayout.eventSchedProcessFork())) {
            this.handleSchedProcessFork(ev);
        } else if (eventName.equals(eventLayout.eventSchedProcessExit())) {
            this.handleSchedProcessExit(ev);
        } else if (eventName.equals(eventLayout.eventSchedProcessExec())) {
            this.handleSchedProcessExec(ev);
        } else if (this.isWakeupEvent(ev)) {
            this.handleSchedWakeup(ev);
        }
    }

    private void handleSchedSwitch(ITmfEvent event) {
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        OsSystemModel system = this.getProvider().getSystem();
        ITmfEventField content = event.getContent();
        Integer next = (Integer)content.getFieldValue(Integer.class, new String[]{eventLayout.fieldNextTid()});
        Integer prev = (Integer)content.getFieldValue(Integer.class, new String[]{eventLayout.fieldPrevTid()});
        if (next == null || prev == null) {
            return;
        }
        long ts = event.getTimestamp().getValue();
        Integer prev_state = (Integer)content.getFieldValue(Integer.class, new String[]{eventLayout.fieldPrevState()});
        prev_state = prev_state == null ? 0 : prev_state & 3;
        String host = event.getTrace().getHostId();
        system.cacheTidOnCpu(cpu, new HostThread(event.getTrace().getHostId(), next));
        HostThread nextHt = new HostThread(host, next);
        OsWorker nextTask = system.findWorker(nextHt);
        if (nextTask == null) {
            String name = EventField.getOrDefault(event, eventLayout.fieldNextComm(), (String)NonNullUtils.checkNotNull((Object)Messages.TraceEventHandlerSched_UnknownThreadName));
            nextTask = new OsWorker(nextHt, name, ts);
            system.addWorker(nextTask);
        }
        nextTask.setStatus(ProcessStatus.RUN);
        HostThread prevHt = new HostThread(host, prev);
        OsWorker prevTask = system.findWorker(prevHt);
        String name = EventField.getOrDefault(event, eventLayout.fieldPrevComm(), (String)NonNullUtils.checkNotNull((Object)Messages.TraceEventHandlerSched_UnknownThreadName));
        if (prevTask == null) {
            prevTask = new OsWorker(prevHt, name, ts);
            system.addWorker(prevTask);
        } else if (prev != 0) {
            prevTask.setName(name);
        }
        if (prev_state == 0) {
            prevTask.setStatus(ProcessStatus.WAIT_CPU);
        } else {
            prevTask.setStatus(ProcessStatus.WAIT_BLOCKED);
        }
    }

    private void handleSchedProcessFork(ITmfEvent event) {
        String host = event.getTrace().getHostId();
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        OsSystemModel system = this.getProvider().getSystem();
        ITmfEventField content = event.getContent();
        Integer childTid = (Integer)content.getFieldValue(Integer.class, new String[]{eventLayout.fieldChildTid()});
        String name = (String)content.getFieldValue(String.class, new String[]{eventLayout.fieldChildComm()});
        if (childTid == null) {
            return;
        }
        name = name == null ? String.valueOf(childTid) : name;
        long ts = event.getTimestamp().getValue();
        HostThread childHt = new HostThread(host, childTid);
        OsWorker childTask = system.findWorker(childHt);
        if (childTask == null) {
            childTask = new OsWorker(childHt, name, ts);
            system.addWorker(childTask);
        }
        childTask.setStatus(ProcessStatus.WAIT_FORK);
    }

    private void handleSchedWakeup(ITmfEvent event) {
        String host = event.getTrace().getHostId();
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        OsSystemModel system = this.getProvider().getSystem();
        Integer tid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{eventLayout.fieldTid()});
        if (tid == null) {
            return;
        }
        HostThread targetHt = new HostThread(host, tid);
        OsWorker target = system.findWorker(targetHt);
        OsWorker current = system.getWorkerOnCpu(host, cpu);
        if (target == null) {
            String name = EventField.getOrDefault(event, eventLayout.fieldComm(), (String)NonNullUtils.checkNotNull((Object)Messages.TraceEventHandlerSched_UnknownThreadName));
            target = new OsWorker(targetHt, name, event.getTimestamp().getValue());
            system.addWorker(target);
            target.setStatus(ProcessStatus.WAIT_BLOCKED);
        }
        ProcessStatus status = target.getStatus();
        if (current != null && target.getHostThread().equals((Object)current.getHostThread()) || status == ProcessStatus.WAIT_CPU) {
            return;
        }
        if (status == ProcessStatus.WAIT_BLOCKED || status == ProcessStatus.WAIT_FORK || status == ProcessStatus.UNKNOWN) {
            target.setStatus(ProcessStatus.WAIT_CPU);
            return;
        }
    }

    private void handleSchedProcessExit(ITmfEvent event) {
        String host = event.getTrace().getHostId();
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        OsSystemModel system = this.getProvider().getSystem();
        Integer tid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{eventLayout.fieldTid()});
        if (tid == null) {
            return;
        }
        OsWorker task = system.findWorker(new HostThread(host, tid));
        if (task == null) {
            return;
        }
        task.setStatus(ProcessStatus.EXIT);
    }

    private void handleSchedProcessExec(ITmfEvent event) {
        String host = event.getTrace().getHostId();
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        OsSystemModel system = this.getProvider().getSystem();
        String filename = (String)event.getContent().getFieldValue(String.class, new String[]{eventLayout.fieldFilename()});
        OsWorker task = system.getWorkerOnCpu(host, cpu);
        if (task == null) {
            return;
        }
        task.setName(filename == null ? TASK_UNKNOWN : filename);
    }
}

