/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.extension;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.ui.internal.IExtendedSimpleEditor;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISelfValidateEditAction;

public class ExtendedEditorActionProxy
implements InvocationHandler {
    private IExtendedSimpleEditor editor = null;
    private IStructuredModel fRecorder;
    private Object obj;

    public static Object newInstance(Object obj) {
        HashSet set = new HashSet();
        Class<?> clazz = obj.getClass();
        while (clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                set.add(interfaces[i]);
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        Class[] classes = new Class[set.size()];
        Iterator itr = set.iterator();
        int i = 0;
        while (itr.hasNext()) {
            classes[i] = (Class)itr.next();
            ++i;
        }
        return Proxy.newProxyInstance(obj.getClass().getClassLoader(), classes, (InvocationHandler)new ExtendedEditorActionProxy(obj));
    }

    private ExtendedEditorActionProxy(Object obj) {
        this.obj = obj;
    }

    private void beginRecording() {
        IDocument document = null;
        if (this.editor != null) {
            IStructuredTextUndoManager um;
            document = this.editor.getDocument();
            if (document != null) {
                this.fRecorder = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
            }
            if (this.fRecorder != null && (um = this.fRecorder.getUndoManager()) != null) {
                um.beginRecording((Object)this, ((IAction)this.obj).getText(), ((IAction)this.obj).getDescription());
            }
        }
    }

    private void endRecording() {
        if (this.fRecorder != null) {
            IStructuredTextUndoManager um = this.fRecorder.getUndoManager();
            if (um != null) {
                um.endRecording((Object)this);
            }
            this.fRecorder.releaseFromEdit();
            this.fRecorder = null;
        }
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result = null;
        String name = m.getName();
        try {
            if (name.equals("equals")) {
                Object arg = args[0];
                Boolean bl = proxy.getClass() == arg.getClass() && this.equals(Proxy.getInvocationHandler(arg)) ? Boolean.TRUE : Boolean.FALSE;
                return bl;
            }
            try {
                if (name.equals("runWithEvent") || name.equals("run")) {
                    this.beginRecording();
                    if (this.editor != null) {
                        boolean cfr_ignored_0 = this.obj instanceof ISelfValidateEditAction;
                    }
                } else if (name.equals("setActiveExtendedEditor") && args[0] instanceof IExtendedSimpleEditor) {
                    this.editor = (IExtendedSimpleEditor)args[0];
                }
                result = m.invoke(this.obj, args);
            }
            catch (InvocationTargetException e) {
                Logger.logException(e.getTargetException());
            }
            catch (Exception e) {
                Logger.logException(e);
                if (name.equals("runWithEvent") || name.equals("run")) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        finally {
            if (name.equals("runWithEvent") || name.equals("run")) {
                this.endRecording();
            }
        }
        return result;
    }
}

